/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.GeneratableBean;
import org.joda.beans.gen.GeneratableProperty;
import org.joda.beans.gen.GetterGen;
import org.joda.beans.gen.PropertyGen;
import org.joda.beans.impl.direct.DirectBean;
import org.joda.beans.impl.direct.DirectBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

class BeanGen {
    private static final String AUTOGENERATED_START = "\t//------------------------- AUTOGENERATED START -------------------------";
    private static final String AUTOGENERATED_END = "\t//-------------------------- AUTOGENERATED END --------------------------";
    private static final Pattern BEAN_TYPE = Pattern.compile(".*class (([A-Z][A-Za-z0-9_]+)(?:<([A-Z])( extends [A-Za-z0-9_]+)?>)?) .*");
    private static final Pattern SUPER_TYPE = Pattern.compile(".* extends (([A-Z][A-Za-z0-9_]+)(?:<([A-Z][A-Za-z0-9_<> ]*)>)?).*");
    private final List<String> content;
    private final String indent;
    private final String prefix;
    private final int autoStartIndex;
    private final int autoEndIndex;
    private final List<String> insertRegion;
    private final List<PropertyGen> properties;
    private final GeneratableBean data;

    BeanGen(List<String> content, String indent, String prefix) {
        this.content = content;
        this.indent = indent;
        this.prefix = prefix;
        int beanDefIndex = this.parseBeanDefinition();
        if (beanDefIndex >= 0) {
            this.data = new GeneratableBean();
            this.data.getCurrentImports().addAll(this.parseImports(beanDefIndex));
            this.data.setImportInsertLocation(this.parseImportLocation(beanDefIndex));
            this.data.setConstructable(this.parseConstructable(beanDefIndex));
            this.data.setTypeParts(this.parseBeanType(beanDefIndex));
            this.data.setSuperTypeParts(this.parseBeanSuperType(beanDefIndex));
            this.properties = this.parseProperties(this.data);
            this.autoStartIndex = this.parseStartAutogen();
            this.autoEndIndex = this.parseEndAutogen();
            this.insertRegion = content.subList(this.autoStartIndex + 1, this.autoEndIndex);
            this.data.setManualEqualsHashCode(this.parseManualEqualsHashCode(beanDefIndex));
        } else {
            this.autoStartIndex = -1;
            this.autoEndIndex = -1;
            this.insertRegion = null;
            this.data = null;
            this.properties = null;
        }
    }

    void process() {
        if (this.insertRegion != null) {
            this.removeOld();
            if (!this.data.isSubclass()) {
                this.data.ensureImport(DirectBean.class);
            }
            this.insertRegion.add("\t///CLOVER:OFF");
            this.generateMeta();
            this.generateMetaBean();
            this.generatePropertyGet();
            this.generatePropertySet();
            if (this.data.isValidated()) {
                this.generateValidate();
            }
            if (!this.data.isManualEqualsHashCode()) {
                this.generateEquals();
                this.generateHashCode();
            }
            this.generateGettersSetters();
            this.generateMetaClass();
            this.insertRegion.add("\t///CLOVER:ON");
            this.resolveImports();
            this.resolveIndents();
        }
    }

    private void resolveImports() {
        if (this.data.getNewImports().size() > 0) {
            int pos = this.data.getImportInsertLocation() + 1;
            for (String imp : this.data.getNewImports()) {
                this.content.add(pos++, "import " + imp + ";");
            }
        }
    }

    private void resolveIndents() {
        ListIterator<String> it = this.content.listIterator();
        while (it.hasNext()) {
            it.set(it.next().replace("\t", this.indent));
        }
    }

    private int parseBeanDefinition() {
        for (int index = 0; index < this.content.size(); ++index) {
            String line = this.content.get(index).trim();
            if (!line.startsWith("@BeanDefinition")) continue;
            return index;
        }
        return -1;
    }

    private Set<String> parseImports(int defLine) {
        HashSet<String> imports = new HashSet<String>();
        for (int index = 0; index < defLine; ++index) {
            if (!this.content.get(index).startsWith("import ")) continue;
            String imp = this.content.get(index).substring(7).trim();
            if ((imp = imp.substring(0, imp.indexOf(59))).endsWith(".*")) continue;
            imports.add(imp);
        }
        return imports;
    }

    private int parseImportLocation(int defLine) {
        int location = 0;
        for (int index = 0; index < defLine; ++index) {
            if (!this.content.get(index).startsWith("import ") && !this.content.get(index).startsWith("package ")) continue;
            location = index;
        }
        return location;
    }

    private boolean parseConstructable(int defLine) {
        for (int index = defLine; index < this.content.size(); ++index) {
            if (!this.content.get(index).contains(" abstract class ")) continue;
            return false;
        }
        return true;
    }

    private String[] parseBeanType(int defLine) {
        Matcher matcher = BEAN_TYPE.matcher("");
        for (int index = defLine; index < this.content.size(); ++index) {
            matcher.reset(this.content.get(index));
            if (!matcher.matches()) continue;
            return new String[]{matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)};
        }
        throw new RuntimeException("Unable to locate bean class name");
    }

    private String[] parseBeanSuperType(int defLine) {
        Matcher matcher = SUPER_TYPE.matcher("");
        for (int index = defLine; index < this.content.size(); ++index) {
            matcher.reset(this.content.get(index));
            if (!matcher.matches()) continue;
            return new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
        }
        throw new RuntimeException("Unable to locate bean superclass");
    }

    private List<PropertyGen> parseProperties(GeneratableBean data) {
        ArrayList<PropertyGen> props = new ArrayList<PropertyGen>();
        for (int index = 0; index < this.content.size(); ++index) {
            PropertyGen prop;
            String line = this.content.get(index).trim();
            if (line.startsWith("@PropertyDefinition")) {
                prop = new PropertyGen(this, this.content, index, false);
                props.add(prop);
                data.getProperties().add(prop.getData());
                continue;
            }
            if (!line.startsWith("@DerivedProperty")) continue;
            prop = new PropertyGen(this, this.content, index, true);
            props.add(prop);
            data.getProperties().add(prop.getData());
        }
        return props;
    }

    private int parseStartAutogen() {
        String line;
        int index;
        for (index = 0; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.contains(" AUTOGENERATED START ")) continue;
            this.content.set(index, AUTOGENERATED_START);
            return index;
        }
        for (index = this.content.size() - 1; index >= 0; --index) {
            line = this.content.get(index).trim();
            if (line.equals("}")) {
                this.content.add(index, AUTOGENERATED_START);
                return index;
            }
            if (line.length() > 0) break;
        }
        throw new RuntimeException("Unable to locate start autogeneration point");
    }

    private int parseEndAutogen() {
        for (int index = this.autoStartIndex; index < this.content.size(); ++index) {
            String line = this.content.get(index).trim();
            if (!line.contains(" AUTOGENERATED END ")) continue;
            this.content.set(index, AUTOGENERATED_END);
            return index;
        }
        this.content.add(this.autoStartIndex + 1, AUTOGENERATED_END);
        return this.autoStartIndex + 1;
    }

    private void removeOld() {
        this.insertRegion.clear();
    }

    private boolean parseManualEqualsHashCode(int defLine) {
        String line;
        int index;
        for (index = defLine; index < this.autoStartIndex; ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public int hashCode() {") && (!line.startsWith("public boolean equals(") || !line.endsWith(") {"))) continue;
            return true;
        }
        for (index = this.autoEndIndex; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public int hashCode() {") && (!line.startsWith("public boolean equals(") || !line.endsWith(") {"))) continue;
            return true;
        }
        return false;
    }

    private void generateSeparator() {
        this.insertRegion.add("\t//-----------------------------------------------------------------------");
    }

    private void generateMeta() {
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t * @return the meta-bean, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\t@SuppressWarnings(\"rawtypes\")");
            this.insertRegion.add("\tpublic static " + this.data.getTypeRaw() + ".Meta meta() {");
        } else {
            this.insertRegion.add("\t * @return the meta-bean, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tpublic static " + this.data.getTypeRaw() + ".Meta meta() {");
        }
        this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
        this.insertRegion.add("\t}");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.insertRegion.add("\t * @param <R>  the bean's generic type");
            this.insertRegion.add("\t * @param cls  the bean's generic type");
            this.insertRegion.add("\t * @return the meta-bean, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
            this.insertRegion.add("\tpublic static <R" + this.data.getTypeGenericExtends() + "> " + this.data.getTypeRaw() + ".Meta<R> meta" + this.data.getTypeRaw() + "(Class<R> cls) {");
            this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            this.insertRegion.add("\t}");
        }
        this.insertRegion.add("\tstatic {");
        this.insertRegion.add("\t\tJodaBeanUtils.registerMetaBean(" + this.data.getTypeRaw() + ".Meta.INSTANCE);");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateMetaBean() {
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
        }
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic " + this.data.getTypeRaw() + ".Meta" + this.data.getTypeGenericName(true) + " metaBean() {");
        this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateGettersSetters() {
        for (PropertyGen prop : this.properties) {
            this.generateSeparator();
            this.insertRegion.addAll(prop.generateGetter());
            this.insertRegion.addAll(prop.generateSetter());
            this.insertRegion.addAll(prop.generateProperty());
        }
    }

    private void generatePropertyGet() {
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tprotected Object propertyGet(String propertyName, boolean quiet) {");
        if (this.properties.size() > 0) {
            this.insertRegion.add("\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen prop : this.properties) {
                this.insertRegion.addAll(prop.generatePropertyGetCase());
            }
            this.insertRegion.add("\t\t}");
        }
        this.insertRegion.add("\t\treturn super.propertyGet(propertyName, quiet);");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generatePropertySet() {
        boolean generics = false;
        for (GeneratableProperty generatableProperty : this.data.getProperties()) {
            generics |= generatableProperty.getReadWrite().isWritable() && generatableProperty.isGeneric() && !generatableProperty.isGenericWildcardParamType();
        }
        if (generics) {
            this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
        }
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tprotected void propertySet(String propertyName, Object newValue, boolean quiet) {");
        if (this.properties.size() > 0) {
            this.insertRegion.add("\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen propertyGen : this.properties) {
                this.insertRegion.addAll(propertyGen.generatePropertySetCase());
            }
            this.insertRegion.add("\t\t}");
        }
        this.insertRegion.add("\t\tsuper.propertySet(propertyName, newValue, quiet);");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateValidate() {
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tprotected void validate() {");
        for (PropertyGen prop : this.properties) {
            if (!prop.getData().isValidated()) continue;
            this.insertRegion.add("\t\t" + prop.getData().getValidationMethodName() + "(" + prop.getData().getFieldName() + ", \"" + prop.getData().getPropertyName() + "\");");
        }
        this.insertRegion.add("\t\tsuper.validate();");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateEquals() {
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic boolean equals(Object obj) {");
        this.insertRegion.add("\t\tif (obj == this) {");
        this.insertRegion.add("\t\t\treturn true;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\tif (obj != null && obj.getClass() == this.getClass()) {");
        if (this.properties.size() == 0) {
            if (this.data.isSubclass()) {
                this.insertRegion.add("\t\t\treturn super.equals(obj);");
            } else {
                this.insertRegion.add("\t\t\treturn true;");
            }
        } else {
            this.insertRegion.add("\t\t\t" + this.data.getTypeWildcard() + " other = (" + this.data.getTypeWildcard() + ") obj;");
            for (int i = 0; i < this.properties.size(); ++i) {
                PropertyGen prop = this.properties.get(i);
                String getter = GetterGen.of(prop.getData()).generateGetInvoke(prop.getData());
                this.insertRegion.add((i == 0 ? "\t\t\treturn " : "\t\t\t\t\t") + "JodaBeanUtils.equal(" + getter + ", other." + getter + ")" + (this.data.isSubclass() || i < this.properties.size() - 1 ? " &&" : ";"));
            }
            if (this.data.isSubclass()) {
                this.insertRegion.add("\t\t\t\t\tsuper.equals(obj);");
            }
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\treturn false;");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateHashCode() {
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic int hashCode() {");
        if (this.data.isSubclass()) {
            this.insertRegion.add("\t\tint hash = 7;");
        } else {
            this.insertRegion.add("\t\tint hash = getClass().hashCode();");
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyGen prop = this.properties.get(i);
            String getter = GetterGen.of(prop.getData()).generateGetInvoke(prop.getData());
            this.insertRegion.add("\t\thash += hash * 31 + JodaBeanUtils.hashCode(" + getter + ");");
        }
        if (this.data.isSubclass()) {
            this.insertRegion.add("\t\treturn hash ^ super.hashCode();");
        } else {
            this.insertRegion.add("\t\treturn hash;");
        }
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateMetaClass() {
        String superMeta;
        this.generateSeparator();
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        this.insertRegion.add("\t */");
        if (this.data.isSubclass()) {
            superMeta = this.data.getSuperTypeRaw() + ".Meta" + this.data.getSuperTypeGeneric(true);
        } else {
            this.data.ensureImport(DirectMetaBean.class);
            superMeta = "DirectMetaBean";
        }
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\tpublic static class Meta" + this.data.getTypeGeneric(true) + " extends " + superMeta + " {");
        } else {
            this.insertRegion.add("\tpublic static class Meta extends " + superMeta + " {");
        }
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * The singleton instance of the meta-bean.");
        this.insertRegion.add("\t\t */");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t@SuppressWarnings(\"rawtypes\")");
        }
        this.insertRegion.add("\t\tstatic final Meta INSTANCE = new Meta();");
        this.insertRegion.add("");
        this.generateMetaPropertyConstants();
        this.generateMetaPropertyMapSetup();
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * Restricted constructor.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\tprotected Meta() {");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        this.generateMetaPropertyGet();
        this.generateMetaBuilder();
        this.generateMetaBeanType();
        this.generateMetaPropertyMap();
        this.insertRegion.add("\t\t//-----------------------------------------------------------------------");
        this.generateMetaPropertyMethods();
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyConstants() {
        for (PropertyGen prop : this.properties) {
            this.insertRegion.addAll(prop.generateMetaPropertyConstant());
        }
    }

    private void generateMetaPropertyMapSetup() {
        this.data.ensureImport(MetaProperty.class);
        this.data.ensureImport(DirectMetaPropertyMap.class);
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * The meta-properties.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\tprivate final Map<String, MetaProperty<?>> " + this.prefix + "metaPropertyMap$ = new DirectMetaPropertyMap(");
        if (this.data.isSubclass()) {
            this.insertRegion.add("\t\t\tthis, (DirectMetaPropertyMap) super.metaPropertyMap()" + (this.properties.size() == 0 ? ");" : ","));
        } else {
            this.insertRegion.add("\t\t\t\tthis, null" + (this.properties.size() == 0 ? ");" : ","));
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            String line = "\t\t\t\t\"" + this.properties.get(i).getData().getPropertyName() + "\"";
            line = line + (i + 1 == this.properties.size() ? ");" : ",");
            this.insertRegion.add(line);
        }
        this.insertRegion.add("");
    }

    private void generateMetaBuilder() {
        this.data.ensureImport(BeanBuilder.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic BeanBuilder<? extends " + this.data.getTypeNoExtends() + "> builder() {");
        if (this.data.isConstructable()) {
            this.data.ensureImport(DirectBeanBuilder.class);
            this.insertRegion.add("\t\t\treturn new DirectBeanBuilder<" + this.data.getTypeNoExtends() + ">(new " + this.data.getTypeNoExtends() + "());");
        } else {
            this.insertRegion.add("\t\t\tthrow new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaBeanType() {
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Class<? extends " + this.data.getTypeNoExtends() + "> beanType() {");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t\treturn (Class) " + this.data.getTypeRaw() + ".class;");
        } else {
            this.insertRegion.add("\t\t\treturn " + this.data.getTypeNoExtends() + ".class;");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyGet() {
        if (this.properties.size() > 0) {
            this.data.ensureImport(MetaProperty.class);
            this.insertRegion.add("\t\t@Override");
            this.insertRegion.add("\t\tprotected MetaProperty<?> metaPropertyGet(String propertyName) {");
            this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen prop : this.properties) {
                this.insertRegion.addAll(prop.generateMetaPropertyGetCase());
            }
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t\treturn super.metaPropertyGet(propertyName);");
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
        }
    }

    private void generateMetaPropertyMap() {
        this.data.ensureImport(Map.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Map<String, MetaProperty<?>> metaPropertyMap() {");
        this.insertRegion.add("\t\t\treturn " + this.prefix + "metaPropertyMap$;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyMethods() {
        for (PropertyGen prop : this.properties) {
            this.insertRegion.addAll(prop.generateMetaProperty());
        }
    }

    boolean isBean() {
        return this.data != null;
    }

    GeneratableBean getData() {
        return this.data;
    }

    String getFieldPrefix() {
        return this.prefix;
    }
}

