/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.beans.PropertyReadWrite;
import org.joda.beans.gen.GeneratableBean;
import org.joda.beans.gen.SetterGen;

class GeneratableProperty {
    private static final Set<String> COLLECTIONS = new HashSet<String>(Arrays.asList("Collection", "Set", "SortedSet", "NavigableSet", "List", "ArrayList", "LinkedList", "HashSet", "LinkedHashSet", "TreeSet", "ConcurrentSkipListSet"));
    private static final Set<String> MAPS = new HashSet<String>(Arrays.asList("Map", "SortedMap", "NavigableMap", "ConcurrentMap", "ConcurrentNavigableMap", "HashMap", "LinkedHashMap", "TreeMap", "ConcurrentHashMap", "ConcurrentSkipListMap"));
    private final GeneratableBean bean;
    private String propertyName;
    private String fieldName;
    private String upperName;
    private String type;
    private boolean isFinal;
    private String getStyle;
    private String setStyle;
    private String validation;
    private boolean deprecated;
    private String firstComment;
    private final List<String> comments = new ArrayList<String>();

    GeneratableProperty(GeneratableBean bean) {
        this.bean = bean;
    }

    public GeneratableBean getBean() {
        return this.bean;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getUpperName() {
        return this.upperName;
    }

    public void setUpperName(String upperName) {
        this.upperName = upperName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getGetStyle() {
        return this.getStyle;
    }

    public void setGetStyle(String getStyle) {
        this.getStyle = getStyle;
    }

    public String getSetStyle() {
        return this.setStyle;
    }

    public void setSetStyle(String setStyle) {
        this.setStyle = setStyle;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getFirstComment() {
        return this.firstComment;
    }

    public void setFirstComment(String firstComment) {
        this.firstComment = firstComment;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public boolean isGenericParamType() {
        return this.type.indexOf("<") >= 0;
    }

    public boolean isGenericWildcardParamType() {
        return this.type.endsWith("<?>");
    }

    public String getGenericParamType() {
        int pos = this.type.indexOf("<");
        if (pos < 0) {
            return "";
        }
        return this.type.substring(pos + 1, this.type.length() - 1);
    }

    public String getRawType() {
        int pos = this.type.indexOf("<");
        return pos < 0 ? this.type : this.type.substring(0, pos);
    }

    public boolean isBeanGenericType() {
        return this.type.equals(this.bean.getTypeGenericName(false));
    }

    public boolean isGeneric() {
        return this.isGenericParamType() || this.isBeanGenericType();
    }

    public boolean isDerived() {
        return this.fieldName == null;
    }

    public boolean isCollectionType() {
        return this.isGeneric() && COLLECTIONS.contains(this.getRawType());
    }

    public boolean isMapType() {
        return "FlexiBean".equals(this.getType()) || this.isGeneric() && MAPS.contains(this.getRawType());
    }

    public PropertyReadWrite getReadWrite() {
        SetterGen generator = SetterGen.of(this);
        if (this.getGetStyle().length() > 0 && this.getSetStyle().length() > 0 && (generator.isSetterGenerated(this) || this.getSetStyle().equals("manual"))) {
            return PropertyReadWrite.READ_WRITE;
        }
        if (this.getGetStyle().length() > 0) {
            return PropertyReadWrite.READ_ONLY;
        }
        if (this.getSetStyle().length() > 0) {
            return PropertyReadWrite.WRITE_ONLY;
        }
        throw new RuntimeException("Property must have a getter or setter: " + this.propertyName);
    }

    public boolean isValidated() {
        return this.getValidation() != null && this.getValidation().length() > 0;
    }

    public boolean isNotNull() {
        return this.getValidation().equals("notNull") || this.getValidation().equals("notEmpty");
    }

    public String getValidationMethodName() {
        if (!this.isValidated()) {
            throw new IllegalStateException();
        }
        if (this.getValidation().equals("notNull") || this.getValidation().equals("notEmpty")) {
            return "JodaBeanUtils." + this.getValidation();
        }
        return this.getValidation();
    }
}

