/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.beans.gen.GeneratableProperty;

abstract class GetterGen {
    static final Map<String, GetterGen> GETTERS = new HashMap<String, GetterGen>();

    GetterGen() {
    }

    static GetterGen of(GeneratableProperty prop) {
        GetterGen gen = GETTERS.get(prop.getGetStyle());
        if (gen == null) {
            throw new RuntimeException("Unable to locate getter generator '" + prop.getGetStyle() + "'");
        }
        return gen;
    }

    abstract List<String> generateGetter(GeneratableProperty var1);

    String generateGetInvoke(GeneratableProperty prop) {
        return "get" + prop.getUpperName() + "()";
    }

    private static final List<String> doGenerateGetter(GeneratableProperty prop, String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t/**");
        list.add("\t * Gets " + prop.getFirstComment());
        for (String comment : prop.getComments()) {
            list.add("\t * " + comment);
        }
        list.add("\t * @return the value of the property" + (prop.isNotNull() ? ", not null" : ""));
        list.add("\t */");
        if (prop.isDeprecated()) {
            list.add("\t@Deprecated");
        }
        list.add("\tpublic " + prop.getType() + " " + prefix + prop.getUpperName() + "() {");
        list.add("\t\treturn " + prop.getFieldName() + ";");
        list.add("\t}");
        list.add("");
        return list;
    }

    static {
        GETTERS.put("", NoGetterGen.INSTANCE);
        GETTERS.put("smart", SmartGetterGen.INSTANCE);
        GETTERS.put("get", GetGetterGen.INSTANCE);
        GETTERS.put("is", IsGetterGen.INSTANCE);
        GETTERS.put("manual", ManualGetterGen.INSTANCE);
    }

    static class NoGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new NoGetterGen();

        NoGetterGen() {
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return Collections.emptyList();
        }

        @Override
        String generateGetInvoke(GeneratableProperty prop) {
            return prop.getFieldName();
        }
    }

    static class ManualGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new ManualGetterGen();

        ManualGetterGen() {
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return Collections.emptyList();
        }
    }

    static class IsGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new IsGetterGen();

        IsGetterGen() {
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return GetterGen.doGenerateGetter(prop, "is");
        }

        @Override
        String generateGetInvoke(GeneratableProperty prop) {
            return "is" + prop.getUpperName() + "()";
        }
    }

    static class GetGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new GetGetterGen();

        GetGetterGen() {
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return GetterGen.doGenerateGetter(prop, "get");
        }
    }

    static class SmartGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new SmartGetterGen();

        SmartGetterGen() {
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            if (prop.getType().equals("boolean")) {
                return IsGetterGen.INSTANCE.generateGetter(prop);
            }
            return GetGetterGen.INSTANCE.generateGetter(prop);
        }

        @Override
        String generateGetInvoke(GeneratableProperty prop) {
            if (prop.getType().equals("boolean")) {
                return IsGetterGen.INSTANCE.generateGetInvoke(prop);
            }
            return GetGetterGen.INSTANCE.generateGetInvoke(prop);
        }
    }
}

