/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.gen.BeanGen;
import org.joda.beans.gen.GeneratableProperty;
import org.joda.beans.gen.GetterGen;
import org.joda.beans.gen.SetterGen;
import org.joda.beans.impl.direct.DirectMetaProperty;

class PropertyGen {
    private static final Pattern GETTER_PATTERN = Pattern.compile(".*[ ,(]get[ ]*[=][ ]*[\"]([a-zA-Z-]*)[\"].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile(".*[ ,(]set[ ]*[=][ ]*[\"]([a-zA-Z-]*)[\"].*");
    private static final Pattern VALIDATION_PATTERN = Pattern.compile(".*[ ,(]validate[ ]*[=][ ]*[\"]([a-zA-Z_.]*)[\"].*");
    private final int annotationIndex;
    private final int fieldIndex;
    private final BeanGen bean;
    private final GeneratableProperty data;

    public PropertyGen(BeanGen bean, List<String> content, int lineIndex, boolean derived) {
        this.bean = bean;
        this.annotationIndex = lineIndex;
        this.fieldIndex = this.parseCodeIndex(content);
        GeneratableProperty prop = new GeneratableProperty(bean.getData());
        if (derived) {
            prop.setGetStyle("manual");
            prop.setSetStyle("");
            prop.setDeprecated(this.parseDeprecated(content));
            prop.setPropertyName(this.parseMethodNameAsPropertyName(content));
            prop.setUpperName(this.makeUpperName(prop.getPropertyName()));
            prop.setType(this.parseMethodType(content));
        } else {
            prop.setGetStyle(this.parseGetStyle(content));
            prop.setSetStyle(this.parseSetStyle(content));
            prop.setValidation(this.parseValidation(content));
            prop.setDeprecated(this.parseDeprecated(content));
            prop.setFieldName(this.parseFieldName(content));
            prop.setPropertyName(this.makePropertyName(bean, prop.getFieldName()));
            prop.setUpperName(this.makeUpperName(prop.getPropertyName()));
            prop.setFinal(this.parseFinal(content));
            prop.setType(this.parseFieldType(content));
        }
        List<String> comments = this.parseComment(content, prop.getPropertyName());
        prop.setFirstComment(comments.get(0));
        prop.getComments().addAll(comments.subList(1, comments.size()));
        this.data = prop;
    }

    private String makePropertyName(BeanGen bean, String name) {
        if (name.startsWith(bean.getFieldPrefix())) {
            name = name.substring(bean.getFieldPrefix().length());
        }
        return name;
    }

    private String makeUpperName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private int parseCodeIndex(List<String> content) {
        for (int index = this.annotationIndex; index < content.size(); ++index) {
            if (content.get(index).trim().startsWith("@")) continue;
            if (content.get(index).trim().length() == 0) {
                throw new RuntimeException("Unable to locate field for property at line " + this.annotationIndex + ", found blank line");
            }
            return index;
        }
        throw new RuntimeException("Unable to locate field for property at line " + this.annotationIndex);
    }

    private String parseGetStyle(List<String> content) {
        String line = content.get(this.annotationIndex).trim();
        Matcher matcher = GETTER_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseSetStyle(List<String> content) {
        String line = content.get(this.annotationIndex).trim();
        Matcher matcher = SETTER_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseValidation(List<String> content) {
        String line = content.get(this.annotationIndex).trim();
        Matcher matcher = VALIDATION_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private boolean parseDeprecated(List<String> content) {
        for (int index = this.annotationIndex + 1; index < this.fieldIndex; ++index) {
            String line = content.get(index).trim();
            if (!line.equals("@Deprecated") && !line.startsWith("@Deprecated ")) continue;
            return true;
        }
        return false;
    }

    private String parseFieldName(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        String last = parts[parts.length - 1];
        if (last.endsWith(";") && last.length() > 1) {
            return last.substring(0, last.length() - 1);
        }
        throw new RuntimeException("Unable to locate field name at line " + this.annotationIndex);
    }

    private boolean parseFinal(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            throw new RuntimeException("Unable to locate field type at line " + this.annotationIndex);
        }
        String first = parts[0];
        String second = parts[1];
        return first.equals("final") || second.equals("final");
    }

    private String parseFieldType(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            throw new RuntimeException("Unable to locate field type at line " + this.annotationIndex);
        }
        int partsPos = parts.length - 2;
        String type = parts[partsPos];
        while (true) {
            int closePos = 0;
            closePos = 0;
            int close = 0;
            int openPos = 0;
            int open = 0;
            while ((openPos = type.indexOf(60, openPos)) >= 0) {
                ++open;
                ++openPos;
            }
            while ((closePos = type.indexOf(62, closePos)) >= 0) {
                ++close;
                ++closePos;
            }
            if (open == close) break;
            if (partsPos == 0) {
                throw new RuntimeException("Unable to locate field type at line " + this.annotationIndex + ", mismatched generics");
            }
            type = parts[--partsPos] + " " + type;
        }
        return type;
    }

    private String parseFieldDefinition(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.contains(" = ")) {
            line = line.substring(0, line.indexOf(" = ")).trim() + ";";
        }
        return line;
    }

    private String parseMethodNameAsPropertyName(List<String> content) {
        String[] parts = this.parseMethodDefinition(content);
        if (parts[1].length() == 0 || !Character.isUpperCase(parts[1].charAt(0))) {
            throw new RuntimeException("@DerivedProperty method name invalid'");
        }
        return Character.toLowerCase(parts[1].charAt(0)) + parts[1].substring(1);
    }

    private String parseMethodType(List<String> content) {
        String[] parts = this.parseMethodDefinition(content);
        return parts[0];
    }

    private String[] parseMethodDefinition(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.startsWith("public ")) {
            line = line.substring(7).trim();
        } else if (line.startsWith("private ")) {
            line = line.substring(8).trim();
        } else if (line.startsWith("protected ")) {
            line = line.substring(10).trim();
        }
        String lineEnd = "() {";
        if (line.startsWith("abstract ")) {
            line = line.substring(9).trim();
            lineEnd = "();";
        } else if (line.startsWith("final ")) {
            line = line.substring(6).trim();
        } else if (line.startsWith("static ")) {
            throw new RuntimeException("@DerivedProperty method cannot be static");
        }
        int getIndex = line.indexOf(" get");
        if (getIndex < 0) {
            throw new RuntimeException("@DerivedProperty method must start with 'get'");
        }
        if (!line.endsWith(lineEnd)) {
            throw new RuntimeException("@DerivedProperty method must end with '" + lineEnd + "'");
        }
        line = line.substring(0, line.length() - lineEnd.length());
        String[] split = new String[]{line.substring(0, getIndex).trim(), line.substring(getIndex + 4).trim()};
        return split;
    }

    private List<String> parseComment(List<String> content, String propertyName) {
        int endPos;
        int startPos;
        String comment;
        ArrayList<String> comments = new ArrayList<String>();
        String commentEnd = content.get(this.annotationIndex - 1).trim();
        if (commentEnd.equals("*/")) {
            int startCommentIndex = -1;
            for (int index = this.annotationIndex - 1; index >= 0; --index) {
                String line = content.get(index).trim();
                if (!line.equals("/**")) continue;
                startCommentIndex = index + 1;
                break;
            }
            if (startCommentIndex == -1) {
                throw new RuntimeException("Unable to locate comment start at line " + this.annotationIndex);
            }
            if (startCommentIndex < this.annotationIndex - 1) {
                for (int i = startCommentIndex; i < this.annotationIndex - 1; ++i) {
                    String commentLine = content.get(i).trim();
                    if (commentLine.startsWith("*")) {
                        commentLine = commentLine.substring(1).trim();
                    }
                    if (commentLine.startsWith("@return") || commentLine.startsWith("@param") || commentLine.startsWith("@throws") || commentLine.startsWith("@exception")) continue;
                    comments.add(commentLine);
                }
                String firstLine = (String)comments.get(0);
                if (firstLine.length() > 0) {
                    comments.set(0, firstLine.substring(0, 1).toLowerCase() + firstLine.substring(1));
                } else {
                    comments.remove(0);
                }
            }
        } else if (commentEnd.startsWith("/**") && commentEnd.endsWith("*/") && (comment = commentEnd.substring(startPos = commentEnd.indexOf("/**") + 3, endPos = commentEnd.lastIndexOf("*/")).trim()).length() > 0) {
            comments.add(comment.substring(0, 1).toLowerCase() + comment.substring(1));
        }
        if (comments.size() == 0) {
            comments.add("the " + propertyName + ".");
        }
        return comments;
    }

    List<String> generateMetaPropertyConstant() {
        this.data.getBean().ensureImport(MetaProperty.class);
        this.data.getBean().ensureImport(DirectMetaProperty.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t/**");
        list.add("\t\t * The meta-property for the {@code " + this.data.getPropertyName() + "} property.");
        list.add("\t\t */");
        if (this.data.isBeanGenericType()) {
            list.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
            list.add("\t\tprivate final MetaProperty<" + this.data.getBean().getTypeGenericName(false) + "> " + this.metaFieldName() + " = (DirectMetaProperty) DirectMetaProperty.of" + this.readWrite() + "(");
            list.add("\t\t\t\tthis, \"" + this.data.getPropertyName() + "\", " + this.data.getBean().getTypeRaw() + ".class, " + this.actualType() + ");");
        } else {
            String propertyType = this.propertyType();
            if (propertyType.length() == 1) {
                propertyType = "Object";
            }
            if (this.data.isGenericParamType()) {
                list.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
            }
            list.add("\t\tprivate final MetaProperty<" + propertyType + "> " + this.metaFieldName() + " = DirectMetaProperty.of" + this.readWrite() + "(");
            list.add("\t\t\t\tthis, \"" + this.data.getPropertyName() + "\", " + this.data.getBean().getTypeRaw() + ".class, " + this.actualType() + ");");
        }
        return list;
    }

    List<String> generateMetaPropertyGetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        list.add("\t\t\t\t\treturn " + this.metaFieldName() + ";");
        return list;
    }

    List<String> generateGetter() {
        return GetterGen.of(this.data).generateGetter(this.data);
    }

    List<String> generateSetter() {
        return SetterGen.of(this.data).generateSetter(this.data);
    }

    List<String> generateProperty() {
        this.data.getBean().ensureImport(Property.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t/**");
        list.add("\t * Gets the the {@code " + this.data.getPropertyName() + "} property.");
        for (String comment : this.data.getComments()) {
            list.add("\t * " + comment);
        }
        list.add("\t * @return the property, not null");
        list.add("\t */");
        if (this.data.isDeprecated()) {
            list.add("\t@Deprecated");
        }
        list.add("\tpublic final Property<" + this.propertyType() + "> " + this.data.getPropertyName() + "() {");
        list.add("\t\treturn metaBean()." + this.data.getPropertyName() + "().createProperty(this);");
        list.add("\t}");
        list.add("");
        return list;
    }

    List<String> generateMetaProperty() {
        ArrayList<String> list = new ArrayList<String>();
        String propertyType = this.propertyType();
        if (propertyType.length() == 1) {
            propertyType = "Object";
        }
        if (this.data.isBeanGenericType()) {
            propertyType = this.data.getBean().getTypeGenericName(false);
        }
        list.add("\t\t/**");
        list.add("\t\t * The meta-property for the {@code " + this.data.getPropertyName() + "} property.");
        list.add("\t\t * @return the meta-property, not null");
        list.add("\t\t */");
        if (this.data.isDeprecated()) {
            list.add("\t\t@Deprecated");
        }
        list.add("\t\tpublic final MetaProperty<" + propertyType + "> " + this.data.getPropertyName() + "() {");
        list.add("\t\t\treturn " + this.metaFieldName() + ";");
        list.add("\t\t}");
        list.add("");
        return list;
    }

    List<String> generatePropertyGetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        if (this.data.getReadWrite().isReadable()) {
            list.add("\t\t\t\treturn " + GetterGen.of(this.data).generateGetInvoke(this.data) + ";");
        } else {
            list.add("\t\t\t\tif (quiet) {");
            list.add("\t\t\t\t\treturn null;");
            list.add("\t\t\t\t}");
            list.add("\t\t\t\tthrow new UnsupportedOperationException(\"Property cannot be read: " + this.data.getPropertyName() + "\");");
        }
        return list;
    }

    List<String> generatePropertySetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        String setter = SetterGen.of(this.data).generateSetInvoke(this.data);
        if (this.data.getReadWrite().isWritable() && setter != null) {
            list.add("\t\t\t\t" + setter + "(" + this.castObject() + "newValue);");
            list.add("\t\t\t\treturn;");
        } else {
            list.add("\t\t\t\tif (quiet) {");
            list.add("\t\t\t\t\treturn;");
            list.add("\t\t\t\t}");
            list.add("\t\t\t\tthrow new UnsupportedOperationException(\"Property cannot be written: " + this.data.getPropertyName() + "\");");
        }
        return list;
    }

    private String readWrite() {
        switch (this.data.getReadWrite()) {
            case READ_WRITE: {
                return "ReadWrite";
            }
            case READ_ONLY: {
                return "ReadOnly";
            }
            case WRITE_ONLY: {
                return "WriteOnly";
            }
        }
        throw new RuntimeException("Invalid read-write type");
    }

    private String actualType() {
        String pt = this.propertyType();
        if (pt.equals(this.data.getType())) {
            int genericStart = pt.indexOf(60);
            if (genericStart >= 0) {
                return "(Class) " + pt.substring(0, genericStart) + ".class";
            }
            if (this.data.getType().length() == 1) {
                return "Object.class";
            }
            return pt + ".class";
        }
        return pt + ".TYPE";
    }

    private String castObject() {
        String pt = this.propertyType();
        if (pt.equals(this.data.getType())) {
            return "(" + pt + ") ";
        }
        return "(" + pt + ") ";
    }

    private String propertyType() {
        if (this.data.getType().equals("boolean")) {
            return "Boolean";
        }
        if (this.data.getType().equals("byte")) {
            return "Byte";
        }
        if (this.data.getType().equals("short")) {
            return "Short";
        }
        if (this.data.getType().equals("char")) {
            return "Character";
        }
        if (this.data.getType().equals("int")) {
            return "Integer";
        }
        if (this.data.getType().equals("long")) {
            return "Long";
        }
        if (this.data.getType().equals("float")) {
            return "Float";
        }
        if (this.data.getType().equals("double")) {
            return "Double";
        }
        return this.data.getType();
    }

    private String metaFieldName() {
        return this.bean.getFieldPrefix() + this.data.getPropertyName();
    }

    GeneratableProperty getData() {
        return this.data;
    }
}

