/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.beans.gen.GeneratableProperty;

abstract class SetterGen {
    static final Map<String, SetterGen> SETTERS = new HashMap<String, SetterGen>();

    SetterGen() {
    }

    static SetterGen of(GeneratableProperty prop) {
        SetterGen gen = SETTERS.get(prop.getSetStyle());
        if (gen == null) {
            throw new RuntimeException("Unable to locate setter generator '" + prop.getSetStyle() + "'");
        }
        return gen;
    }

    abstract boolean isSetterGenerated(GeneratableProperty var1);

    abstract List<String> generateSetter(GeneratableProperty var1);

    String generateSetInvoke(GeneratableProperty prop) {
        return "set" + prop.getUpperName();
    }

    private static List<String> doGenerateBulkSetter(GeneratableProperty prop, String alterMethod) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t/**");
        list.add("\t * Sets " + prop.getFirstComment());
        for (String comment : prop.getComments()) {
            list.add("\t * " + comment);
        }
        list.add("\t * @param " + prop.getPropertyName() + "  the new value of the property");
        list.add("\t */");
        if (prop.isDeprecated()) {
            list.add("\t@Deprecated");
        }
        list.add("\tpublic void set" + prop.getUpperName() + "(" + prop.getType() + " " + prop.getPropertyName() + ") {");
        list.add("\t\tthis." + prop.getFieldName() + ".clear();");
        list.add("\t\tthis." + prop.getFieldName() + "." + alterMethod + "(" + prop.getPropertyName() + ");");
        list.add("\t}");
        list.add("");
        return list;
    }

    static {
        SETTERS.put("", NoSetterGen.INSTANCE);
        SETTERS.put("smart", SmartSetterGen.INSTANCE);
        SETTERS.put("set", SetSetterGen.INSTANCE);
        SETTERS.put("setClearAddAll", SetClearAddAllSetterGen.INSTANCE);
        SETTERS.put("setClearPutAll", SetClearPutAllSetterGen.INSTANCE);
        SETTERS.put("manual", NoSetterGen.INSTANCE);
    }

    static class NoSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new NoSetterGen();

        NoSetterGen() {
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            return false;
        }

        @Override
        List<String> generateSetter(GeneratableProperty prop) {
            return Collections.emptyList();
        }
    }

    static class SetClearPutAllSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new SetClearPutAllSetterGen();

        SetClearPutAllSetterGen() {
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            return true;
        }

        @Override
        List<String> generateSetter(GeneratableProperty prop) {
            return SetterGen.doGenerateBulkSetter(prop, "putAll");
        }
    }

    static class SetClearAddAllSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new SetClearAddAllSetterGen();

        SetClearAddAllSetterGen() {
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            return true;
        }

        @Override
        List<String> generateSetter(GeneratableProperty prop) {
            return SetterGen.doGenerateBulkSetter(prop, "addAll");
        }
    }

    static class SetSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new SetSetterGen();

        SetSetterGen() {
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            return true;
        }

        @Override
        List<String> generateSetter(GeneratableProperty prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\t/**");
            list.add("\t * Sets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add("\t * " + comment);
            }
            list.add("\t * @param " + prop.getPropertyName() + "  the new value of the property" + (prop.isNotNull() ? ", not null" : ""));
            list.add("\t */");
            if (prop.isDeprecated()) {
                list.add("\t@Deprecated");
            }
            list.add("\tpublic void set" + prop.getUpperName() + "(" + prop.getType() + " " + prop.getPropertyName() + ") {");
            if (prop.isValidated()) {
                list.add("\t\t" + prop.getValidationMethodName() + "(" + prop.getPropertyName() + ", \"" + prop.getPropertyName() + "\");");
            }
            list.add("\t\tthis." + prop.getFieldName() + " = " + prop.getPropertyName() + ";");
            list.add("\t}");
            list.add("");
            return list;
        }
    }

    static class SmartSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new SmartSetterGen();

        SmartSetterGen() {
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            if (prop.isFinal()) {
                return prop.isCollectionType() || prop.isMapType();
            }
            return SetSetterGen.INSTANCE.isSetterGenerated(prop);
        }

        @Override
        List<String> generateSetter(GeneratableProperty prop) {
            if (prop.isFinal()) {
                if (prop.isCollectionType()) {
                    return SetClearAddAllSetterGen.INSTANCE.generateSetter(prop);
                }
                if (prop.isMapType()) {
                    return SetClearPutAllSetterGen.INSTANCE.generateSetter(prop);
                }
                return Collections.emptyList();
            }
            return SetSetterGen.INSTANCE.generateSetter(prop);
        }

        @Override
        String generateSetInvoke(GeneratableProperty prop) {
            if (prop.isFinal()) {
                if (prop.isCollectionType()) {
                    return SetClearAddAllSetterGen.INSTANCE.generateSetInvoke(prop);
                }
                if (prop.isMapType()) {
                    return SetClearPutAllSetterGen.INSTANCE.generateSetInvoke(prop);
                }
                return null;
            }
            return SetSetterGen.INSTANCE.generateSetInvoke(prop);
        }
    }
}

