/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.impl.BasicProperty;

public abstract class BasicMetaProperty<P>
implements MetaProperty<P> {
    private final String name;

    protected BasicMetaProperty(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new NullPointerException("Property name must not be null or empty");
        }
        this.name = propertyName;
    }

    @Override
    public Property<P> createProperty(Bean bean) {
        return BasicProperty.of(bean, this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public P put(Bean bean, Object value) {
        Object old = this.get(bean);
        this.set(bean, value);
        return old;
    }

    @Override
    public String getString(Bean bean) {
        Object value = this.get(bean);
        return JodaBeanUtils.stringConverter().convertToString(this.propertyType(), value);
    }

    @Override
    public void setString(Bean bean, String value) {
        this.set(bean, JodaBeanUtils.stringConverter().convertFromString(this.propertyType(), value));
    }

    @Override
    public <A extends Annotation> A annotation(Class<A> annotationClass) {
        List<Annotation> annotations = this.annotations();
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        throw new NoSuchElementException("Unknown annotation: " + annotationClass.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MetaProperty) {
            MetaProperty other = (MetaProperty)obj;
            return this.name().equals(other.name()) && this.declaringType().equals(other.declaringType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name().hashCode() ^ this.declaringType().hashCode();
    }

    public String toString() {
        return this.declaringType().getSimpleName() + ":" + this.name();
    }
}

