/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.flexi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.DynamicBean;
import org.joda.beans.MetaBean;
import org.joda.beans.Property;
import org.joda.beans.impl.BasicBean;
import org.joda.beans.impl.BasicProperty;
import org.joda.beans.impl.flexi.FlexiMetaBean;
import org.joda.beans.impl.flexi.FlexiMetaProperty;

public final class FlexiBean
extends BasicBean
implements DynamicBean,
Serializable {
    private static final long serialVersionUID = 1L;
    final FlexiMetaBean metaBean = new FlexiMetaBean(this);
    volatile Map<String, Object> data = Collections.emptyMap();

    public FlexiBean() {
    }

    public FlexiBean(FlexiBean copyFrom) {
        this.putAll(copyFrom.data);
    }

    private Map<String, Object> dataWritable() {
        if (this.data == Collections.EMPTY_MAP) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public boolean contains(String propertyName) {
        return this.propertyExists(propertyName);
    }

    public Object get(String propertyName) {
        return this.data.get(propertyName);
    }

    public <T> T get(String propertyName, Class<T> type) {
        return (T)this.get(propertyName);
    }

    public String getString(String propertyName) {
        Object obj = this.get(propertyName);
        return obj != null ? obj.toString() : null;
    }

    public boolean getBoolean(String propertyName) {
        return (Boolean)this.get(propertyName);
    }

    public int getInt(String propertyName) {
        return ((Number)this.get(propertyName)).intValue();
    }

    public int getInt(String propertyName, int defaultValue) {
        Object obj = this.get(propertyName);
        return obj != null ? ((Number)this.get(propertyName)).intValue() : defaultValue;
    }

    public long getLong(String propertyName) {
        return ((Number)this.get(propertyName)).longValue();
    }

    public long getLong(String propertyName, long defaultValue) {
        Object obj = this.get(propertyName);
        return obj != null ? ((Number)this.get(propertyName)).longValue() : defaultValue;
    }

    public double getDouble(String propertyName) {
        return ((Number)this.get(propertyName)).doubleValue();
    }

    public double getDouble(String propertyName, double defaultValue) {
        Object obj = this.get(propertyName);
        return obj != null ? ((Number)this.get(propertyName)).doubleValue() : defaultValue;
    }

    public FlexiBean append(String propertyName, Object newValue) {
        this.dataWritable().put(propertyName, newValue);
        return this;
    }

    public void set(String propertyName, Object newValue) {
        this.dataWritable().put(propertyName, newValue);
    }

    public Object put(String propertyName, Object newValue) {
        return this.dataWritable().put(propertyName, newValue);
    }

    public void putAll(Map<String, Object> map) {
        if (map.size() > 0) {
            if (this.data == Collections.EMPTY_MAP) {
                this.data = new HashMap<String, Object>(map);
            } else {
                this.data.putAll(map);
            }
        }
    }

    public void putAll(FlexiBean other) {
        if (other.size() > 0) {
            if (this.data == Collections.EMPTY_MAP) {
                this.data = new HashMap<String, Object>(other.data);
            } else {
                this.data.putAll(other.data);
            }
        }
    }

    public void remove(String propertyName) {
        this.propertyRemove(propertyName);
    }

    public void clear() {
        if (this.data != Collections.EMPTY_MAP) {
            this.data.clear();
        }
    }

    public boolean propertyExists(String propertyName) {
        return this.data.containsKey(propertyName);
    }

    public Object propertyGet(String propertyName) {
        if (!this.propertyExists(propertyName)) {
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }
        return this.data.get(propertyName);
    }

    public void propertySet(String propertyName, Object newValue) {
        this.dataWritable().put(propertyName, newValue);
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    public Property<Object> property(String name) {
        if (!this.propertyExists(name)) {
            throw new NoSuchElementException("Unknown property: " + name);
        }
        return BasicProperty.of(this, FlexiMetaProperty.of(this.metaBean, name));
    }

    @Override
    public Set<String> propertyNames() {
        return this.data.keySet();
    }

    @Override
    public void propertyDefine(String propertyName, Class<?> propertyType) {
    }

    @Override
    public void propertyRemove(String propertyName) {
        if (this.data != Collections.EMPTY_MAP) {
            this.data.remove(propertyName);
        }
    }

    public Map<String, Object> toMap() {
        if (this.size() == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.data));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FlexiBean) {
            FlexiBean other = (FlexiBean)obj;
            return ((Object)this.data).equals(other.data);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.data.toString();
    }
}

