/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.flexi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyMap;
import org.joda.beans.impl.BasicBeanBuilder;
import org.joda.beans.impl.flexi.FlexiBean;
import org.joda.beans.impl.flexi.FlexiMetaProperty;
import org.joda.beans.impl.flexi.FlexiPropertyMap;

class FlexiMetaBean
implements MetaBean {
    private final FlexiBean bean;

    FlexiMetaBean(FlexiBean flexiBean) {
        this.bean = flexiBean;
    }

    public BeanBuilder<FlexiBean> builder() {
        return new BasicBeanBuilder<FlexiBean>(new FlexiBean());
    }

    @Override
    public PropertyMap createPropertyMap(Bean bean) {
        return FlexiPropertyMap.of(this.beanType().cast(bean));
    }

    public Class<FlexiBean> beanType() {
        return FlexiBean.class;
    }

    @Override
    public String beanName() {
        return FlexiBean.class.getName();
    }

    @Override
    public int metaPropertyCount() {
        return this.bean.size();
    }

    @Override
    public boolean metaPropertyExists(String name) {
        return this.bean.propertyExists(name);
    }

    public MetaProperty<Object> metaProperty(String name) {
        Object obj = this.bean.get(name);
        if (obj == null) {
            throw new NoSuchElementException("Unknown property: " + name);
        }
        return FlexiMetaProperty.of(this.bean.metaBean, name);
    }

    @Override
    public Iterable<MetaProperty<?>> metaPropertyIterable() {
        if (this.bean.data.isEmpty()) {
            return Collections.emptySet();
        }
        return new Iterable<MetaProperty<?>>(){
            private final Iterator<String> it;
            {
                this.it = ((FlexiMetaBean)FlexiMetaBean.this).bean.data.keySet().iterator();
            }

            @Override
            public Iterator<MetaProperty<?>> iterator() {
                return new Iterator<MetaProperty<?>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public MetaProperty<?> next() {
                        return FlexiMetaProperty.of(((FlexiMetaBean)FlexiMetaBean.this).bean.metaBean, (String)it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Unmodifiable");
                    }
                };
            }
        };
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        if (this.bean.data.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, FlexiMetaProperty> map = new HashMap<String, FlexiMetaProperty>();
        for (String name : this.bean.data.keySet()) {
            map.put(name, FlexiMetaProperty.of(this.bean.metaBean, name));
        }
        return Collections.unmodifiableMap(map);
    }
}

