/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.map;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.joda.beans.Bean;
import org.joda.beans.MetaBean;
import org.joda.beans.Property;
import org.joda.beans.PropertyReadWrite;
import org.joda.beans.impl.BasicMetaProperty;
import org.joda.beans.impl.BasicProperty;
import org.joda.beans.impl.map.MapBean;

class MapBeanMetaProperty
extends BasicMetaProperty<Object> {
    private MapBean bean;

    public static MapBeanMetaProperty of(MapBean mapBean, String propertyName) {
        return new MapBeanMetaProperty(mapBean, propertyName);
    }

    private MapBeanMetaProperty(MapBean mapBean, String propertyName) {
        super(propertyName);
        this.bean = mapBean;
    }

    @Override
    public Property<Object> createProperty(Bean bean) {
        return BasicProperty.of(bean, this);
    }

    @Override
    public MetaBean metaBean() {
        return this.bean.metaBean();
    }

    @Override
    public Class<?> declaringType() {
        return MapBean.class;
    }

    @Override
    public Class<Object> propertyType() {
        return Object.class;
    }

    @Override
    public Class<Object> propertyGenericType() {
        return Object.class;
    }

    @Override
    public PropertyReadWrite readWrite() {
        return PropertyReadWrite.READ_WRITE;
    }

    @Override
    public List<Annotation> annotations() {
        return Collections.emptyList();
    }

    @Override
    public Object get(Bean bean) {
        if (bean != this.bean) {
            throw new ClassCastException("Bean is a MapBean, but not the correct MapBean");
        }
        return this.bean.get(this.name());
    }

    @Override
    public void set(Bean bean, Object value) {
        if (bean != this.bean) {
            throw new ClassCastException("Bean is a MapBean, but not the correct MapBean");
        }
        this.bean.put(this.name(), value);
    }
}

