/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.beans.gen.GeneratableProperty;

class GeneratableBean {
    private final SortedSet<String> currentImports = new TreeSet<String>();
    private final SortedSet<String> newImports = new TreeSet<String>();
    private int lastImportLine;
    private boolean constructable;
    private String typeFull;
    private String typeRaw;
    private String typeGenericName;
    private String typeGenericExtends;
    private String superTypeFull;
    private String superTypeRaw;
    private String superTypeGeneric;
    private List<GeneratableProperty> properties = new ArrayList<GeneratableProperty>();
    private boolean manualEqualsHashCode;

    GeneratableBean() {
    }

    public SortedSet<String> getCurrentImports() {
        return this.currentImports;
    }

    public SortedSet<String> getNewImports() {
        return this.newImports;
    }

    public void ensureImport(Class<?> cls) {
        if (!this.currentImports.contains(cls.getName())) {
            this.newImports.add(cls.getName());
        }
    }

    public int getImportInsertLocation() {
        return this.lastImportLine;
    }

    public void setImportInsertLocation(int location) {
        this.lastImportLine = location;
    }

    public boolean isConstructable() {
        return this.constructable;
    }

    public void setConstructable(boolean constructable) {
        this.constructable = constructable;
    }

    public boolean isManualEqualsHashCode() {
        return this.manualEqualsHashCode;
    }

    public void setManualEqualsHashCode(boolean manualEqualsHashCode) {
        this.manualEqualsHashCode = manualEqualsHashCode;
    }

    public void setTypeParts(String[] parts) {
        this.typeFull = parts[0];
        this.typeRaw = parts[1];
        this.typeGenericName = parts[2] != null ? parts[2] : "";
        this.typeGenericExtends = parts[3] != null ? parts[3] : "";
    }

    public void setSuperTypeParts(String[] parts) {
        this.superTypeFull = parts[0];
        this.superTypeRaw = parts[1];
        this.superTypeGeneric = parts[2] != null ? parts[2] : "";
    }

    public List<GeneratableProperty> getProperties() {
        return this.properties;
    }

    public boolean isSubclass() {
        return !this.superTypeFull.equals("DirectBean");
    }

    public boolean isTypeGeneric() {
        return this.typeGenericName.length() > 0;
    }

    public String getType() {
        return this.typeFull;
    }

    public String getTypeGeneric(boolean includeBrackets) {
        String result = this.typeGenericName + this.typeGenericExtends;
        return includeBrackets && result.length() > 0 ? '<' + result + '>' : result;
    }

    public String getTypeGenericName(boolean includeBrackets) {
        return includeBrackets && this.typeGenericName.length() > 0 ? '<' + this.typeGenericName + '>' : this.typeGenericName;
    }

    public String getTypeGenericExtends() {
        return this.typeGenericExtends;
    }

    public String getTypeNoExtends() {
        return this.typeFull.replace(this.typeGenericExtends, "");
    }

    public String getTypeRaw() {
        return this.typeRaw;
    }

    public String getTypeWildcard() {
        return this.typeRaw + (this.isTypeGeneric() ? "<?>" : "");
    }

    public boolean isSuperTypeGeneric() {
        return this.superTypeGeneric.length() > 0;
    }

    public String getSuperType() {
        return this.superTypeFull;
    }

    public String getSuperTypeGeneric(boolean includeBrackets) {
        return includeBrackets && this.superTypeGeneric.length() > 0 ? '<' + this.superTypeGeneric + '>' : this.superTypeGeneric;
    }

    public String getSuperTypeRaw() {
        return this.superTypeRaw;
    }

    public boolean isValidated() {
        for (GeneratableProperty property : this.properties) {
            if (!property.isValidated()) continue;
            return true;
        }
        return false;
    }
}

