/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.direct;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.MetaBean;
import org.joda.beans.PropertyReadWrite;
import org.joda.beans.impl.BasicMetaProperty;
import org.joda.beans.impl.direct.DirectBean;

public final class DirectMetaProperty<P>
extends BasicMetaProperty<P> {
    private final MetaBean metaBean;
    private final Class<P> propertyType;
    private final Class<?> declaringType;
    private final Field field;
    private final PropertyReadWrite readWrite;

    public static <P> DirectMetaProperty<P> ofReadWrite(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyReadWrite.READ_WRITE, field);
    }

    public static <P> DirectMetaProperty<P> ofReadOnly(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyReadWrite.READ_ONLY, field);
    }

    public static <P> DirectMetaProperty<P> ofWriteOnly(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyReadWrite.WRITE_ONLY, field);
    }

    private static Field findField(MetaBean metaBean, String propertyName) {
        Field field = null;
        for (Class<? extends Bean> cls = metaBean.beanType(); cls != DirectBean.class; cls = cls.getSuperclass()) {
            try {
                field = cls.getDeclaredField(propertyName);
                break;
            }
            catch (NoSuchFieldException ex) {
                try {
                    field = cls.getDeclaredField("_" + propertyName);
                    break;
                }
                catch (NoSuchFieldException ex2) {
                    continue;
                }
            }
        }
        return field;
    }

    private DirectMetaProperty(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType, PropertyReadWrite readWrite, Field field) {
        super(propertyName);
        if (metaBean == null) {
            throw new NullPointerException("MetaBean must not be null");
        }
        if (declaringType == null) {
            throw new NullPointerException("Declaring type must not be null");
        }
        if (propertyType == null) {
            throw new NullPointerException("Property type must not be null");
        }
        if (readWrite == null) {
            throw new NullPointerException("PropertyReadWrite must not be null");
        }
        this.metaBean = metaBean;
        this.propertyType = propertyType;
        this.declaringType = declaringType;
        this.readWrite = readWrite;
        this.field = field;
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.declaringType;
    }

    @Override
    public Class<P> propertyType() {
        return this.propertyType;
    }

    @Override
    public Type propertyGenericType() {
        if (this.field == null) {
            return this.propertyType;
        }
        return this.field.getGenericType();
    }

    @Override
    public PropertyReadWrite readWrite() {
        return this.readWrite;
    }

    @Override
    public <A extends Annotation> A annotation(Class<A> annotationClass) {
        if (this.field == null) {
            throw new UnsupportedOperationException("Field not found for property: " + this.name());
        }
        A annotation = this.field.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new NoSuchElementException("Unknown annotation: " + annotationClass.getName());
        }
        return annotation;
    }

    @Override
    public List<Annotation> annotations() {
        if (this.field == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.field.getDeclaredAnnotations());
    }

    @Override
    public P get(Bean bean) {
        return (P)((DirectBean)bean).propertyGet(this.name(), false);
    }

    @Override
    public void set(Bean bean, Object value) {
        ((DirectBean)bean).propertySet(this.name(), value, false);
    }
}

