/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.map;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.joda.beans.Property;
import org.joda.beans.PropertyMap;
import org.joda.beans.impl.BasicProperty;
import org.joda.beans.impl.map.MapBean;
import org.joda.beans.impl.map.MapBeanMetaProperty;

public final class MapBeanPropertyMap
extends AbstractMap<String, Property<?>>
implements PropertyMap {
    private final MapBean bean;

    public static MapBeanPropertyMap of(MapBean bean) {
        return new MapBeanPropertyMap(bean);
    }

    private MapBeanPropertyMap(MapBean bean) {
        if (bean == null) {
            throw new NullPointerException("Bean must not be null");
        }
        this.bean = bean;
    }

    @Override
    public int size() {
        return this.bean.size();
    }

    @Override
    public boolean containsKey(Object obj) {
        return this.bean.containsKey(obj);
    }

    @Override
    public Property<?> get(Object obj) {
        return this.containsKey(obj) ? this.bean.property(obj.toString()) : null;
    }

    @Override
    public Set<String> keySet() {
        return this.bean.keySet();
    }

    @Override
    public Set<Map.Entry<String, Property<?>>> entrySet() {
        return new AbstractSet<Map.Entry<String, Property<?>>>(){

            @Override
            public int size() {
                return MapBeanPropertyMap.this.bean.size();
            }

            @Override
            public Iterator<Map.Entry<String, Property<?>>> iterator() {
                final Iterator it = MapBeanPropertyMap.this.bean.keySet().iterator();
                return new Iterator<Map.Entry<String, Property<?>>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Property<?>> next() {
                        String name = (String)it.next();
                        BasicProperty<Object> prop = BasicProperty.of(MapBeanPropertyMap.this.bean, MapBeanMetaProperty.of(MapBeanPropertyMap.this.bean, name));
                        return new AbstractMap.SimpleImmutableEntry(name, prop);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Unmodifiable");
                    }
                };
            }
        };
    }

    @Override
    public Map<String, Object> flatten() {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.bean);
        return Collections.unmodifiableMap(copy);
    }
}

