/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.map;

import java.util.Map;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaProperty;
import org.joda.beans.impl.map.MapBean;

class MapBeanBuilder
implements BeanBuilder<MapBean> {
    private final MapBean bean;

    MapBeanBuilder(MapBean bean) {
        this.bean = bean;
    }

    public MapBeanBuilder set(String propertyName, Object value) {
        this.bean.put(propertyName, value);
        return this;
    }

    public MapBeanBuilder set(MetaProperty<?> property, Object value) {
        this.bean.put(property.name(), value);
        return this;
    }

    public MapBeanBuilder setString(String propertyName, String value) {
        this.bean.put(propertyName, value);
        return this;
    }

    public MapBeanBuilder setString(MetaProperty<?> property, String value) {
        this.bean.put(property.name(), value);
        return this;
    }

    @Override
    public BeanBuilder<MapBean> setAll(Map<String, ? extends Object> propertyValueMap) {
        for (Map.Entry<String, ? extends Object> entry : propertyValueMap.entrySet()) {
            this.bean.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MapBean build() {
        return this.bean;
    }

    public String toString() {
        return "MapBeanBuilder";
    }
}

