/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.xml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIteratorFactory;
import org.joda.beans.ser.xml.JodaBeanXml;

public class JodaBeanXmlReader {
    private static final XMLInputFactory FACTORY = XMLInputFactory.newFactory();
    private final JodaBeanSer settings;
    private XMLEventReader reader;
    private String basePackage;
    private Map<String, Class<?>> knownTypes = new HashMap();

    public JodaBeanXmlReader(JodaBeanSer settings) {
        this.settings = settings;
    }

    public Bean read(String input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(String input, Class<T> rootType) {
        return this.read(new StringReader(input), rootType);
    }

    public Bean read(InputStream input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(InputStream input, Class<T> rootType) {
        try {
            this.reader = FACTORY.createXMLEventReader(input);
            return this.read(rootType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Bean read(Reader input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(Reader input, Class<T> rootType) {
        try {
            this.reader = FACTORY.createXMLEventReader(input);
            return this.read(rootType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> T read(Class<T> rootType) throws Exception {
        Class<Object> type;
        StartElement start = this.advanceToStartElement();
        if (!start.getName().equals(JodaBeanXml.BEAN_QNAME)) {
            throw new IllegalArgumentException("Expected root element 'bean' but found '" + start.getName() + "'");
        }
        Attribute attr = start.getAttributeByName(JodaBeanXml.TYPE_QNAME);
        if (attr == null && rootType == Bean.class) {
            throw new IllegalArgumentException("Root element attribute must specify 'type'");
        }
        if (attr != null) {
            String typeStr = attr.getValue();
            type = this.settings.decodeClass(typeStr, null, this.knownTypes);
            if (!rootType.isAssignableFrom(type)) {
                throw new IllegalArgumentException("Specified root type is incompatible with XML root type: " + rootType.getName() + " and " + type.getName());
            }
        } else {
            type = rootType;
        }
        if (!Bean.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Root type is not a Joda-Bean: " + type.getName());
        }
        MetaBean metaBean = JodaBeanUtils.metaBean(type);
        this.basePackage = type.getPackage().getName() + ".";
        Bean bean = this.parseBean(metaBean, type);
        this.reader.close();
        Bean result = bean;
        return (T)result;
    }

    private Bean parseBean(MetaBean metaBean, Class<?> beanType) throws Exception {
        try {
            BeanBuilder<? extends Bean> builder = metaBean.builder();
            XMLEvent event = this.reader.nextEvent();
            while (!event.isEndElement()) {
                if (event.isStartElement()) {
                    Object value;
                    String name;
                    MetaProperty metaProp;
                    StartElement start = event.asStartElement();
                    Class<?> childType = this.parseTypeAttribute(start, (metaProp = metaBean.metaProperty(name = start.getName().getLocalPart())).propertyType());
                    if (Bean.class.isAssignableFrom(childType)) {
                        if (this.settings.getConverter().isConvertible(childType)) {
                            String text = this.advanceAndParseText();
                            value = this.settings.getConverter().convertFromString(childType, text);
                        } else {
                            MetaBean childMetaBean = JodaBeanUtils.metaBean(childType);
                            value = this.parseBean(childMetaBean, childType);
                        }
                    } else {
                        SerIterable iterable = SerIteratorFactory.INSTANCE.createIterable(metaProp, beanType);
                        if (iterable != null) {
                            value = this.parseIterable(iterable);
                        } else {
                            String text = this.advanceAndParseText();
                            value = this.settings.getConverter().convertFromString(childType, text);
                        }
                    }
                    builder.set(metaProp, value);
                }
                event = this.reader.nextEvent();
            }
            return builder.build();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing bean: " + metaBean.beanName(), ex);
        }
    }

    private Object parseIterable(SerIterable iterable) throws Exception {
        XMLEvent event = this.reader.nextEvent();
        while (!event.isEndElement()) {
            if (event.isStartElement()) {
                QName expectedType;
                StartElement start = event.asStartElement();
                QName qName = expectedType = iterable.isMapLike() ? JodaBeanXml.ENTRY_QNAME : JodaBeanXml.ITEM_QNAME;
                if (!start.getName().equals(expectedType)) {
                    throw new IllegalArgumentException("Expected '" + expectedType.getLocalPart() + "' but found '" + start.getName() + "'");
                }
                int count = 1;
                Attribute countAttr = start.getAttributeByName(JodaBeanXml.COUNT_QNAME);
                if (countAttr != null) {
                    count = Integer.parseInt(countAttr.getValue());
                }
                Object key = null;
                Object value = null;
                Attribute keyAttr = start.getAttributeByName(JodaBeanXml.KEY_QNAME);
                if (keyAttr != null) {
                    String keyStr = keyAttr.getValue();
                    key = iterable.keyType() != null ? this.settings.getConverter().convertFromString(iterable.keyType(), keyStr) : keyStr;
                    value = this.parseValue(iterable, start);
                } else if (iterable.keyType() != null) {
                    if (!Bean.class.isAssignableFrom(iterable.keyType())) {
                        throw new IllegalArgumentException("Unable to read map as declared key type is neither a bean nor a simple type: " + iterable.keyType().getName());
                    }
                    event = this.reader.nextEvent();
                    int loop = 0;
                    while (!event.isEndElement() && loop < 2) {
                        if (event.isStartElement()) {
                            start = event.asStartElement();
                            if (!start.getName().equals(JodaBeanXml.ITEM_QNAME)) {
                                throw new IllegalArgumentException("Expected 'item' but found '" + start.getName() + "'");
                            }
                            if (loop == 0) {
                                key = this.parseKey(iterable, start);
                                loop = 1;
                            } else {
                                value = this.parseValue(iterable, start);
                                loop = 2;
                            }
                        }
                        event = this.reader.nextEvent();
                    }
                } else {
                    value = this.parseValue(iterable, start);
                }
                iterable.add(key, value, count);
            }
            event = this.reader.nextEvent();
        }
        return iterable.build();
    }

    private Object parseKey(SerIterable iterable, StartElement start) throws Exception {
        Class<?> childType = this.parseTypeAttribute(start, iterable.keyType());
        if (Bean.class.isAssignableFrom(childType)) {
            MetaBean childMetaBean = JodaBeanUtils.metaBean(childType);
            return this.parseBean(childMetaBean, childType);
        }
        throw new IllegalArgumentException("Unable to read map as parsed key type is not a bean: " + childType.getName());
    }

    private Object parseValue(SerIterable iterable, StartElement start) throws Exception {
        Object value;
        Attribute nullAttr = start.getAttributeByName(JodaBeanXml.NULL_QNAME);
        if (nullAttr != null) {
            if (!nullAttr.getValue().equals("true")) {
                throw new IllegalArgumentException("Unexpected value for null attribute");
            }
            this.advanceAndParseText();
            value = null;
        } else {
            Class<?> childType = this.parseTypeAttribute(start, iterable.valueType());
            if (Bean.class.isAssignableFrom(childType)) {
                if (this.settings.getConverter().isConvertible(childType)) {
                    String text = this.advanceAndParseText();
                    value = this.settings.getConverter().convertFromString(childType, text);
                } else {
                    MetaBean childMetaBean = JodaBeanUtils.metaBean(childType);
                    value = this.parseBean(childMetaBean, childType);
                }
            } else {
                SerIterable childIterable = SerIteratorFactory.INSTANCE.createIterable(iterable);
                if (childIterable != null) {
                    value = this.parseIterable(childIterable);
                } else {
                    Attribute metaTypeAttr = start.getAttributeByName(JodaBeanXml.METATYPE_QNAME);
                    if (metaTypeAttr != null) {
                        childIterable = SerIteratorFactory.INSTANCE.createIterable(metaTypeAttr.getValue(), this.settings, this.knownTypes);
                        if (childIterable == null) {
                            throw new IllegalArgumentException("Invalid metaType");
                        }
                        value = this.parseIterable(childIterable);
                    } else {
                        String text = this.advanceAndParseText();
                        value = this.settings.getConverter().convertFromString(childType, text);
                    }
                }
            }
        }
        return value;
    }

    private Class<?> parseTypeAttribute(StartElement start, Class<?> defaultType) throws ClassNotFoundException {
        Attribute typeAttr = start.getAttributeByName(JodaBeanXml.TYPE_QNAME);
        if (typeAttr == null) {
            return defaultType == Object.class ? String.class : defaultType;
        }
        String childTypeStr = typeAttr.getValue();
        return this.settings.decodeClass(childTypeStr, this.basePackage, this.knownTypes);
    }

    private StartElement advanceToStartElement() throws Exception {
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            if (!event.isStartElement()) continue;
            return event.asStartElement();
        }
        throw new IllegalArgumentException("Unexpected end of document");
    }

    private String advanceAndParseText() throws Exception {
        StringBuilder buf = new StringBuilder();
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            if (event.isEndElement()) {
                return buf.toString();
            }
            if (!event.isCharacters()) continue;
            buf.append(event.asCharacters().getData());
        }
        throw new IllegalArgumentException("Unexpected end of document");
    }

    static {
        FACTORY.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }
}

