/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.beans.gen.GeneratableProperty;

class GeneratableBean {
    private final SortedSet<String> currentImports = new TreeSet<String>();
    private final SortedSet<String> newImports = new TreeSet<String>();
    private int lastImportLine;
    private String beanStyle;
    private boolean immutable;
    private boolean constructable;
    private boolean immutableConstructor;
    private String typeFull;
    private String typeRaw;
    private String typeGenericName;
    private String typeGenericExtends;
    private boolean typeFinal;
    private boolean root;
    private String superTypeFull;
    private String superTypeRaw;
    private String superTypeGeneric;
    private List<GeneratableProperty> properties = new ArrayList<GeneratableProperty>();
    private boolean manualClone;
    private boolean manualEqualsHashCode;
    private boolean manualToStringCode;

    GeneratableBean() {
    }

    public SortedSet<String> getCurrentImports() {
        return this.currentImports;
    }

    public SortedSet<String> getNewImports() {
        return this.newImports;
    }

    public void ensureImport(Class<?> cls) {
        if (!this.currentImports.contains(cls.getName())) {
            this.newImports.add(cls.getName());
        }
    }

    public int getImportInsertLocation() {
        return this.lastImportLine;
    }

    public void setImportInsertLocation(int location) {
        this.lastImportLine = location;
    }

    public String getBeanStyle() {
        return this.beanStyle;
    }

    public void setBeanStyle(String beanStyle) {
        this.beanStyle = beanStyle;
    }

    public boolean isBeanStyleValid() {
        return "full".equals(this.beanStyle) || "smart".equals(this.beanStyle) || "minimal".equals(this.beanStyle);
    }

    public boolean isBeanStyleGenerateProperties() {
        return "full".equals(this.beanStyle) || "smart".equals(this.beanStyle) && !this.isImmutable();
    }

    public boolean isBeanStyleGenerateMetaProperties() {
        return "full".equals(this.beanStyle) || "smart".equals(this.beanStyle);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isMutable() {
        return !this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public boolean isConstructable() {
        return this.constructable;
    }

    public void setConstructable(boolean constructable) {
        this.constructable = constructable;
    }

    public boolean isImmutableConstructor() {
        return this.immutableConstructor;
    }

    public void setImmutableConstructor(boolean manualConstructor) {
        this.immutableConstructor = manualConstructor;
    }

    public boolean isManualClone() {
        return this.manualClone;
    }

    public void setManualClone(boolean manualClone) {
        this.manualClone = manualClone;
    }

    public boolean isManualEqualsHashCode() {
        return this.manualEqualsHashCode;
    }

    public void setManualEqualsHashCode(boolean manualEqualsHashCode) {
        this.manualEqualsHashCode = manualEqualsHashCode;
    }

    public boolean isManualToStringCode() {
        return this.manualToStringCode;
    }

    public void setManualToStringCode(boolean manualToStringCode) {
        this.manualToStringCode = manualToStringCode;
    }

    public void setTypeParts(String[] parts) {
        this.typeFinal = parts[0] != null;
        this.typeFull = parts[1];
        this.typeRaw = parts[2];
        this.typeGenericName = parts[3] != null ? parts[3] : "";
        this.typeGenericExtends = parts[4] != null ? parts[4] : "";
    }

    public void setSuperTypeParts(String[] parts) {
        if (parts.length == 1) {
            this.root = true;
            this.immutable = "ImmutableBean".equals(parts[0]);
            this.superTypeFull = "";
            this.superTypeRaw = "";
            this.superTypeGeneric = "";
        } else {
            this.root = "DirectBean".equals(parts[0]);
            this.immutable = false;
            this.superTypeFull = parts[0];
            this.superTypeRaw = parts[1];
            this.superTypeGeneric = parts[2] != null ? parts[2] : "";
        }
    }

    public List<GeneratableProperty> getProperties() {
        return this.properties;
    }

    public boolean isTypeFinal() {
        return this.typeFinal;
    }

    public void setTypeFinal(boolean typeFinal) {
        this.typeFinal = typeFinal;
    }

    public boolean isSubClass() {
        return !this.root;
    }

    public boolean isRootClass() {
        return this.root;
    }

    public boolean isExtendsDirectBean() {
        return "DirectBean".equals(this.superTypeFull);
    }

    public boolean isTypeGeneric() {
        return this.typeGenericName.length() > 0;
    }

    public String getType() {
        return this.typeFull;
    }

    public String getTypeGeneric(boolean includeBrackets) {
        String result = this.typeGenericName + this.typeGenericExtends;
        return includeBrackets && result.length() > 0 ? '<' + result + '>' : result;
    }

    public String getTypeGenericName(boolean includeBrackets) {
        return includeBrackets && this.typeGenericName.length() > 0 ? '<' + this.typeGenericName + '>' : this.typeGenericName;
    }

    public String getTypeGenericExtends() {
        return this.typeGenericExtends;
    }

    public String getTypeNoExtends() {
        return this.typeFull.replace(this.typeGenericExtends, "");
    }

    public String getTypeRaw() {
        return this.typeRaw;
    }

    public String getTypeWildcard() {
        return this.typeRaw + (this.isTypeGeneric() ? "<?>" : "");
    }

    public boolean isSuperTypeGeneric() {
        return this.superTypeGeneric.length() > 0;
    }

    public String getSuperType() {
        return this.superTypeFull;
    }

    public String getSuperTypeGeneric(boolean includeBrackets) {
        return includeBrackets && this.superTypeGeneric.length() > 0 ? '<' + this.superTypeGeneric + '>' : this.superTypeGeneric;
    }

    public String getSuperTypeRaw() {
        return this.superTypeRaw;
    }

    public boolean isValidated() {
        for (GeneratableProperty property : this.properties) {
            if (!property.isValidated()) continue;
            return true;
        }
        return false;
    }
}

