/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.GeneratableProperty;

abstract class SetterGen {
    SetterGen() {
    }

    abstract boolean isSetterGenerated(GeneratableProperty var1);

    abstract List<String> generateSetter(String var1, GeneratableProperty var2);

    String generateSetInvoke(GeneratableProperty prop) {
        return "set" + prop.getUpperName();
    }

    static class NoSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new NoSetterGen();

        NoSetterGen() {
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            return false;
        }

        @Override
        List<String> generateSetter(String indent, GeneratableProperty prop) {
            return Collections.emptyList();
        }
    }

    static class PatternSetterGen
    extends SetterGen {
        private final String setPattern;
        private final String access;

        PatternSetterGen(String setPattern) {
            this(setPattern, "public");
        }

        PatternSetterGen(String setPattern, String access) {
            this.setPattern = setPattern;
            this.access = access;
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            return true;
        }

        @Override
        List<String> generateSetter(String indent, GeneratableProperty prop) {
            String[] split;
            ArrayList<String> list = new ArrayList<String>();
            list.add(indent + "/**");
            list.add(indent + " * Sets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add(indent + " * " + comment);
            }
            list.add(indent + " * @param " + prop.getPropertyName() + "  the new value of the property");
            list.add(indent + " */");
            if (prop.isDeprecated()) {
                list.add(indent + "@Deprecated");
            }
            list.add(indent + this.access + " void set" + prop.getUpperName() + "(" + prop.getType() + " " + prop.getPropertyName() + ") {");
            for (String line : split = this.setPattern.split("\n")) {
                line = line.replace("$field", "this." + prop.getFieldName());
                line = line.replace("$value", prop.getPropertyName());
                line = line.replace("<>", prop.getTypeGenerics());
                if (split.length == 1 && !line.endsWith(";")) {
                    line = line + ";";
                }
                list.add(indent + "\t" + line);
            }
            list.add(indent + "}");
            list.add("");
            return list;
        }
    }

    static final class SetSetterGen
    extends SetterGen {
        static final SetSetterGen PUBLIC = new SetSetterGen("public");
        static final SetSetterGen PRIVATE = new SetSetterGen("private");
        private final String access;

        static SetSetterGen of(String access) {
            return access.equals("private") ? PRIVATE : PUBLIC;
        }

        private SetSetterGen(String access) {
            this.access = access;
        }

        @Override
        boolean isSetterGenerated(GeneratableProperty prop) {
            return true;
        }

        @Override
        List<String> generateSetter(String indent, GeneratableProperty prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\t/**");
            list.add("\t * Sets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add("\t * " + comment);
            }
            list.add("\t * @param " + prop.getPropertyName() + "  the new value of the property" + (prop.isNotNull() ? ", not null" : ""));
            list.add("\t */");
            if (prop.isDeprecated()) {
                list.add("\t@Deprecated");
            }
            list.add("\t" + this.access + " void set" + prop.getUpperName() + "(" + prop.getType() + " " + prop.getPropertyName() + ") {");
            if (prop.isValidated()) {
                list.add("\t\t" + prop.getValidationMethodName() + "(" + prop.getPropertyName() + ", \"" + prop.getPropertyName() + "\");");
            }
            list.add("\t\tthis." + prop.getFieldName() + " = " + prop.getPropertyName() + ";");
            list.add("\t}");
            list.add("");
            return list;
        }
    }
}

