/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.ser.SerIteratorFactory;
import org.joda.beans.ser.xml.JodaBeanXmlReader;
import org.joda.beans.ser.xml.JodaBeanXmlWriter;
import org.joda.convert.StringConvert;

public final class JodaBeanSer {
    public static final JodaBeanSer COMPACT = new JodaBeanSer("", "", StringConvert.create(), SerIteratorFactory.INSTANCE, true);
    public static final JodaBeanSer PRETTY = new JodaBeanSer(" ", "\n", StringConvert.create(), SerIteratorFactory.INSTANCE, true);
    private static final Map<Class<?>, String> BASIC_TYPES;
    private static final Map<String, Class<?>> BASIC_TYPES_REVERSED;
    private final String indent;
    private final String newLine;
    private final StringConvert converter;
    private final SerIteratorFactory iteratorFactory;
    private final boolean shortTypes = true;

    private JodaBeanSer(String indent, String newLine, StringConvert converter, SerIteratorFactory iteratorFactory, boolean shortTypes) {
        this.indent = indent;
        this.newLine = newLine;
        this.converter = converter;
        this.iteratorFactory = iteratorFactory;
    }

    public String getIndent() {
        return this.indent;
    }

    public JodaBeanSer withIndent(String indent) {
        JodaBeanUtils.notNull(indent, "indent");
        return new JodaBeanSer(indent, this.newLine, this.converter, this.iteratorFactory, true);
    }

    public String getNewLine() {
        return this.newLine;
    }

    public JodaBeanSer withNewLine(String newLine) {
        JodaBeanUtils.notNull(newLine, "newLine");
        return new JodaBeanSer(this.indent, newLine, this.converter, this.iteratorFactory, true);
    }

    public StringConvert getConverter() {
        return this.converter;
    }

    public JodaBeanSer withConverter(StringConvert converter) {
        JodaBeanUtils.notNull(converter, "converter");
        return new JodaBeanSer(this.indent, this.newLine, converter, this.iteratorFactory, true);
    }

    public SerIteratorFactory getIteratorFactory() {
        return this.iteratorFactory;
    }

    public JodaBeanSer withIteratorFactory(SerIteratorFactory iteratorFactory) {
        JodaBeanUtils.notNull(this.converter, "converter");
        return new JodaBeanSer(this.indent, this.newLine, this.converter, iteratorFactory, true);
    }

    public SerIteratorFactory isShortTypes() {
        return this.iteratorFactory;
    }

    public JodaBeanSer withShortTypes(boolean shortTypes) {
        return new JodaBeanSer(this.indent, this.newLine, this.converter, this.iteratorFactory, shortTypes);
    }

    public String encodeClass(Class<?> cls, String basePackage, Map<Class<?>, String> knownTypes) {
        String result = BASIC_TYPES.get(cls);
        if (result != null) {
            return result;
        }
        if (knownTypes != null && (result = knownTypes.get(cls)) != null) {
            return result;
        }
        result = cls.getName();
        if (basePackage != null && result.startsWith(basePackage) && Character.isUpperCase(result.charAt(basePackage.length())) && !BASIC_TYPES.containsKey(result.substring(basePackage.length()))) {
            result = result.substring(basePackage.length());
            if (knownTypes != null) {
                knownTypes.put(cls, result);
            }
        } else if (knownTypes != null) {
            String simpleName = cls.getSimpleName();
            if (Character.isUpperCase(simpleName.charAt(0)) && !BASIC_TYPES.containsKey(simpleName) && !knownTypes.containsKey(simpleName)) {
                knownTypes.put(cls, simpleName);
            } else {
                knownTypes.put(cls, result);
            }
        }
        return result;
    }

    public Class<?> decodeClass(String className, String basePackage, Map<String, Class<?>> knownTypes) throws ClassNotFoundException {
        Class<?> result = BASIC_TYPES_REVERSED.get(className);
        if (result != null) {
            return result;
        }
        if (knownTypes != null && (result = knownTypes.get(className)) != null) {
            return result;
        }
        String fullName = className;
        boolean expanded = false;
        if (basePackage != null && className.length() > 0 && Character.isUpperCase(className.charAt(0))) {
            fullName = basePackage + className;
            expanded = true;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = result = loader != null ? loader.loadClass(fullName) : Class.forName(fullName);
            if (knownTypes != null) {
                knownTypes.put(fullName, result);
                if (expanded) {
                    knownTypes.put(className, result);
                } else {
                    String simpleName = result.getSimpleName();
                    if (Character.isUpperCase(simpleName.charAt(0)) && !BASIC_TYPES.containsKey(simpleName) && !knownTypes.containsKey(simpleName)) {
                        knownTypes.put(simpleName, result);
                    }
                }
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            if (!fullName.equals(className)) {
                try {
                    Class<?> clazz = result = loader != null ? loader.loadClass(className) : Class.forName(className);
                    if (knownTypes != null) {
                        knownTypes.put(className, result);
                    }
                    return result;
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public JodaBeanXmlWriter xmlWriter() {
        return new JodaBeanXmlWriter(this);
    }

    public JodaBeanXmlReader xmlReader() {
        return new JodaBeanXmlReader(this);
    }

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(String.class, "String");
        map.put(Boolean.class, "Boolean");
        map.put(Character.class, "Character");
        map.put(Byte.class, "Byte");
        map.put(Short.class, "Short");
        map.put(Integer.class, "Integer");
        map.put(Long.class, "Long");
        map.put(Float.class, "Float");
        map.put(Double.class, "Double");
        map.put(BigInteger.class, "BigInteger");
        map.put(BigDecimal.class, "BigDecimal");
        map.put(Class.class, "Class");
        map.put(Package.class, "Package");
        map.put(File.class, "File");
        map.put(Locale.class, "Locale");
        map.put(URL.class, "URL");
        map.put(URI.class, "URI");
        map.put(UUID.class, "UUID");
        HashMap reversed = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            reversed.put(entry.getValue(), entry.getKey());
        }
        BASIC_TYPES = Collections.unmodifiableMap(map);
        BASIC_TYPES_REVERSED = Collections.unmodifiableMap(reversed);
    }
}

