/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.gen.BeanGen;
import org.joda.beans.gen.BeanGenConfig;

public class BeanCodeGen {
    private final List<File> files;
    private final BeanGenConfig config;
    private final int verbosity;
    private final boolean write;

    public static void main(String[] args) {
        BeanCodeGen gen = null;
        try {
            gen = BeanCodeGen.createFromArgs(args);
        }
        catch (RuntimeException ex) {
            System.out.println(ex.getMessage());
            System.out.println("");
            System.out.println("Code generator");
            System.out.println("  Usage java org.joda.beans.gen.BeanCodeGen [file]");
            System.out.println("  Options");
            System.out.println("    -R                process all files recursively, default false");
            System.out.println("    -indent=tab       use a tab for indenting, default 4 spaces");
            System.out.println("    -indent=[n]       use n spaces for indenting, default 4");
            System.out.println("    -prefix=[p]       field prefix of p should be removed, no default");
            System.out.println("    -config=[f]       config file: jdk6/guava', default guava");
            System.out.println("    -verbose=[v]      output logging with verbosity from 0 to 3, default 1");
            System.out.println("    -nowrite          output messages rather than writing, default is to write");
            System.exit(0);
        }
        try {
            int changed = gen.process();
            System.out.println("Finished, found " + changed + " changed files");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println();
            ex.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public static BeanCodeGen createFromArgs(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        String indent = "    ";
        String prefix = "";
        boolean recurse = false;
        int verbosity = 1;
        boolean write = true;
        File file = null;
        BeanGenConfig config = null;
        if (args.length == 0) {
            throw new IllegalArgumentException("No arguments specified");
        }
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if (arg == null) {
                throw new IllegalArgumentException("Argument must not be null: " + Arrays.toString(args));
            }
            if (arg.startsWith("-indent=tab")) {
                indent = "\t";
                continue;
            }
            if (arg.startsWith("-indent=")) {
                indent = "          ".substring(0, Integer.parseInt(arg.substring(8)));
                continue;
            }
            if (arg.startsWith("-prefix=")) {
                prefix = arg.substring(8);
                continue;
            }
            if (arg.equals("-R")) {
                recurse = true;
                continue;
            }
            if (arg.equals("-config=")) {
                if (config != null) {
                    throw new IllegalArgumentException("Argument 'config' must not be specified twice: " + Arrays.toString(args));
                }
                config = BeanGenConfig.parse(arg.substring(8));
                continue;
            }
            if (arg.startsWith("-verbose=")) {
                verbosity = Integer.parseInt(arg.substring(3));
                continue;
            }
            if (arg.startsWith("-v=")) {
                System.out.println("Deprecated command line argument -v (use -verbose instead)");
                verbosity = Integer.parseInt(arg.substring(3));
                continue;
            }
            if (arg.equals("-nowrite")) {
                write = false;
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + arg);
        }
        file = new File(args[args.length - 1]);
        List<File> files = BeanCodeGen.findFiles(file, recurse);
        if (config == null) {
            config = BeanGenConfig.parse("guava");
        }
        config.setIndent(indent);
        config.setPrefix(prefix);
        return new BeanCodeGen(files, config, verbosity, write);
    }

    private static List<File> findFiles(File parent, boolean recurse) {
        ArrayList<File> result = new ArrayList<File>();
        if (parent.isDirectory()) {
            File[] files;
            for (File child : files = parent.listFiles()) {
                if (!child.isFile() || !child.getName().endsWith(".java")) continue;
                result.add(child);
            }
            if (recurse) {
                for (File child : files) {
                    if (!child.isDirectory() || child.getName().startsWith(".")) continue;
                    result.addAll(BeanCodeGen.findFiles(child, recurse));
                }
            }
        } else if (parent.getName().endsWith(".java")) {
            result.add(parent);
        }
        return result;
    }

    @Deprecated
    public BeanCodeGen(List<File> files, String indent, String prefix, int verbosity, boolean write) {
        JodaBeanUtils.notNull(files, "files");
        JodaBeanUtils.notNull(indent, "indent");
        JodaBeanUtils.notNull(prefix, "prefix");
        if (verbosity < 0 || verbosity > 3) {
            throw new IllegalArgumentException("Invalid verbosity: " + verbosity);
        }
        this.files = files;
        this.config = BeanGenConfig.parse("guava");
        this.config.setIndent(indent);
        this.config.setPrefix(prefix);
        this.verbosity = verbosity;
        this.write = write;
    }

    public BeanCodeGen(List<File> files, BeanGenConfig config, int verbosity, boolean write) {
        JodaBeanUtils.notNull(files, "files");
        JodaBeanUtils.notNull(config, "config");
        if (verbosity < 0 || verbosity > 3) {
            throw new IllegalArgumentException("Invalid verbosity: " + verbosity);
        }
        this.files = files;
        this.config = config;
        this.verbosity = verbosity;
        this.write = write;
    }

    public int process() throws Exception {
        int changed = 0;
        for (File child : this.files) {
            changed += this.processFile(child) ? 1 : 0;
        }
        return changed;
    }

    private boolean processFile(File file) throws Exception {
        BeanGen gen;
        List<String> original = this.readFile(file);
        ArrayList<String> content = new ArrayList<String>(original);
        try {
            gen = new BeanGen(content, this.config);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in bean: " + file, ex);
        }
        if (gen.isBean()) {
            if (this.verbosity >= 2) {
                System.out.print(file + "  [processing]");
            }
            gen.process();
            if (!((Object)content).equals(original)) {
                if (this.write) {
                    if (this.verbosity >= 2) {
                        System.out.println(" [writing]");
                    } else if (this.verbosity == 1) {
                        System.out.println(file + "  [writing]");
                    }
                    this.writeFile(file, content);
                } else if (this.verbosity >= 2) {
                    System.out.println(" [changed not written]");
                } else if (this.verbosity == 1) {
                    System.out.println(file + "  [changed not written]");
                }
                return true;
            }
            if (this.verbosity >= 2) {
                System.out.println(" [no change]");
            }
        } else if (this.verbosity == 3) {
            System.out.println(file + "  [ignored]");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(File file) throws Exception {
        ArrayList<String> content = new ArrayList<String>(100);
        BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line;
            while ((line = is.readLine()) != null) {
                content.add(line);
            }
            ArrayList<String> arrayList = content;
            return arrayList;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, List<String> content) throws Exception {
        PrintWriter os = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        try {
            for (String line : content) {
                os.println(line);
            }
        }
        finally {
            os.close();
        }
    }
}

