/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;

public abstract class BasicImmutableBeanBuilder<T extends Bean>
implements BeanBuilder<T> {
    private final MetaBean meta;

    public BasicImmutableBeanBuilder(MetaBean meta) {
        this.meta = meta;
    }

    @Override
    public BeanBuilder<T> set(MetaProperty<?> property, Object value) {
        this.set(property.name(), value);
        return this;
    }

    @Override
    public BeanBuilder<T> setString(String propertyName, String value) {
        this.setString(this.meta.metaProperty(propertyName), value);
        return this;
    }

    @Override
    public BeanBuilder<T> setString(MetaProperty<?> property, String value) {
        this.set(property.name(), JodaBeanUtils.stringConverter().convertFromString(property.propertyType(), value));
        return this;
    }

    @Override
    public BeanBuilder<T> setAll(Map<String, ? extends Object> propertyValueMap) {
        for (Map.Entry<String, ? extends Object> entry : propertyValueMap.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String toString() {
        return "BeanBuilder";
    }
}

