/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerIteratorFactory;

public class GuavaSerIteratorFactory
extends SerIteratorFactory {
    @Override
    public SerIterator create(Object value, List<Class<?>> types) {
        if (value instanceof Multimap) {
            if (types.size() == 1) {
                return GuavaSerIteratorFactory.multimap((Multimap)value, types.get(0), types.get(1), EMPTY_VALUE_TYPES);
            }
            return GuavaSerIteratorFactory.multimap((Multimap)value, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (value instanceof Multiset) {
            if (types.size() == 1) {
                return GuavaSerIteratorFactory.multiset((Multiset)value, types.get(0), EMPTY_VALUE_TYPES);
            }
            return GuavaSerIteratorFactory.multiset((Multiset)value, Object.class, EMPTY_VALUE_TYPES);
        }
        return super.create(value, types);
    }

    @Override
    public SerIterator create(Object value, MetaProperty<?> prop, Class<?> beanClass) {
        if (value instanceof Multiset) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.multiset((Multiset)value, valueType, valueTypeTypes);
        }
        if (value instanceof Multimap) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.multimap((Multimap)value, keyType, valueType, valueTypeTypes);
        }
        return super.create(value, prop, beanClass);
    }

    @Override
    public SerIterable createIterable(String metaTypeDescription, JodaBeanSer settings, Map<String, Class<?>> knownTypes) {
        if (metaTypeDescription.equals("SetMultimap")) {
            return GuavaSerIteratorFactory.setMultimap(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("ListMultimap")) {
            return GuavaSerIteratorFactory.listMultimap(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("Multimap")) {
            return GuavaSerIteratorFactory.listMultimap(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("Multiset")) {
            return GuavaSerIteratorFactory.multiset(Object.class, EMPTY_VALUE_TYPES);
        }
        return super.createIterable(metaTypeDescription, settings, knownTypes);
    }

    @Override
    public SerIterable createIterable(MetaProperty<?> prop, Class<?> beanClass) {
        if (SortedMultiset.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.sortedMultiset(valueType, valueTypeTypes);
        }
        if (Multiset.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.multiset(valueType, valueTypeTypes);
        }
        if (SetMultimap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.setMultimap(keyType, valueType, valueTypeTypes);
        }
        if (ListMultimap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.listMultimap(keyType, valueType, valueTypeTypes);
        }
        if (Multimap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.listMultimap(keyType, valueType, valueTypeTypes);
        }
        return super.createIterable(prop, beanClass);
    }

    public static final SerIterable multiset(Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashMultiset coll = HashMultiset.create();
        return GuavaSerIteratorFactory.multiset(valueType, valueTypeTypes, (Multiset<Object>)coll);
    }

    public static final SerIterable sortedMultiset(Class<?> valueType, List<Class<?>> valueTypeTypes) {
        Ordering natural = Ordering.natural();
        TreeMultiset coll = TreeMultiset.create((Comparator)natural);
        return GuavaSerIteratorFactory.multiset(valueType, valueTypeTypes, (Multiset<Object>)coll);
    }

    private static SerIterable multiset(final Class<?> valueType, final List<Class<?>> valueTypeTypes, final Multiset<Object> coll) {
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return GuavaSerIteratorFactory.multiset(coll, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                coll.add(value, count);
            }

            @Override
            public Object build() {
                return coll;
            }

            @Override
            public boolean isMapLike() {
                return false;
            }

            @Override
            public Class<?> keyType() {
                return null;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterator multiset(final Multiset<?> multiset, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Multiset.Entry current;
            {
                this.it = multiset.entrySet().iterator();
            }

            @Override
            public String metaTypeName() {
                return "Multiset";
            }

            @Override
            public boolean isMapLike() {
                return false;
            }

            @Override
            public int size() {
                return multiset.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Multiset.Entry)this.it.next();
            }

            @Override
            public Class<?> keyType() {
                return null;
            }

            @Override
            public Object key() {
                return null;
            }

            @Override
            public int count() {
                return this.current.getCount();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current.getElement();
            }
        };
    }

    public static final SerIterable listMultimap(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        ArrayListMultimap map = ArrayListMultimap.create();
        return new SerIterable((ListMultimap)map, keyType, valueType, valueTypeTypes){
            final /* synthetic */ ListMultimap val$map;
            final /* synthetic */ Class val$keyType;
            final /* synthetic */ Class val$valueType;
            final /* synthetic */ List val$valueTypeTypes;
            {
                this.val$map = listMultimap;
                this.val$keyType = clazz;
                this.val$valueType = clazz2;
                this.val$valueTypeTypes = list;
            }

            @Override
            public SerIterator iterator() {
                return GuavaSerIteratorFactory.multimap(this.val$map, this.val$keyType, this.val$valueType, this.val$valueTypeTypes);
            }

            @Override
            public void add(Object key, Object value, int count) {
                if (key == null) {
                    throw new IllegalArgumentException("Missing key");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                this.val$map.put(key, value);
            }

            @Override
            public Object build() {
                return this.val$map;
            }

            @Override
            public boolean isMapLike() {
                return true;
            }

            @Override
            public Class<?> keyType() {
                return this.val$keyType;
            }

            @Override
            public Class<?> valueType() {
                return this.val$valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return this.val$valueTypeTypes;
            }
        };
    }

    public static final SerIterable setMultimap(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashMultimap map = HashMultimap.create();
        return new SerIterable((SetMultimap)map, keyType, valueType, valueTypeTypes){
            final /* synthetic */ SetMultimap val$map;
            final /* synthetic */ Class val$keyType;
            final /* synthetic */ Class val$valueType;
            final /* synthetic */ List val$valueTypeTypes;
            {
                this.val$map = setMultimap;
                this.val$keyType = clazz;
                this.val$valueType = clazz2;
                this.val$valueTypeTypes = list;
            }

            @Override
            public SerIterator iterator() {
                return GuavaSerIteratorFactory.multimap(this.val$map, this.val$keyType, this.val$valueType, this.val$valueTypeTypes);
            }

            @Override
            public void add(Object key, Object value, int count) {
                if (key == null) {
                    throw new IllegalArgumentException("Missing key");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                this.val$map.put(key, value);
            }

            @Override
            public Object build() {
                return this.val$map;
            }

            @Override
            public boolean isMapLike() {
                return true;
            }

            @Override
            public Class<?> keyType() {
                return this.val$keyType;
            }

            @Override
            public Class<?> valueType() {
                return this.val$valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return this.val$valueTypeTypes;
            }
        };
    }

    public static final SerIterator multimap(final Multimap<?, ?> map, final Class<?> keyType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Map.Entry current;
            {
                this.it = map.entries().iterator();
            }

            @Override
            public String metaTypeName() {
                if (map instanceof SetMultimap) {
                    return "SetMultimap";
                }
                if (map instanceof ListMultimap) {
                    return "ListMultimap";
                }
                return "Multimap";
            }

            @Override
            public boolean isMapLike() {
                return true;
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Map.Entry)this.it.next();
            }

            @Override
            public Class<?> keyType() {
                return keyType;
            }

            @Override
            public Object key() {
                return this.current.getKey();
            }

            @Override
            public int count() {
                return 1;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current.getValue();
            }
        };
    }
}

