/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.BeanQuery;
import org.joda.beans.DynamicBean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.impl.flexi.FlexiBean;
import org.joda.beans.impl.map.MapBean;
import org.joda.convert.StringConvert;

public final class JodaBeanUtils {
    private static final ConcurrentHashMap<Class<?>, MetaBean> metaBeans = new ConcurrentHashMap();
    private static final StringConvert converter = new StringConvert();

    private JodaBeanUtils() {
    }

    public static MetaBean metaBean(Class<?> cls) {
        MetaBean meta = metaBeans.get(cls);
        if (meta == null) {
            if (cls == FlexiBean.class) {
                return new FlexiBean().metaBean();
            }
            if (cls == MapBean.class) {
                return new MapBean().metaBean();
            }
            if (DynamicBean.class.isAssignableFrom(cls)) {
                try {
                    return cls.asSubclass(DynamicBean.class).newInstance().metaBean();
                }
                catch (InstantiationException ex) {
                    throw new IllegalArgumentException("Unable to find meta-bean for a DynamicBean: " + cls.getName(), ex);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Unable to find meta-bean for a DynamicBean: " + cls.getName(), ex);
                }
            }
            try {
                cls = Class.forName(cls.getName(), true, cls.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName(), ex);
            }
            catch (Error ex) {
                throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName(), ex);
            }
            meta = metaBeans.get(cls);
            if (meta == null) {
                throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName());
            }
        }
        return meta;
    }

    public static void registerMetaBean(MetaBean metaBean) {
        Class<? extends Bean> type = metaBean.beanType();
        if (metaBeans.putIfAbsent(type, metaBean) != null) {
            throw new IllegalArgumentException("Cannot register class twice: " + type.getName());
        }
    }

    public static StringConvert stringConverter() {
        return converter;
    }

    public static boolean equal(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.getClass().isArray() && obj1.getClass() == obj2.getClass()) {
            if (obj1 instanceof Object[] && obj2 instanceof Object[]) {
                return Arrays.deepEquals((Object[])obj1, (Object[])obj2);
            }
            if (obj1 instanceof int[] && obj2 instanceof int[]) {
                return Arrays.equals((int[])obj1, (int[])obj2);
            }
            if (obj1 instanceof long[] && obj2 instanceof long[]) {
                return Arrays.equals((long[])obj1, (long[])obj2);
            }
            if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
                return Arrays.equals((byte[])obj1, (byte[])obj2);
            }
            if (obj1 instanceof double[] && obj2 instanceof double[]) {
                return Arrays.equals((double[])obj1, (double[])obj2);
            }
            if (obj1 instanceof float[] && obj2 instanceof float[]) {
                return Arrays.equals((float[])obj1, (float[])obj2);
            }
            if (obj1 instanceof char[] && obj2 instanceof char[]) {
                return Arrays.equals((char[])obj1, (char[])obj2);
            }
            if (obj1 instanceof short[] && obj2 instanceof short[]) {
                return Arrays.equals((short[])obj1, (short[])obj2);
            }
            if (obj1 instanceof boolean[] && obj2 instanceof boolean[]) {
                return Arrays.equals((boolean[])obj1, (boolean[])obj2);
            }
        }
        return obj1.equals(obj2);
    }

    public static boolean equal(float val1, float val2) {
        return Float.floatToIntBits(val1) == Float.floatToIntBits(val2);
    }

    public static boolean equal(double val1, double val2) {
        return Double.doubleToLongBits(val1) == Double.doubleToLongBits(val2);
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.deepHashCode((Object[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.hashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.hashCode((long[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.hashCode((byte[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.hashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.hashCode((float[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.hashCode((char[])obj);
            }
            if (obj instanceof short[]) {
                return Arrays.hashCode((short[])obj);
            }
            if (obj instanceof boolean[]) {
                return Arrays.hashCode((boolean[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public static int hashCode(double value) {
        return JodaBeanUtils.hashCode(Double.doubleToLongBits(value));
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.deepToString((Object[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.toString((int[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.toString((long[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.toString((byte[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.toString((double[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.toString((float[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.toString((char[])obj);
            }
            if (obj instanceof short[]) {
                return Arrays.toString((short[])obj);
            }
            if (obj instanceof boolean[]) {
                return Arrays.toString((boolean[])obj);
            }
        }
        return obj.toString();
    }

    public static boolean propertiesEqual(Bean bean1, Bean bean2) {
        Set<String> names = bean1.propertyNames();
        if (!((Object)names).equals(bean2.propertyNames())) {
            return false;
        }
        for (String name : names) {
            Object value2;
            Object value1 = bean1.property(name).get();
            if (JodaBeanUtils.equal(value1, value2 = bean2.property(name).get())) continue;
            return false;
        }
        return true;
    }

    public static int propertiesHashCode(Bean bean) {
        int hash = 7;
        Set<String> names = bean.propertyNames();
        for (String name : names) {
            Object value = bean.property(name).get();
            hash += JodaBeanUtils.hashCode(value);
        }
        return hash;
    }

    public static String propertiesToString(Bean bean, String prefix) {
        Set<String> names = bean.propertyNames();
        StringBuilder buf = new StringBuilder(names.size() * 32 + prefix.length());
        if (prefix != null) {
            buf.append(prefix);
        }
        buf.append('{');
        if (names.size() > 0) {
            for (String name : names) {
                Object value = bean.property(name).get();
                buf.append(name).append('=').append(value).append(',').append(' ');
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append('}');
        return buf.toString();
    }

    public static <T extends Bean> T clone(T original) {
        if (original == null || original instanceof ImmutableBean) {
            return original;
        }
        BeanBuilder<? extends Bean> builder = original.metaBean().builder();
        for (MetaProperty<?> mp : original.metaBean().metaPropertyIterable()) {
            if (!mp.style().isBuildable()) continue;
            Object value = mp.get(original);
            if (value instanceof Bean) {
                value = JodaBeanUtils.clone((Bean)value);
            }
            builder.set(mp.name(), value);
        }
        return (T)builder.build();
    }

    public static void notNull(Object value, String propertyName) {
        if (value == null) {
            throw new IllegalArgumentException("Argument '" + propertyName + "' must not be null");
        }
    }

    public static void notEmpty(String value, String propertyName) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Argument '" + propertyName + "' must not be empty");
        }
    }

    public static Class<?> collectionType(Property<?> prop) {
        return JodaBeanUtils.collectionType(prop.metaProperty(), prop.bean().getClass());
    }

    public static Class<?> collectionType(MetaProperty<?> prop, Class<?> targetClass) {
        return JodaBeanUtils.extractTypeClass(targetClass, prop, 1, 0);
    }

    public static List<Class<?>> collectionTypeTypes(MetaProperty<?> prop, Class<?> targetClass) {
        Type type = JodaBeanUtils.extractType(targetClass, prop, 1, 0);
        return JodaBeanUtils.extractTypeClasses(targetClass, type);
    }

    public static Class<?> mapKeyType(Property<?> prop) {
        return JodaBeanUtils.mapKeyType(prop.metaProperty(), prop.bean().getClass());
    }

    public static Class<?> mapKeyType(MetaProperty<?> prop, Class<?> targetClass) {
        return JodaBeanUtils.extractTypeClass(targetClass, prop, 2, 0);
    }

    public static Class<?> mapValueType(Property<?> prop) {
        return JodaBeanUtils.mapValueType(prop.metaProperty(), prop.bean().getClass());
    }

    public static Class<?> mapValueType(MetaProperty<?> prop, Class<?> targetClass) {
        return JodaBeanUtils.extractTypeClass(targetClass, prop, 2, 1);
    }

    public static List<Class<?>> mapValueTypeTypes(MetaProperty<?> prop, Class<?> targetClass) {
        Type type = JodaBeanUtils.extractType(targetClass, prop, 2, 1);
        return JodaBeanUtils.extractTypeClasses(targetClass, type);
    }

    private static Class<?> extractTypeClass(Class<?> targetClass, MetaProperty<?> prop, int size, int index) {
        return JodaBeanUtils.eraseToClass(JodaBeanUtils.extractType(targetClass, prop, size, index));
    }

    private static Type extractType(Class<?> targetClass, MetaProperty<?> prop, int size, int index) {
        ParameterizedType pt;
        Type[] types;
        Type genType = prop.propertyGenericType();
        if (genType instanceof ParameterizedType && (types = (pt = (ParameterizedType)genType).getActualTypeArguments()).length == size) {
            Type type = types[index];
            if (type instanceof TypeVariable) {
                type = JodaBeanUtils.resolveGenerics(targetClass, (TypeVariable)type);
            }
            return type;
        }
        return null;
    }

    private static List<Class<?>> extractTypeClasses(Class<?> targetClass, Type type) {
        ArrayList result = new ArrayList();
        if (type != null && type instanceof ParameterizedType) {
            Type[] actualTypes;
            ParameterizedType pt = (ParameterizedType)type;
            for (Type actualType : actualTypes = pt.getActualTypeArguments()) {
                Class<?> cls;
                if (actualType instanceof TypeVariable) {
                    actualType = JodaBeanUtils.resolveGenerics(targetClass, (TypeVariable)actualType);
                }
                result.add((cls = JodaBeanUtils.eraseToClass(actualType)) != null ? cls : Object.class);
            }
        }
        return result;
    }

    private static Type resolveGenerics(Class<?> targetClass, TypeVariable<?> typevar) {
        HashMap resolved = new HashMap();
        Type type = targetClass;
        while (type != null) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)type;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            Class<?> rawType = JodaBeanUtils.eraseToClass(pt.getRawType());
            TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolved.put(typeParameters[i], actualTypeArguments[i]);
            }
            type = rawType.getGenericSuperclass();
        }
        Type result = typevar;
        while (resolved.containsKey(result)) {
            result = (Type)resolved.get(result);
        }
        return result;
    }

    private static Class<?> eraseToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return JodaBeanUtils.eraseToClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = JodaBeanUtils.eraseToClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
        } else if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            if (bounds.length == 0) {
                return Object.class;
            }
            return JodaBeanUtils.eraseToClass(bounds[0]);
        }
        return null;
    }

    public static Comparator<Bean> comparator(BeanQuery<?> query, boolean ascending) {
        return ascending ? JodaBeanUtils.comparatorAscending(query) : JodaBeanUtils.comparatorDescending(query);
    }

    public static Comparator<Bean> comparatorAscending(BeanQuery<?> query) {
        if (query == null) {
            throw new NullPointerException("BeanQuery must not be null");
        }
        return new Comp(query);
    }

    public static Comparator<Bean> comparatorDescending(BeanQuery<?> query) {
        if (query == null) {
            throw new NullPointerException("BeanQuery must not be null");
        }
        return Collections.reverseOrder(new Comp(query));
    }

    private static final class Comp
    implements Comparator<Bean> {
        private final BeanQuery<?> query;

        private Comp(BeanQuery<?> query) {
            this.query = query;
        }

        @Override
        public int compare(Bean bean1, Bean bean2) {
            Comparable value1 = (Comparable)this.query.get(bean1);
            Object value2 = this.query.get(bean2);
            return value1.compareTo(value2);
        }
    }
}

