/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.BeanDefinition;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.PropertyDefinition;
import org.joda.beans.gen.BeanGenConfig;
import org.joda.beans.gen.GeneratableBean;
import org.joda.beans.gen.GeneratableProperty;
import org.joda.beans.gen.PropertyGen;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.direct.DirectBean;
import org.joda.beans.impl.direct.DirectBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

class BeanGen {
    private static final String AUTOGENERATED_START_TEXT = "AUTOGENERATED START";
    private static final String AUTOGENERATED_START = "\t//------------------------- AUTOGENERATED START -------------------------";
    private static final String AUTOGENERATED_END = "\t//-------------------------- AUTOGENERATED END --------------------------";
    private static final String LINE_SEPARATOR = "\t//-----------------------------------------------------------------------";
    private static final String LINE_SEPARATOR_INDENTED = "\t\t//-----------------------------------------------------------------------";
    private static final Pattern BEAN_TYPE = Pattern.compile(".*class +(([A-Z][A-Za-z0-9_]+)(?:<([A-Z])( +extends +[A-Za-z0-9_]+)?>)?).*");
    private static final Pattern SUPER_TYPE = Pattern.compile(".* extends +(([A-Z][A-Za-z0-9_]+)(?:<([A-Z][A-Za-z0-9_<> ]*)>)?).*");
    private static final Pattern SUPER_IMPL_TYPE = Pattern.compile(".* implements.*[ ,]((Immutable)?Bean)[ ,].*");
    private static final Pattern STYLE_PATTERN = Pattern.compile(".*[ ,(]style[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern BUILDER_SCOPE_PATTERN = Pattern.compile(".*[ ,(]builderScope[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Set<String> PRIMITIVE_EQUALS = new HashSet<String>();
    private final List<String> content;
    private final BeanGenConfig config;
    private final int autoStartIndex;
    private final int autoEndIndex;
    private final List<String> insertRegion;
    private final List<PropertyGen> properties;
    private final GeneratableBean data;

    BeanGen(List<String> content, BeanGenConfig config) {
        this.content = content;
        this.config = config;
        int beanDefIndex = this.parseBeanDefinition();
        if (beanDefIndex >= 0) {
            this.data = new GeneratableBean();
            this.data.getCurrentImports().addAll(this.parseImports(beanDefIndex));
            this.data.setImportInsertLocation(this.parseImportLocation(beanDefIndex));
            this.data.setBeanStyle(this.parseBeanStyle(beanDefIndex));
            if (!this.data.isBeanStyleValid()) {
                throw new RuntimeException("Invalid bean style: " + this.data.getBeanStyle());
            }
            this.data.setBeanBuilderScope(this.parseBeanBuilderScope(beanDefIndex));
            if (!this.data.isBeanBuilderScopeValid()) {
                throw new RuntimeException("Invalid bean builder scope: " + this.data.getBeanStyle());
            }
            this.data.setImmutableConstructor(this.parseImmutableConstructor(beanDefIndex));
            this.data.setConstructable(this.parseConstructable(beanDefIndex));
            this.data.setTypeParts(this.parseBeanType(beanDefIndex));
            this.data.setSuperTypeParts(this.parseBeanSuperType(beanDefIndex));
            this.properties = this.parseProperties(this.data);
            this.autoStartIndex = this.parseStartAutogen();
            this.autoEndIndex = this.parseEndAutogen();
            this.insertRegion = content.subList(this.autoStartIndex + 1, this.autoEndIndex);
            this.data.setManualClone(this.parseManualClone(beanDefIndex));
            this.data.setManualEqualsHashCode(this.parseManualEqualsHashCode(beanDefIndex));
            this.data.setManualToStringCode(this.parseManualToStringCode(beanDefIndex));
            if (this.data.isImmutable()) {
                if (!this.data.isTypeFinal()) {
                    throw new RuntimeException("ImmutableBean must be final: " + this.data.getTypeRaw());
                }
                for (PropertyGen prop : this.properties) {
                    if (prop.getData().isDerived() || prop.getData().isFinal()) continue;
                    throw new RuntimeException("ImmutableBean must have final properties: " + this.data.getTypeRaw() + "." + prop.getData().getFieldName());
                }
            } else if (this.data.isImmutableConstructor()) {
                throw new RuntimeException("Mutable beans must not specify @ImmutableConstructor: " + this.data.getTypeRaw());
            }
        } else {
            this.autoStartIndex = -1;
            this.autoEndIndex = -1;
            this.insertRegion = null;
            this.data = null;
            this.properties = null;
        }
    }

    void process() {
        if (this.insertRegion != null) {
            this.data.ensureImport(BeanDefinition.class);
            if (this.data.isImmutable()) {
                this.data.ensureImport(ImmutableBean.class);
            }
            if (this.properties.size() > 0) {
                this.data.ensureImport(PropertyDefinition.class);
            }
            this.removeOld();
            if (this.data.isRootClass() && this.data.isExtendsDirectBean()) {
                this.data.ensureImport(DirectBean.class);
            }
            this.insertRegion.add("\t///CLOVER:OFF");
            this.generateMeta();
            this.generateImmutableBuilderMethod();
            this.generateImmutableConstructor();
            this.generateMetaBean();
            this.generatePropertyByName();
            this.generatePropertyNames();
            this.generateGettersSetters();
            this.generateSeparator();
            this.generateImmutableToBuilder();
            this.generateClone();
            this.generateEquals();
            this.generateHashCode();
            this.generateToString();
            this.generateMetaClass();
            this.generateBuilderClass();
            this.insertRegion.add("\t///CLOVER:ON");
            this.resolveImports();
            this.resolveIndents();
        }
    }

    private void resolveImports() {
        if (this.data.getNewImports().size() > 0) {
            int pos = this.data.getImportInsertLocation() + 1;
            for (String imp : this.data.getNewImports()) {
                this.content.add(pos++, "import " + imp + ";");
            }
        }
    }

    private void resolveIndents() {
        ListIterator<String> it = this.content.listIterator();
        while (it.hasNext()) {
            it.set(it.next().replace("\t", this.config.getIndent()));
        }
    }

    private int parseBeanDefinition() {
        for (int index = 0; index < this.content.size(); ++index) {
            String line = this.content.get(index).trim();
            if (!line.startsWith("@BeanDefinition")) continue;
            return index;
        }
        return -1;
    }

    private Set<String> parseImports(int defLine) {
        HashSet<String> imports = new HashSet<String>();
        for (int index = 0; index < defLine; ++index) {
            if (!this.content.get(index).startsWith("import ")) continue;
            String imp = this.content.get(index).substring(7).trim();
            if ((imp = imp.substring(0, imp.indexOf(59))).endsWith(".*")) continue;
            imports.add(imp);
        }
        return imports;
    }

    private int parseImportLocation(int defLine) {
        int location = 0;
        for (int index = 0; index < defLine; ++index) {
            if (!this.content.get(index).startsWith("import ") && !this.content.get(index).startsWith("package ")) continue;
            location = index;
        }
        return location;
    }

    private String parseBeanStyle(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = STYLE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseBeanBuilderScope(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = BUILDER_SCOPE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private boolean parseConstructable(int defLine) {
        for (int index = defLine; index < this.content.size(); ++index) {
            if (!this.content.get(index).contains(" abstract class ")) continue;
            return false;
        }
        return true;
    }

    private String[] parseBeanType(int defLine) {
        Matcher matcher = BEAN_TYPE.matcher("");
        for (int index = defLine; index < this.content.size(); ++index) {
            String line = this.content.get(index);
            matcher.reset(line);
            if (matcher.matches()) {
                int startName = matcher.start(1);
                String fnl = line.substring(0, startName).contains(" final ") ? " final " : null;
                return new String[]{fnl, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)};
            }
            if (line.contains(AUTOGENERATED_START_TEXT)) break;
        }
        throw new RuntimeException("Unable to locate bean class name");
    }

    private String[] parseBeanSuperType(int defLine) {
        Matcher matcherExtends = SUPER_TYPE.matcher("");
        Matcher matcherImplements = SUPER_IMPL_TYPE.matcher("");
        for (int index = defLine; index < this.content.size(); ++index) {
            String line = this.content.get(index);
            matcherImplements.reset(line);
            if (matcherImplements.matches()) {
                return new String[]{matcherImplements.group(1)};
            }
            matcherExtends.reset(line);
            if (matcherExtends.matches()) {
                return new String[]{matcherExtends.group(1), matcherExtends.group(2), matcherExtends.group(3)};
            }
            if (line.contains(AUTOGENERATED_START_TEXT)) break;
        }
        throw new RuntimeException("Unable to locate bean superclass");
    }

    private boolean parseImmutableConstructor(int defLine) {
        boolean found = false;
        for (int index = defLine; index < this.content.size(); ++index) {
            if (!this.content.get(index).trim().equals("@ImmutableConstructor")) continue;
            if (found) {
                throw new RuntimeException("Only one @ImmutableConstructor mau be specified");
            }
            found = true;
        }
        return found;
    }

    private List<PropertyGen> parseProperties(GeneratableBean data) {
        ArrayList<PropertyGen> props = new ArrayList<PropertyGen>();
        for (int index = 0; index < this.content.size(); ++index) {
            PropertyGen prop;
            String line = this.content.get(index).trim();
            if (line.startsWith("@PropertyDefinition")) {
                prop = new PropertyGen(this, this.content, index, false);
                props.add(prop);
                data.getProperties().add(prop.getData());
                continue;
            }
            if (!line.startsWith("@DerivedProperty")) continue;
            prop = new PropertyGen(this, this.content, index, true);
            props.add(prop);
            data.getProperties().add(prop.getData());
        }
        return props;
    }

    private int parseStartAutogen() {
        String line;
        int index;
        for (index = 0; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.contains(" AUTOGENERATED START ")) continue;
            this.content.set(index, AUTOGENERATED_START);
            return index;
        }
        for (index = this.content.size() - 1; index >= 0; --index) {
            line = this.content.get(index).trim();
            if (line.equals("}")) {
                this.content.add(index, AUTOGENERATED_START);
                return index;
            }
            if (line.length() > 0) break;
        }
        throw new RuntimeException("Unable to locate start autogeneration point");
    }

    private int parseEndAutogen() {
        for (int index = this.autoStartIndex; index < this.content.size(); ++index) {
            String line = this.content.get(index).trim();
            if (!line.contains(" AUTOGENERATED END ")) continue;
            this.content.set(index, AUTOGENERATED_END);
            return index;
        }
        this.content.add(this.autoStartIndex + 1, AUTOGENERATED_END);
        return this.autoStartIndex + 1;
    }

    private void removeOld() {
        this.insertRegion.clear();
    }

    private boolean parseManualClone(int defLine) {
        String line;
        int index;
        for (index = defLine; index < this.autoStartIndex; ++index) {
            line = this.content.get(index).trim();
            if (!line.startsWith("public ") || !line.endsWith(" clone() {")) continue;
            return true;
        }
        for (index = this.autoEndIndex; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.startsWith("public ") || !line.endsWith(" clone() {")) continue;
            return true;
        }
        return false;
    }

    private boolean parseManualEqualsHashCode(int defLine) {
        String line;
        int index;
        for (index = defLine; index < this.autoStartIndex; ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public int hashCode() {") && (!line.startsWith("public boolean equals(") || !line.endsWith(") {"))) continue;
            return true;
        }
        for (index = this.autoEndIndex; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public int hashCode() {") && (!line.startsWith("public boolean equals(") || !line.endsWith(") {"))) continue;
            return true;
        }
        return false;
    }

    private boolean parseManualToStringCode(int defLine) {
        String line;
        int index;
        for (index = defLine; index < this.autoStartIndex; ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public String toString() {")) continue;
            return true;
        }
        for (index = this.autoEndIndex; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public String toString() {")) continue;
            return true;
        }
        return false;
    }

    private void generateSeparator() {
        if (this.insertRegion.size() > 0 && this.insertRegion.get(this.insertRegion.size() - 1).equals(LINE_SEPARATOR)) {
            return;
        }
        this.insertRegion.add(LINE_SEPARATOR);
    }

    private void generateIndentedSeparator() {
        if (this.insertRegion.size() > 0 && this.insertRegion.get(this.insertRegion.size() - 1).equals(LINE_SEPARATOR_INDENTED)) {
            return;
        }
        this.insertRegion.add(LINE_SEPARATOR_INDENTED);
    }

    private void generateImmutableBuilderMethod() {
        if (this.data.isImmutable() && this.data.isEffectiveBuilderScopePublic()) {
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * Returns a builder used to create an instance of the bean.");
            this.insertRegion.add("\t *");
            if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\t * @param " + this.data.getTypeGenericName(true) + "  the type");
            }
            this.insertRegion.add("\t * @return the builder, not null");
            this.insertRegion.add("\t */");
            if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\tpublic static " + this.data.getTypeGeneric(true) + " " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder() {");
            } else {
                this.insertRegion.add("\tpublic static " + this.data.getTypeRaw() + ".Builder builder() {");
            }
            this.insertRegion.add("\t\treturn new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + "();");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateImmutableConstructor() {
        if (this.data.isImmutable() && !this.data.isImmutableConstructor()) {
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            if (nonDerived.size() == 0) {
                this.insertRegion.add("\tprivate " + this.data.getTypeRaw() + "() {");
            } else {
                this.insertRegion.add("\tprivate " + this.data.getTypeRaw() + "(");
                for (int i = 0; i < nonDerived.size(); ++i) {
                    PropertyGen prop = nonDerived.get(i);
                    this.insertRegion.add("\t\t\t" + prop.getBuilderType() + " " + prop.getData().getPropertyName() + (i < nonDerived.size() - 1 ? "," : ") {"));
                }
                for (PropertyGen prop : this.properties) {
                    if (!prop.getData().isValidated()) continue;
                    this.insertRegion.add("\t\t" + prop.getData().getValidationMethodName() + "(" + prop.getData().getPropertyName() + ", \"" + prop.getData().getPropertyName() + "\");");
                }
                for (int i = 0; i < nonDerived.size(); ++i) {
                    this.insertRegion.addAll(nonDerived.get(i).generateConstructorAssign());
                }
            }
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateMeta() {
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t * @return the meta-bean, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\t@SuppressWarnings(\"rawtypes\")");
            this.insertRegion.add("\tpublic static " + this.data.getTypeRaw() + ".Meta meta() {");
        } else {
            this.insertRegion.add("\t * @return the meta-bean, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tpublic static " + this.data.getTypeRaw() + ".Meta meta() {");
        }
        this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
        this.insertRegion.add("\t}");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("");
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.insertRegion.add("\t * @param <R>  the bean's generic type");
            this.insertRegion.add("\t * @param cls  the bean's generic type");
            this.insertRegion.add("\t * @return the meta-bean, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
            this.insertRegion.add("\tpublic static <R" + this.data.getTypeGenericExtends() + "> " + this.data.getTypeRaw() + ".Meta<R> meta" + this.data.getTypeRaw() + "(Class<R> cls) {");
            this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            this.insertRegion.add("\t}");
        }
        this.insertRegion.add("");
        this.insertRegion.add("\tstatic {");
        this.insertRegion.add("\t\tJodaBeanUtils.registerMetaBean(" + this.data.getTypeRaw() + ".Meta.INSTANCE);");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateMetaBean() {
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
        }
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic " + this.data.getTypeRaw() + ".Meta" + this.data.getTypeGenericName(true) + " metaBean() {");
        this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateGettersSetters() {
        for (PropertyGen prop : this.properties) {
            this.generateSeparator();
            this.insertRegion.addAll(prop.generateGetter());
            if (this.data.isMutable()) {
                this.insertRegion.addAll(prop.generateSetter());
            }
            if (!this.data.isBeanStyleGenerateProperties()) continue;
            this.insertRegion.addAll(prop.generateProperty());
        }
    }

    private void generatePropertyByName() {
        if (this.data.isRootClass() && !this.data.isExtendsDirectBean()) {
            this.data.ensureImport(Property.class);
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic <R> Property<R> property(String propertyName) {");
            this.insertRegion.add("\t\treturn metaBean().<R>metaProperty(propertyName).createProperty(this);");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generatePropertyNames() {
        if (this.data.isRootClass() && !this.data.isExtendsDirectBean()) {
            this.data.ensureImport(Set.class);
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic Set<String> propertyNames() {");
            this.insertRegion.add("\t\treturn metaBean().metaPropertyMap().keySet();");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateImmutableToBuilder() {
        List<PropertyGen> nonDerived;
        if (this.data.isImmutable() && this.data.isEffectiveBuilderScopePublic() && (nonDerived = this.nonDerivedProperties()).size() > 0) {
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * Returns a builder that allows this bean to be mutated.");
            this.insertRegion.add("\t * @return the mutable builder, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tpublic Builder" + this.data.getTypeGenericName(true) + " toBuilder() {");
            this.insertRegion.add("\t\treturn new Builder" + this.data.getTypeGenericName(true) + "(this);");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateClone() {
        if (this.data.isManualClone() || !this.data.isRootClass() && !this.data.isConstructable()) {
            return;
        }
        this.insertRegion.add("\t@Override");
        if (this.data.isImmutable()) {
            this.insertRegion.add("\tpublic " + this.data.getTypeNoExtends() + " clone() {");
            this.insertRegion.add("\t\treturn this;");
        } else if (this.data.isRootClass()) {
            this.data.ensureImport(Bean.class);
            if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
            }
            this.insertRegion.add("\tpublic " + this.data.getTypeNoExtends() + " clone() {");
            if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\t\tBeanBuilder<?> builder = metaBean().builder();");
            } else {
                this.insertRegion.add("\t\tBeanBuilder<? extends " + this.data.getType() + "> builder = metaBean().builder();");
            }
            this.insertRegion.add("\t\tfor (MetaProperty<?> mp : metaBean().metaPropertyIterable()) {");
            this.insertRegion.add("\t\t\tif (mp.style().isBuildable()) {");
            this.insertRegion.add("\t\t\t\tObject value = mp.get(this);");
            this.insertRegion.add("\t\t\t\tif (value instanceof Bean) {");
            this.insertRegion.add("\t\t\t\t\tvalue = ((Bean) value).clone();");
            this.insertRegion.add("\t\t\t\t}");
            this.insertRegion.add("\t\t\t\tbuilder.set(mp.name(), value);");
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t}");
            if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\t\treturn (" + this.data.getTypeNoExtends() + ") builder.build();");
            } else {
                this.insertRegion.add("\t\treturn builder.build();");
            }
        } else {
            if (this.data.isTypeGeneric()) {
                if (this.data.isSuperTypeGeneric()) {
                    if (!this.data.getSuperType().contains(this.data.getTypeGenericName(true))) {
                        this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
                    }
                } else {
                    this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
                }
            }
            this.insertRegion.add("\tpublic " + this.data.getTypeNoExtends() + " clone() {");
            this.insertRegion.add("\t\treturn (" + this.data.getTypeNoExtends() + ") super.clone();");
        }
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateEquals() {
        if (this.data.isManualEqualsHashCode()) {
            return;
        }
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic boolean equals(Object obj) {");
        this.insertRegion.add("\t\tif (obj == this) {");
        this.insertRegion.add("\t\t\treturn true;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\tif (obj != null && obj.getClass() == this.getClass()) {");
        if (this.properties.size() == 0) {
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\t\treturn super.equals(obj);");
            } else {
                this.insertRegion.add("\t\t\treturn true;");
            }
        } else {
            this.insertRegion.add("\t\t\t" + this.data.getTypeWildcard() + " other = (" + this.data.getTypeWildcard() + ") obj;");
            for (int i = 0; i < this.properties.size(); ++i) {
                PropertyGen prop = this.properties.get(i);
                String getter = prop.getData().getGetterGen().generateGetInvoke(prop.getData());
                String equals = "JodaBeanUtils.equal(" + getter + ", other." + getter + ")";
                if (PRIMITIVE_EQUALS.contains(prop.getData().getType())) {
                    equals = "(" + getter + " == other." + getter + ")";
                }
                this.insertRegion.add((i == 0 ? "\t\t\treturn " : "\t\t\t\t\t") + equals + (this.data.isSubClass() || i < this.properties.size() - 1 ? " &&" : ";"));
            }
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\t\t\t\tsuper.equals(obj);");
            }
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\treturn false;");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateHashCode() {
        if (this.data.isManualEqualsHashCode()) {
            return;
        }
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic int hashCode() {");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\tint hash = 7;");
        } else {
            this.insertRegion.add("\t\tint hash = getClass().hashCode();");
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyGen prop = this.properties.get(i);
            String getter = prop.getData().getGetterGen().generateGetInvoke(prop.getData());
            this.insertRegion.add("\t\thash += hash * 31 + JodaBeanUtils.hashCode(" + getter + ");");
        }
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\treturn hash ^ super.hashCode();");
        } else {
            this.insertRegion.add("\t\treturn hash;");
        }
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateToString() {
        if (this.data.isManualToStringCode()) {
            return;
        }
        if (this.data.isRootClass() && this.data.isTypeFinal()) {
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic String toString() {");
            this.insertRegion.add("\t\tStringBuilder buf = new StringBuilder(" + (this.properties.size() * 32 + 32) + ");");
            this.insertRegion.add("\t\tbuf.append(\"" + this.data.getTypeRaw() + "{\");");
            for (int i = 0; i < this.properties.size(); ++i) {
                PropertyGen prop = this.properties.get(i);
                String getter = prop.getData().getGetterGen().generateGetInvoke(prop.getData());
                if (i < this.properties.size() - 1) {
                    this.insertRegion.add("\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(" + getter + ").append(',').append(' ');");
                    continue;
                }
                this.insertRegion.add("\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + "));");
            }
            this.insertRegion.add("\t\tbuf.append('}');");
            this.insertRegion.add("\t\treturn buf.toString();");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
            return;
        }
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic String toString() {");
        this.insertRegion.add("\t\tStringBuilder buf = new StringBuilder(" + (this.properties.size() * 32 + 32) + ");");
        this.insertRegion.add("\t\tbuf.append(\"" + this.data.getTypeRaw() + "{\");");
        this.insertRegion.add("\t\tint len = buf.length();");
        this.insertRegion.add("\t\ttoString(buf);");
        this.insertRegion.add("\t\tif (buf.length() > len) {");
        this.insertRegion.add("\t\t\tbuf.setLength(buf.length() - 2);");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\tbuf.append('}');");
        this.insertRegion.add("\t\treturn buf.toString();");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t@Override");
        }
        this.insertRegion.add("\tprotected void toString(StringBuilder buf) {");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\tsuper.toString(buf);");
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyGen prop = this.properties.get(i);
            String getter = prop.getData().getGetterGen().generateGetInvoke(prop.getData());
            this.insertRegion.add("\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + ")).append(',').append(' ');");
        }
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateMetaClass() {
        String finalType;
        String superMeta;
        this.generateSeparator();
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        this.insertRegion.add("\t */");
        if (this.data.isSubClass()) {
            superMeta = this.data.getSuperTypeRaw() + ".Meta" + this.data.getSuperTypeGeneric(true);
        } else {
            this.data.ensureImport(DirectMetaBean.class);
            superMeta = "DirectMetaBean";
        }
        String string = finalType = this.data.isTypeFinal() ? "final " : "";
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\tpublic static " + finalType + "class Meta" + this.data.getTypeGeneric(true) + " extends " + superMeta + " {");
        } else {
            this.insertRegion.add("\tpublic static " + finalType + "class Meta extends " + superMeta + " {");
        }
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * The singleton instance of the meta-bean.");
        this.insertRegion.add("\t\t */");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t@SuppressWarnings(\"rawtypes\")");
        }
        this.insertRegion.add("\t\tstatic final Meta INSTANCE = new Meta();");
        this.insertRegion.add("");
        this.generateMetaPropertyConstants();
        this.generateMetaPropertyMapSetup();
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * Restricted constructor.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\tprotected Meta() {");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        this.generateMetaPropertyGet();
        this.generateMetaBuilder();
        this.generateMetaBeanType();
        this.generateMetaPropertyMap();
        this.generateIndentedSeparator();
        this.generateMetaPropertyMethods();
        this.generateIndentedSeparator();
        this.generateMetaGetPropertyValue();
        this.generateMetaSetPropertyValue();
        this.generateMetaValidate();
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyConstants() {
        for (PropertyGen prop : this.properties) {
            this.insertRegion.addAll(prop.generateMetaPropertyConstant());
        }
    }

    private void generateMetaPropertyMapSetup() {
        this.data.ensureImport(MetaProperty.class);
        this.data.ensureImport(DirectMetaPropertyMap.class);
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * The meta-properties.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\tprivate final Map<String, MetaProperty<?>> " + this.config.getPrefix() + "metaPropertyMap$ = new DirectMetaPropertyMap(");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\t\t\tthis, (DirectMetaPropertyMap) super.metaPropertyMap()" + (this.properties.size() == 0 ? ");" : ","));
        } else {
            this.insertRegion.add("\t\t\t\tthis, null" + (this.properties.size() == 0 ? ");" : ","));
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            String line = "\t\t\t\t\"" + this.properties.get(i).getData().getPropertyName() + "\"";
            line = line + (i + 1 == this.properties.size() ? ");" : ",");
            this.insertRegion.add(line);
        }
        this.insertRegion.add("");
    }

    private void generateMetaBuilder() {
        this.insertRegion.add("\t\t@Override");
        if (this.data.isImmutable()) {
            this.insertRegion.add("\t\tpublic " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder() {");
            this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + "();");
        } else {
            this.data.ensureImport(BeanBuilder.class);
            this.insertRegion.add("\t\tpublic BeanBuilder<? extends " + this.data.getTypeNoExtends() + "> builder() {");
            if (this.data.isConstructable()) {
                this.data.ensureImport(DirectBeanBuilder.class);
                this.insertRegion.add("\t\t\treturn new DirectBeanBuilder<" + this.data.getTypeNoExtends() + ">(new " + this.data.getTypeNoExtends() + "());");
            } else {
                this.insertRegion.add("\t\t\tthrow new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
            }
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaBeanType() {
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Class<? extends " + this.data.getTypeNoExtends() + "> beanType() {");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t\treturn (Class) " + this.data.getTypeRaw() + ".class;");
        } else {
            this.insertRegion.add("\t\t\treturn " + this.data.getTypeNoExtends() + ".class;");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyGet() {
        if (this.properties.size() > 0) {
            this.data.ensureImport(MetaProperty.class);
            this.insertRegion.add("\t\t@Override");
            this.insertRegion.add("\t\tprotected MetaProperty<?> metaPropertyGet(String propertyName) {");
            this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen prop : this.properties) {
                this.insertRegion.addAll(prop.generateMetaPropertyGetCase());
            }
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t\treturn super.metaPropertyGet(propertyName);");
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
        }
    }

    private void generateMetaPropertyMap() {
        this.data.ensureImport(Map.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Map<String, MetaProperty<?>> metaPropertyMap() {");
        this.insertRegion.add("\t\t\treturn " + this.config.getPrefix() + "metaPropertyMap$;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyMethods() {
        if (this.data.isBeanStyleGenerateMetaProperties()) {
            for (PropertyGen prop : this.properties) {
                this.insertRegion.addAll(prop.generateMetaProperty());
            }
        }
    }

    private void generateMetaGetPropertyValue() {
        if (this.properties.size() == 0) {
            return;
        }
        this.data.ensureImport(Bean.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tprotected Object propertyGet(Bean bean, String propertyName, boolean quiet) {");
        this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
        for (PropertyGen prop : this.properties) {
            this.insertRegion.addAll(prop.generatePropertyGetCase());
        }
        this.insertRegion.add("\t\t\t}");
        this.insertRegion.add("\t\t\treturn super.propertyGet(bean, propertyName, quiet);");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaSetPropertyValue() {
        if (this.properties.size() == 0) {
            return;
        }
        this.data.ensureImport(Bean.class);
        if (this.data.isImmutable()) {
            this.insertRegion.add("\t\t@Override");
            this.insertRegion.add("\t\tprotected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {");
            this.insertRegion.add("\t\t\tmetaProperty(propertyName);");
            this.insertRegion.add("\t\t\tif (quiet) {");
            this.insertRegion.add("\t\t\t\treturn;");
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t\tthrow new UnsupportedOperationException(\"Property cannot be written: \" + propertyName);");
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
            return;
        }
        boolean generics = this.data.isTypeGeneric() && this.properties.size() > 0;
        for (GeneratableProperty generatableProperty : this.data.getProperties()) {
            generics |= generatableProperty.getStyle().isWritable() && generatableProperty.isGeneric() && !generatableProperty.isGenericWildcardParamType();
        }
        if (generics) {
            this.insertRegion.add("\t\t@SuppressWarnings(\"unchecked\")");
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tprotected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {");
        this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
        for (PropertyGen propertyGen : this.properties) {
            this.insertRegion.addAll(propertyGen.generatePropertySetCase());
        }
        this.insertRegion.add("\t\t\t}");
        this.insertRegion.add("\t\t\tsuper.propertySet(bean, propertyName, newValue, quiet);");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaValidate() {
        if (!this.data.isValidated() || this.data.isImmutable()) {
            return;
        }
        this.data.ensureImport(Bean.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tprotected void validate(Bean bean) {");
        if (this.data.isValidated()) {
            for (PropertyGen prop : this.properties) {
                if (!prop.getData().isValidated()) continue;
                this.insertRegion.add("\t\t\t" + prop.getData().getValidationMethodName() + "(((" + this.data.getTypeWildcard() + ") bean)." + prop.getData().getFieldName() + ", \"" + prop.getData().getPropertyName() + "\");");
            }
        }
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\t\tsuper.validate(bean);");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderClass() {
        if (this.data.isMutable()) {
            return;
        }
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.data.ensureImport(BasicImmutableBeanBuilder.class);
        this.generateSeparator();
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The bean-builder for {@code " + this.data.getTypeRaw() + "}.");
        this.insertRegion.add("\t */");
        this.insertRegion.add("\t" + this.data.getEffectiveBuilderScope() + " static " + (this.data.isTypeFinal() ? "final " : "") + "class Builder" + this.data.getTypeGeneric(true) + " extends BasicImmutableBeanBuilder<" + this.data.getTypeNoExtends() + "> {");
        if (nonDerived.size() > 0) {
            this.insertRegion.add("");
            this.generateBuilderProperties();
        }
        this.insertRegion.add("");
        this.generateBuilderConstructor();
        this.generateIndentedSeparator();
        this.generateBuilderSet();
        this.generateBuilderBuilder();
        this.generateIndentedSeparator();
        this.generateBuilderPropertySetMethods();
        this.generateIndentedSeparator();
        this.generateBuilderToString();
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderConstructor() {
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * Restricted constructor.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\tprivate Builder() {");
        this.insertRegion.add("\t\t\tsuper(" + this.data.getTypeRaw() + ".Meta.INSTANCE);");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        if (nonDerived.size() > 0) {
            this.insertRegion.add("\t\t/**");
            this.insertRegion.add("\t\t * Restricted copy constructor.");
            this.insertRegion.add("\t\t * @param beanToCopy  the bean to copy from, not null");
            this.insertRegion.add("\t\t */");
            this.insertRegion.add("\t\tprivate Builder(" + this.data.getTypeNoExtends() + " beanToCopy) {");
            this.insertRegion.add("\t\t\tsuper(" + this.data.getTypeRaw() + ".Meta.INSTANCE);");
            for (int i = 0; i < nonDerived.size(); ++i) {
                this.insertRegion.addAll(nonDerived.get(i).generateBuilderConstructorAssign("beanToCopy"));
            }
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
        }
    }

    private void generateBuilderProperties() {
        for (PropertyGen prop : this.nonDerivedProperties()) {
            this.insertRegion.addAll(prop.generateBuilderField());
        }
    }

    private void generateBuilderSet() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.data.ensureImport(NoSuchElementException.class);
        boolean generics = this.data.isTypeGeneric() && nonDerived.size() > 0;
        for (GeneratableProperty generatableProperty : this.data.getProperties()) {
            generics |= generatableProperty.isGeneric() && !generatableProperty.isGenericWildcardParamType();
        }
        if (generics) {
            this.insertRegion.add("\t\t@SuppressWarnings(\"unchecked\")");
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Builder" + this.data.getTypeGenericName(true) + " set(String propertyName, Object newValue) {");
        if (nonDerived.size() > 0) {
            this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen propertyGen : nonDerived) {
                this.insertRegion.addAll(propertyGen.generateBuilderFieldSet());
            }
            this.insertRegion.add("\t\t\t\tdefault:");
            this.insertRegion.add("\t\t\t\t\tthrow new NoSuchElementException(\"Unknown property: \" + propertyName);");
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t\treturn this;");
        } else {
            this.insertRegion.add("\t\t\tthrow new NoSuchElementException(\"Unknown property: \" + propertyName);");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderBuilder() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + " build() {");
        if (nonDerived.size() == 0) {
            this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + "();");
        } else {
            this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + "(");
            for (int i = 0; i < nonDerived.size(); ++i) {
                this.insertRegion.add("\t\t\t\t\t" + nonDerived.get(i).generateBuilderFieldName() + (i < nonDerived.size() - 1 ? "," : ");"));
            }
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderPropertySetMethods() {
        if (this.data.isEffectiveBuilderScopePublic()) {
            for (PropertyGen prop : this.nonDerivedProperties()) {
                this.insertRegion.addAll(prop.generateBuilderSetMethod());
            }
        }
    }

    private void generateBuilderToString() {
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic String toString() {");
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        if (nonDerived.size() == 0) {
            this.insertRegion.add("\t\t\treturn \"" + this.data.getTypeRaw() + ".Builder{}\";");
        } else {
            this.insertRegion.add("\t\t\tStringBuilder buf = new StringBuilder(" + (nonDerived.size() * 32 + 32) + ");");
            this.insertRegion.add("\t\t\tbuf.append(\"" + this.data.getTypeRaw() + ".Builder{\");");
            for (int i = 0; i < nonDerived.size(); ++i) {
                PropertyGen prop = nonDerived.get(i);
                String base = "\t\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(" + nonDerived.get(i).generateBuilderFieldName() + ")";
                if (i < nonDerived.size() - 1) {
                    this.insertRegion.add(base + ".append(',').append(' ');");
                    continue;
                }
                this.insertRegion.add(base + ";");
            }
            this.insertRegion.add("\t\t\tbuf.append('}');");
            this.insertRegion.add("\t\t\treturn buf.toString();");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    boolean isBean() {
        return this.data != null;
    }

    GeneratableBean getData() {
        return this.data;
    }

    BeanGenConfig getConfig() {
        return this.config;
    }

    String getFieldPrefix() {
        return this.config.getPrefix();
    }

    private List<PropertyGen> nonDerivedProperties() {
        ArrayList<PropertyGen> nonDerived = new ArrayList<PropertyGen>();
        for (PropertyGen prop : this.properties) {
            if (prop.getData().isDerived()) continue;
            nonDerived.add(prop);
        }
        return nonDerived;
    }

    static {
        PRIMITIVE_EQUALS.add("boolean");
        PRIMITIVE_EQUALS.add("char");
        PRIMITIVE_EQUALS.add("byte");
        PRIMITIVE_EQUALS.add("short");
        PRIMITIVE_EQUALS.add("int");
        PRIMITIVE_EQUALS.add("long");
    }
}

