/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.GeneratableProperty;

abstract class CopyGen {
    static final CopyGen ASSIGN = new PatternCopyGen("$field = $value;");
    static final CopyGen CLONE = new PatternCopyGen("$value.clone()");
    static final CopyGen CLONE_CAST = new PatternCopyGen("($type) $value.clone()");

    CopyGen() {
    }

    abstract List<String> generateCopyToImmutable(String var1, GeneratableProperty var2);

    abstract List<String> generateCopyToMutable(String var1, GeneratableProperty var2, String var3);

    static class NoCopyGen
    extends CopyGen {
        static final CopyGen INSTANCE = new NoCopyGen();

        NoCopyGen() {
        }

        @Override
        List<String> generateCopyToImmutable(String indent, GeneratableProperty prop) {
            return Collections.emptyList();
        }

        @Override
        List<String> generateCopyToMutable(String indent, GeneratableProperty prop, String beanToCopyFrom) {
            return Collections.emptyList();
        }
    }

    static class PatternCopyGen
    extends CopyGen {
        private final String immutablePattern;
        private final String mutablePattern;

        PatternCopyGen(String pattern) {
            this.immutablePattern = pattern;
            this.mutablePattern = pattern;
        }

        PatternCopyGen(String immutablePattern, String mutablePattern) {
            this.immutablePattern = immutablePattern;
            this.mutablePattern = mutablePattern;
        }

        @Override
        List<String> generateCopyToImmutable(String indent, GeneratableProperty prop) {
            String[] split;
            ArrayList<String> list = new ArrayList<String>();
            for (String line : split = this.immutablePattern.split("\n")) {
                if (split.length == 1) {
                    if (!line.startsWith("$field = ") && !line.endsWith(";")) {
                        line = prop.isNotNull() ? "$field = " + line + ";" : "$field = ($value != null ? " + line + " : null);";
                    }
                    if (!line.startsWith("$field = ")) {
                        line = "$field = " + line;
                    }
                }
                line = line.replace("$field", "this." + prop.getFieldName());
                line = line.replace("$value", prop.getPropertyName());
                line = line.replace("$type", prop.getFieldType());
                line = line.replace("$typeRaw", prop.getTypeRaw());
                line = line.replace("$generics", prop.getTypeGenerics());
                line = line.replace("<>", prop.getTypeGenerics());
                list.add(indent + line);
            }
            return list;
        }

        @Override
        List<String> generateCopyToMutable(String indent, GeneratableProperty prop, String beanToCopyFrom) {
            String[] split;
            ArrayList<String> list = new ArrayList<String>();
            for (String line : split = this.mutablePattern.split("\n")) {
                if (split.length == 1) {
                    if (!line.startsWith("$field = ") && !line.endsWith(";")) {
                        line = prop.isNotNull() ? "$field = " + line + ";" : "$field = ($value != null ? " + line + " : null);";
                    }
                    if (!line.startsWith("$field = ")) {
                        line = "$field = " + line;
                    }
                }
                line = line.replace("$field", "this." + prop.getFieldName());
                line = line.replace("$value", beanToCopyFrom + "." + prop.getGetterGen().generateGetInvoke(prop));
                line = line.replace("$type", prop.getFieldType());
                line = line.replace("$typeRaw", prop.getTypeRaw());
                line = line.replace("$generics", prop.getTypeGenerics());
                line = line.replace("<>", prop.getTypeGenerics());
                list.add(indent + line);
            }
            return list;
        }
    }
}

