/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.beans.PropertyStyle;
import org.joda.beans.gen.BeanGenConfig;
import org.joda.beans.gen.BuilderGen;
import org.joda.beans.gen.CopyGen;
import org.joda.beans.gen.GeneratableBean;
import org.joda.beans.gen.GetterGen;
import org.joda.beans.gen.SetterGen;

class GeneratableProperty {
    private static final Set<String> COLLECTIONS = new HashSet<String>(Arrays.asList("Collection", "Set", "SortedSet", "NavigableSet", "List", "ArrayList", "LinkedList", "HashSet", "LinkedHashSet", "TreeSet", "ConcurrentSkipListSet", "ImmutableCollection", "ImmutableList", "ImmutableSet", "ImmutableSortedSet"));
    private static final Set<String> MAPS = new HashSet<String>(Arrays.asList("Map", "SortedMap", "NavigableMap", "ConcurrentMap", "ConcurrentNavigableMap", "HashMap", "LinkedHashMap", "TreeMap", "ConcurrentHashMap", "ConcurrentSkipListMap", "BiMap", "HashBiMap", "ImmutableMap", "ImmutableSortedMap", "ImmutableBiMap"));
    private final GeneratableBean bean;
    private String propertyName;
    private String fieldName;
    private String upperName;
    private String type;
    private String fieldType;
    private boolean isFinal;
    private String getStyle;
    private String setStyle;
    private String typeStyle;
    private String validation;
    private boolean deprecated;
    private String firstComment;
    private final List<String> comments = new ArrayList<String>();
    private GetterGen getterGen;
    private SetterGen setterGen;
    private CopyGen copyGen;
    private BuilderGen builderGen;
    private BeanGenConfig config;

    GeneratableProperty(GeneratableBean bean, BeanGenConfig config) {
        this.bean = bean;
        this.config = config;
    }

    public GeneratableBean getBean() {
        return this.bean;
    }

    public BeanGenConfig getConfig() {
        return this.config;
    }

    public void setConfig(BeanGenConfig config) {
        this.config = config;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getUpperName() {
        return this.upperName;
    }

    public void setUpperName(String upperName) {
        this.upperName = upperName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void resolveType() {
        String fieldType;
        if (this.getTypeStyle() == null) {
            this.setTypeStyle("");
        }
        String rawType = fieldType = this.getFieldType();
        String generics = "";
        if (rawType.contains("<")) {
            rawType = rawType.substring(0, fieldType.indexOf(60));
            generics = fieldType.substring(fieldType.indexOf(60));
        }
        if (this.getTypeStyle().equals("smart")) {
            this.setType(fieldType);
        } else if (this.getTypeStyle().length() > 0) {
            if (this.getTypeStyle().contains("<>")) {
                this.setType(this.getTypeStyle().replace("<>", generics));
            } else {
                this.setType(this.getTypeStyle() + generics);
            }
        } else {
            this.setType(fieldType);
        }
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getGetStyle() {
        return this.getStyle;
    }

    public void setGetStyle(String getStyle) {
        this.getStyle = getStyle;
    }

    public String getTypeStyle() {
        return this.typeStyle;
    }

    public void setTypeStyle(String typeStyle) {
        this.typeStyle = typeStyle;
    }

    public String getSetStyle() {
        return this.setStyle;
    }

    public void setSetStyle(String setStyle) {
        this.setStyle = setStyle;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getFirstComment() {
        return this.firstComment;
    }

    public void setFirstComment(String firstComment) {
        this.firstComment = firstComment;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public boolean isGenericParamType() {
        return this.type.indexOf("<") >= 0;
    }

    public boolean isGenericWildcardParamType() {
        return this.type.endsWith("<?>");
    }

    public String getGenericParamType() {
        int pos = this.type.indexOf("<");
        if (pos < 0) {
            return "";
        }
        return this.type.substring(pos + 1, this.type.length() - 1);
    }

    public String getRawType() {
        int pos = this.type.indexOf("<");
        return pos < 0 ? this.type : this.type.substring(0, pos);
    }

    public boolean isBeanGenericType() {
        String stripped = this.type;
        if (this.isArrayType()) {
            stripped = this.type.substring(0, this.type.length() - 2);
        }
        return stripped.equals(this.bean.getTypeGenericName(false));
    }

    public boolean isGeneric() {
        return this.isGenericParamType() || this.isBeanGenericType();
    }

    public boolean isDerived() {
        return this.fieldName == null;
    }

    public void resolveGetterGen() {
        if (this.getGetStyle() == null) {
            this.setGetStyle("");
        }
        String style = this.getGetStyle();
        String access = "public";
        if (style.equals("private")) {
            style = "smart";
            access = "private";
        }
        if (style.equals("get")) {
            this.getterGen = GetterGen.GetGetterGen.PUBLIC;
        } else if (style.equals("is")) {
            this.getterGen = GetterGen.IsGetterGen.PUBLIC;
        } else if (style.equals("smart")) {
            String clone = this.config.getImmutableGetClones().get(this.getFieldTypeRaw());
            this.getterGen = "clone".equals(clone) ? GetterGen.CloneGetterGen.of(access) : ("cloneCast".equals(clone) ? GetterGen.CloneCastGetterGen.of(access) : (this.getType().equals("boolean") ? GetterGen.IsGetterGen.of(access) : GetterGen.GetGetterGen.of(access)));
        } else if (style.equals("")) {
            this.getterGen = GetterGen.NoGetterGen.INSTANCE;
        } else if (style.equals("clone")) {
            this.getterGen = GetterGen.CloneGetterGen.PUBLIC;
        } else if (style.equals("cloneCast")) {
            this.getterGen = GetterGen.CloneCastGetterGen.PUBLIC;
        } else if (style.equals("manual")) {
            this.getterGen = GetterGen.ManualGetterGen.INSTANCE;
        } else {
            throw new RuntimeException("Unable to locate setter generator '" + style + "'" + " in " + this.getBean().getTypeRaw() + "." + this.getPropertyName());
        }
    }

    public GetterGen getGetterGen() {
        return this.getterGen;
    }

    public void resolveSetterGen() {
        if (this.getSetStyle() == null) {
            this.setSetStyle("");
        }
        String style = this.getSetStyle().replace("\\n", "\n");
        String access = "public";
        if (style.equals("private")) {
            style = "smart";
            access = "private";
        }
        if (style.equals("set")) {
            this.setterGen = SetterGen.SetSetterGen.PUBLIC;
        } else if (style.equals("setClearAddAll")) {
            this.setterGen = new SetterGen.PatternSetterGen("$field.clear();\n$field.addAll($value);");
        } else if (style.equals("setClearPutAll")) {
            this.setterGen = new SetterGen.PatternSetterGen("$field.clear();\n$field.putAll($value);");
        } else if (style.equals("smart")) {
            this.setterGen = this.isDerived() ? SetterGen.NoSetterGen.INSTANCE : (this.isFinal() ? (this.isCollectionType() ? new SetterGen.PatternSetterGen("$field.clear();\n$field.addAll($value);", access) : (this.isMapType() ? new SetterGen.PatternSetterGen("$field.clear();\n$field.putAll($value);", access) : SetterGen.NoSetterGen.INSTANCE)) : SetterGen.SetSetterGen.of(access));
        } else if (style.equals("")) {
            this.setterGen = SetterGen.NoSetterGen.INSTANCE;
        } else if (style.equals("manual")) {
            this.setterGen = SetterGen.NoSetterGen.INSTANCE;
        } else if (style.contains("$field") || style.contains("$value")) {
            this.setterGen = style.contains("$field") || style.contains("\n") ? new SetterGen.PatternSetterGen(style) : new SetterGen.PatternSetterGen("$field = " + style);
        } else {
            throw new RuntimeException("Unable to locate setter generator '" + style + "'" + " in " + this.getBean().getTypeRaw() + "." + this.getPropertyName());
        }
    }

    public SetterGen getSetterGen() {
        return this.setterGen;
    }

    public String getSetterScope() {
        if (this.getSetStyle().equals("private")) {
            return "private";
        }
        return "public";
    }

    public void resolveCopyGen() {
        String clone;
        CopyGen copier;
        if (this.getBean().isMutable()) {
            return;
        }
        if (this.config.getInvalidImmutableTypes().contains(this.getFieldTypeRaw())) {
            throw new RuntimeException("Invalid collection type for immutable bean: " + this.getFieldTypeRaw() + " in " + this.getBean().getTypeRaw() + "." + this.getPropertyName());
        }
        this.copyGen = this.isDerived() ? CopyGen.NoCopyGen.INSTANCE : ((copier = this.config.getCopyGenerators().get(this.getFieldTypeRaw())) != null ? copier : ((clone = this.config.getImmutableGetClones().get(this.getFieldTypeRaw())) != null ? (clone.equals("clone") ? CopyGen.CLONE : CopyGen.CLONE_CAST) : CopyGen.ASSIGN));
    }

    public CopyGen getCopyGen() {
        return this.copyGen;
    }

    public void resolveBuilderGen() {
        BuilderGen builder;
        if (this.getBean().isMutable()) {
            return;
        }
        this.builderGen = this.isDerived() ? BuilderGen.NoBuilderGen.INSTANCE : ((builder = this.config.getBuilderGenerators().get(this.getFieldTypeRaw())) != null ? builder : new BuilderGen.SimpleBuilderGen(this.getFieldType()));
    }

    public BuilderGen getBuilderGen() {
        return this.builderGen;
    }

    public boolean isArrayType() {
        return this.getType().endsWith("[]");
    }

    public boolean isGenericArrayType() {
        return this.getType().endsWith("[]") && this.getType().length() == 3;
    }

    public boolean isCollectionType() {
        return this.isGeneric() && COLLECTIONS.contains(this.getRawType());
    }

    public boolean isMapType() {
        return "FlexiBean".equals(this.getType()) || this.isGeneric() && MAPS.contains(this.getRawType());
    }

    public PropertyStyle getStyle() {
        if (this.isDerived()) {
            return PropertyStyle.DERIVED;
        }
        if (this.getBean().isImmutable()) {
            return PropertyStyle.IMMUTABLE;
        }
        if (this.getGetStyle().length() > 0 && this.getSetStyle().length() > 0 && (this.getSetterGen().isSetterGenerated(this) || this.getSetStyle().equals("manual"))) {
            return PropertyStyle.READ_WRITE;
        }
        if (this.getGetStyle().length() > 0) {
            return PropertyStyle.READ_ONLY;
        }
        if (this.getSetStyle().length() > 0) {
            return PropertyStyle.WRITE_ONLY;
        }
        throw new RuntimeException("Property must have a getter or setter: " + this.getBean().getTypeRaw() + "." + this.getPropertyName());
    }

    public boolean isValidated() {
        return this.getValidation() != null && this.getValidation().length() > 0;
    }

    public boolean isNotNull() {
        return this.getValidation().equals("notNull") || this.getValidation().equals("notEmpty");
    }

    public String getNotNullJavadoc() {
        if (this.getValidation().equals("notNull")) {
            return ", not null";
        }
        if (this.getValidation().equals("notEmpty")) {
            return ", not empty";
        }
        return "";
    }

    public String getValidationMethodName() {
        if (!this.isValidated()) {
            throw new IllegalStateException();
        }
        if (this.getValidation().equals("notNull") || this.getValidation().equals("notEmpty")) {
            return "JodaBeanUtils." + this.getValidation();
        }
        return this.getValidation();
    }

    public String getTypeRaw() {
        String type = this.getType();
        if (type.contains("<")) {
            return type.substring(0, type.indexOf(60));
        }
        return type;
    }

    public String getFieldTypeRaw() {
        String type = this.getFieldType();
        if (type.contains("<")) {
            return type.substring(0, type.indexOf(60));
        }
        return type;
    }

    public String getTypeGenerics() {
        String type = this.getType();
        if (type.contains("<")) {
            return type.substring(type.indexOf(60));
        }
        return "";
    }
}

