/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.xml;

import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerIterator;
import org.joda.convert.StringConverter;

public class JodaBeanXmlWriter {
    private final JodaBeanSer settings;
    private final StringBuilder builder;
    private Bean rootBean;
    private String basePackage;
    private Map<Class<?>, String> knownTypes = new HashMap();

    public JodaBeanXmlWriter(JodaBeanSer settings) {
        this(settings, new StringBuilder(1024));
    }

    public JodaBeanXmlWriter(JodaBeanSer settings, StringBuilder builder) {
        this.settings = settings;
        this.builder = builder;
    }

    public String write(Bean bean) {
        return this.write(bean, true);
    }

    public String write(Bean bean, boolean rootType) {
        return this.writeToBuilder(bean, rootType).toString();
    }

    public StringBuilder writeToBuilder(Bean bean) {
        return this.writeToBuilder(bean, true);
    }

    public StringBuilder writeToBuilder(Bean bean, boolean rootType) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.rootBean = bean;
        this.basePackage = rootType ? bean.getClass().getPackage().getName() + "." : null;
        String type = this.rootBean.getClass().getName();
        this.writeHeader();
        this.builder.append('<').append("bean");
        if (rootType) {
            this.appendAttribute(this.builder, "type", type);
        }
        this.builder.append('>').append(this.settings.getNewLine());
        this.writeBean(this.rootBean, this.settings.getIndent());
        this.builder.append('<').append('/').append("bean").append('>').append(this.settings.getNewLine());
        return this.builder;
    }

    private void writeHeader() {
        this.builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(this.settings.getNewLine());
    }

    private boolean writeBean(Bean bean, String currentIndent) {
        boolean output = false;
        for (MetaProperty<?> prop : bean.metaBean().metaPropertyIterable()) {
            if (!prop.style().isSerializable()) continue;
            output = true;
            Object value = prop.get(bean);
            if (value == null) continue;
            String propName = prop.name();
            Class<?> propType = prop.propertyType();
            if (value instanceof Bean) {
                if (this.settings.getConverter().isConvertible(value.getClass())) {
                    this.writeSimple(currentIndent, propName, new StringBuilder(), propType, value);
                    continue;
                }
                this.writeBean(currentIndent, propName, new StringBuilder(), propType, (Bean)value);
                continue;
            }
            SerIterator itemIterator = this.settings.getIteratorFactory().create(value, prop, bean.getClass());
            if (itemIterator != null) {
                this.writeElements(currentIndent, propName, new StringBuilder(), itemIterator);
                continue;
            }
            this.writeSimple(currentIndent, propName, new StringBuilder(), propType, value);
        }
        return output;
    }

    private void writeBean(String currentIndent, String tagName, StringBuilder attrs, Class<?> propType, Bean value) {
        if (value == null) {
            throw new IllegalArgumentException("Bean cannot be null");
        }
        this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs);
        if (value.getClass() != propType) {
            String typeStr = this.settings.encodeClass(value.getClass(), this.basePackage, this.knownTypes);
            this.appendAttribute(this.builder, "type", typeStr);
        }
        this.builder.append('>').append(this.settings.getNewLine());
        if (this.writeBean(value, currentIndent + this.settings.getIndent())) {
            this.builder.append(currentIndent).append('<').append('/').append(tagName).append('>').append(this.settings.getNewLine());
        } else {
            this.builder.insert(this.builder.length() - 2, '/');
        }
    }

    private void writeElements(String currentIndent, String tagName, StringBuilder attrs, SerIterator itemIterator) {
        if (itemIterator.size() == 0) {
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append('/').append('>').append(this.settings.getNewLine());
        } else {
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append('>').append(this.settings.getNewLine());
            this.writeElements(currentIndent + this.settings.getIndent(), itemIterator);
            this.builder.append(currentIndent).append('<').append('/').append(tagName).append('>').append(this.settings.getNewLine());
        }
    }

    private void writeElements(String currentIndent, SerIterator itemIterator) {
        StringConverter converter = null;
        boolean keyBean = false;
        if (itemIterator.keyType() != null) {
            if (this.settings.getConverter().isConvertible(itemIterator.keyType())) {
                converter = this.settings.getConverter().findConverterNoGenerics(itemIterator.keyType());
            } else if (Bean.class.isAssignableFrom(itemIterator.keyType())) {
                keyBean = true;
            } else {
                throw new IllegalArgumentException("Unable to write map as declared key type is neither a bean nor a simple type: " + itemIterator.keyType().getName());
            }
        }
        while (itemIterator.hasNext()) {
            itemIterator.next();
            StringBuilder attr = new StringBuilder(32);
            if (converter != null) {
                String keyStr = this.encodeAttribute(converter.convertToString(itemIterator.key()));
                if (keyStr == null) {
                    throw new IllegalArgumentException("Unable to embed map key as it cannot be a null string: " + itemIterator.key());
                }
                this.appendAttribute(attr, "key", keyStr);
            }
            if (itemIterator.count() != 1) {
                this.appendAttribute(attr, "count", Integer.toString(itemIterator.count()));
            }
            if (keyBean) {
                this.builder.append(currentIndent).append('<').append("entry").append((CharSequence)attr).append('>').append(this.settings.getNewLine());
                this.writeKeyValueElement(currentIndent + this.settings.getIndent(), itemIterator);
                this.builder.append(currentIndent).append('<').append('/').append("entry").append('>').append(this.settings.getNewLine());
                continue;
            }
            String tagName = itemIterator.isMapLike() ? "entry" : "item";
            this.writeValueElement(currentIndent, tagName, attr, itemIterator);
        }
    }

    private void writeKeyValueElement(String currentIndent, SerIterator itemIterator) {
        Object key = itemIterator.key();
        this.writeBean(currentIndent, "item", new StringBuilder(), itemIterator.keyType(), (Bean)key);
        this.writeValueElement(currentIndent, "item", new StringBuilder(), itemIterator);
    }

    private void writeValueElement(String currentIndent, String tagName, StringBuilder attrs, SerIterator itemIterator) {
        Object value = itemIterator.value();
        Class<?> valueType = itemIterator.valueType();
        if (value == null) {
            this.appendAttribute(attrs, "null", "true");
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append("/>").append(this.settings.getNewLine());
        } else if (value instanceof Bean) {
            if (this.settings.getConverter().isConvertible(value.getClass())) {
                this.writeSimple(currentIndent, tagName, attrs, valueType, value);
            } else {
                this.writeBean(currentIndent, tagName, attrs, valueType, (Bean)value);
            }
        } else {
            SerIterator childIterator = this.settings.getIteratorFactory().create(value, itemIterator.valueTypeTypes());
            if (childIterator != null) {
                if (itemIterator.valueTypeTypes().size() == 0) {
                    this.appendAttribute(attrs, "metatype", childIterator.metaTypeName());
                }
                this.writeElements(currentIndent, tagName, attrs, childIterator);
            } else {
                this.writeSimple(currentIndent, tagName, attrs, valueType, value);
            }
        }
    }

    private void writeSimple(String currentIndent, String tagName, StringBuilder attrs, Class<?> declaredType, Object value) {
        String typeStr;
        Class<?> type = declaredType;
        if (type == Object.class) {
            type = value.getClass();
            if (type != String.class) {
                typeStr = this.settings.encodeClass(type, this.basePackage, this.knownTypes);
                this.appendAttribute(attrs, "type", typeStr);
            }
        } else if (!this.settings.getConverter().isConvertible(type)) {
            type = value.getClass();
            typeStr = this.settings.encodeClass(type, this.basePackage, this.knownTypes);
            this.appendAttribute(attrs, "type", typeStr);
        }
        try {
            String converted = this.settings.getConverter().convertToString(type, value);
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append('>');
            this.appendEncoded(converted);
            this.builder.append('<').append('/').append(tagName).append('>').append(this.settings.getNewLine());
        }
        catch (IllegalStateException ex) {
            throw new IllegalArgumentException("Unable to convert type " + type.getName() + " declared as " + declaredType.getName(), ex);
        }
    }

    private StringBuilder appendEncoded(String text) {
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    this.builder.append("&amp;");
                    continue block6;
                }
                case '<': {
                    this.builder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    this.builder.append("&gt;");
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    this.builder.append(ch);
                    continue block6;
                }
                default: {
                    if (ch < ' ') {
                        throw new IllegalArgumentException("Invalid character for XML: " + ch);
                    }
                    this.builder.append(ch);
                }
            }
        }
        return this.builder;
    }

    private StringBuilder appendAttribute(StringBuilder buf, String attrName, String encodedValue) {
        return buf.append(' ').append(attrName).append('=').append('\"').append(encodedValue).append('\"');
    }

    private String encodeAttribute(String text) {
        return this.appendEncodedAttribute(new StringBuilder(text.length() + 16), text).toString();
    }

    private StringBuilder appendEncodedAttribute(StringBuilder builder, String text) {
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    builder.append("&amp;");
                    continue block10;
                }
                case '<': {
                    builder.append("&lt;");
                    continue block10;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    builder.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    builder.append("&apos;");
                    continue block10;
                }
                case '\t': {
                    builder.append("&#09;");
                    continue block10;
                }
                case '\n': {
                    builder.append("&#0A;");
                    continue block10;
                }
                case '\r': {
                    builder.append("&#0D;");
                    continue block10;
                }
                default: {
                    if (ch < ' ') {
                        throw new IllegalArgumentException("Invalid character for XML: " + ch);
                    }
                    builder.append(ch);
                }
            }
        }
        return builder;
    }
}

