/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.GeneratableProperty;

abstract class GetterGen {
    GetterGen() {
    }

    abstract List<String> generateGetter(GeneratableProperty var1);

    String generateGetInvoke(GeneratableProperty prop) {
        return "get" + prop.getUpperName() + "()";
    }

    private static List<String> doGenerateGetter(GeneratableProperty prop, String access, String prefix, String expression) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t/**");
        list.add("\t * Gets " + prop.getFirstComment());
        for (String comment : prop.getComments()) {
            list.add("\t * " + comment);
        }
        list.add("\t * @return the value of the property" + prop.getNotNullJavadoc());
        list.add("\t */");
        if (prop.isDeprecated()) {
            list.add("\t@Deprecated");
        }
        list.add("\t" + access + " " + prop.getType() + " " + prefix + prop.getUpperName() + "() {");
        list.add("\t\treturn " + expression + ";");
        list.add("\t}");
        list.add("");
        return list;
    }

    static class NoGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new NoGetterGen();

        NoGetterGen() {
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return Collections.emptyList();
        }

        @Override
        String generateGetInvoke(GeneratableProperty prop) {
            return prop.getFieldName();
        }
    }

    static class ManualGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new ManualGetterGen();

        ManualGetterGen() {
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return Collections.emptyList();
        }
    }

    static final class CloneCastGetterGen
    extends GetterGen {
        static final CloneCastGetterGen PUBLIC = new CloneCastGetterGen("public");
        static final CloneCastGetterGen PRIVATE = new CloneCastGetterGen("private");
        private final String access;

        static CloneCastGetterGen of(String access) {
            return access.equals("private") ? PRIVATE : PUBLIC;
        }

        private CloneCastGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", "(" + prop.getFieldName() + " != null ? (" + prop.getFieldType() + ") " + prop.getFieldName() + ".clone() : null)");
        }
    }

    static final class CloneGetterGen
    extends GetterGen {
        static final CloneGetterGen PUBLIC = new CloneGetterGen("public");
        static final CloneGetterGen PRIVATE = new CloneGetterGen("private");
        private final String access;

        static CloneGetterGen of(String access) {
            return access.equals("private") ? PRIVATE : PUBLIC;
        }

        private CloneGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", "(" + prop.getFieldName() + " != null ? " + prop.getFieldName() + ".clone() : null)");
        }
    }

    static final class IsGetterGen
    extends GetterGen {
        static final IsGetterGen PUBLIC = new IsGetterGen("public");
        static final IsGetterGen PRIVATE = new IsGetterGen("private");
        private final String access;

        static IsGetterGen of(String access) {
            return access.equals("private") ? PRIVATE : PUBLIC;
        }

        private IsGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "is", prop.getFieldName());
        }

        @Override
        String generateGetInvoke(GeneratableProperty prop) {
            return "is" + prop.getUpperName() + "()";
        }
    }

    static final class GetGetterGen
    extends GetterGen {
        static final GetGetterGen PUBLIC = new GetGetterGen("public");
        static final GetGetterGen PRIVATE = new GetGetterGen("private");
        private final String access;

        static GetGetterGen of(String access) {
            return access.equals("private") ? PRIVATE : PUBLIC;
        }

        private GetGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(GeneratableProperty prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", prop.getFieldName());
        }
    }
}

