/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.gen.BeanGen;
import org.joda.beans.gen.GeneratableProperty;
import org.joda.beans.impl.direct.DirectMetaProperty;

class PropertyGen {
    private static final Pattern GETTER_PATTERN = Pattern.compile(".*[ ,(]get[ ]*[=][ ]*[\"]([a-zA-Z-]*)[\"].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile(".*[ ,(]set[ ]*[=][ ]*[\"]([ !#-~]*)[\"].*");
    private static final Pattern TYPE_PATTERN = Pattern.compile(".*[ ,(]type[ ]*[=][ ]*[\"]([a-zA-Z0-9_<>.]*)[\"].*");
    private static final Pattern VALIDATION_PATTERN = Pattern.compile(".*[ ,(]validate[ ]*[=][ ]*[\"]([a-zA-Z_.]*)[\"].*");
    private final int propertyIndex;
    private final int annotationIndex;
    private final int fieldIndex;
    private final BeanGen bean;
    private final GeneratableProperty data;

    public PropertyGen(BeanGen bean, List<String> content, int lineIndex, boolean derived) {
        this.bean = bean;
        this.propertyIndex = lineIndex;
        this.annotationIndex = this.parseAnnotationStart(content, lineIndex);
        this.fieldIndex = this.parseCodeIndex(content);
        GeneratableProperty prop = new GeneratableProperty(bean.getData(), bean.getConfig());
        if (derived) {
            prop.setGetStyle("manual");
            prop.setSetStyle("");
            prop.setTypeStyle("");
            prop.setDeprecated(this.parseDeprecated(content));
            prop.setPropertyName(this.parseMethodNameAsPropertyName(content));
            prop.setUpperName(this.makeUpperName(prop.getPropertyName()));
            prop.setFieldType(this.parseMethodType(content));
            prop.setInitializer(this.parseFieldInitializer(content));
        } else {
            prop.setGetStyle(this.parseGetStyle(content));
            prop.setSetStyle(this.parseSetStyle(content));
            prop.setTypeStyle(this.parseTypeStyle(content));
            prop.setValidation(this.parseValidation(content));
            prop.setDeprecated(this.parseDeprecated(content));
            prop.setFieldName(this.parseFieldName(content));
            prop.setPropertyName(this.makePropertyName(bean, prop.getFieldName()));
            prop.setUpperName(this.makeUpperName(prop.getPropertyName()));
            prop.setFinal(this.parseFinal(content));
            prop.setFieldType(this.parseFieldType(content));
            prop.setInitializer(this.parseFieldInitializer(content));
        }
        prop.resolveType();
        prop.resolveGetterGen();
        prop.resolveSetterGen();
        prop.resolveCopyGen();
        prop.resolveBuilderGen();
        prop.resolveValidation();
        List<String> comments = this.parseComment(content, prop.getPropertyName());
        prop.setFirstComment(comments.get(0));
        prop.getComments().addAll(comments.subList(1, comments.size()));
        this.data = prop;
    }

    private String makePropertyName(BeanGen bean, String name) {
        if (name.startsWith(bean.getFieldPrefix())) {
            name = name.substring(bean.getFieldPrefix().length());
        }
        return name;
    }

    private String makeUpperName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private int parseAnnotationStart(List<String> content, int lineIndex) {
        while (lineIndex > 0 && content.get(lineIndex - 1).trim().startsWith("@")) {
            --lineIndex;
        }
        return lineIndex;
    }

    private int parseCodeIndex(List<String> content) {
        for (int index = this.propertyIndex; index < content.size(); ++index) {
            if (content.get(index).trim().startsWith("@")) continue;
            if (content.get(index).trim().length() == 0) {
                throw new RuntimeException("Unable to locate field for property at line " + (this.propertyIndex + 1) + ", found blank line");
            }
            return index;
        }
        throw new RuntimeException("Unable to locate field for property at line " + (this.propertyIndex + 1));
    }

    private String parseGetStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = GETTER_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseSetStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = SETTER_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseTypeStyle(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = TYPE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseValidation(List<String> content) {
        String line = content.get(this.propertyIndex).trim();
        Matcher matcher = VALIDATION_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private boolean parseDeprecated(List<String> content) {
        for (int index = this.annotationIndex; index < this.fieldIndex; ++index) {
            String line = content.get(index).trim();
            if (!line.equals("@Deprecated") && !line.startsWith("@Deprecated ")) continue;
            return true;
        }
        return false;
    }

    private String parseFieldName(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        String last = parts[parts.length - 1];
        if (last.endsWith(";") && last.length() > 1) {
            return last.substring(0, last.length() - 1);
        }
        throw new RuntimeException("Unable to locate field name at line " + (this.propertyIndex + 1));
    }

    private boolean parseFinal(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            throw new RuntimeException("Unable to locate field type at line " + (this.propertyIndex + 1));
        }
        return parts[0].equals("final") || parts[1].equals("final") || parts.length >= 3 && parts[2].equals("final");
    }

    private String parseFieldType(List<String> content) {
        String line = this.parseFieldDefinition(content);
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            throw new RuntimeException("Unable to locate field type at line " + (this.propertyIndex + 1));
        }
        int partsPos = parts.length - 2;
        String type = parts[partsPos];
        while (true) {
            int open = 0;
            int openPos = 0;
            int close = 0;
            int closePos = 0;
            while ((openPos = type.indexOf(60, openPos)) >= 0) {
                ++open;
                ++openPos;
            }
            while ((closePos = type.indexOf(62, closePos)) >= 0) {
                ++close;
                ++closePos;
            }
            if (open == close) break;
            if (partsPos == 0) {
                throw new RuntimeException("Unable to locate field type at line " + (this.propertyIndex + 1) + ", mismatched generics");
            }
            type = parts[--partsPos] + " " + type;
        }
        return type;
    }

    private String parseFieldDefinition(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.contains("//")) {
            line = line.substring(0, line.indexOf("//")).trim();
        }
        if (line.contains(" = ")) {
            line = line.substring(0, line.indexOf(" = ")).trim() + ";";
        }
        return line;
    }

    private String parseFieldInitializer(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.contains("//")) {
            line = line.substring(0, line.indexOf("//")).trim();
        }
        if (line.contains(" = ")) {
            if (!(line = line.substring(line.indexOf(" = ") + 3).trim()).endsWith(";")) {
                throw new RuntimeException("Field line does not end with semi-colon");
            }
            return line.substring(0, line.length() - 1).trim();
        }
        return "";
    }

    private String parseMethodNameAsPropertyName(List<String> content) {
        String[] parts = this.parseMethodDefinition(content);
        if (parts[1].length() == 0 || !Character.isUpperCase(parts[1].charAt(0))) {
            throw new RuntimeException("@DerivedProperty method name invalid'");
        }
        return Character.toLowerCase(parts[1].charAt(0)) + parts[1].substring(1);
    }

    private String parseMethodType(List<String> content) {
        String[] parts = this.parseMethodDefinition(content);
        return parts[0];
    }

    private String[] parseMethodDefinition(List<String> content) {
        String line = content.get(this.fieldIndex).trim();
        if (line.startsWith("public ")) {
            line = line.substring(7).trim();
        } else if (line.startsWith("private ")) {
            line = line.substring(8).trim();
        } else if (line.startsWith("protected ")) {
            line = line.substring(10).trim();
        }
        String lineEnd = "() {";
        if (line.startsWith("abstract ")) {
            line = line.substring(9).trim();
            lineEnd = "();";
        } else if (line.startsWith("final ")) {
            line = line.substring(6).trim();
        } else if (line.startsWith("static ")) {
            throw new RuntimeException("@DerivedProperty method cannot be static");
        }
        int getIndex = line.indexOf(" get");
        if (getIndex < 0) {
            throw new RuntimeException("@DerivedProperty method must start with 'get'");
        }
        if (!line.endsWith(lineEnd)) {
            throw new RuntimeException("@DerivedProperty method must end with '" + lineEnd + "'");
        }
        line = line.substring(0, line.length() - lineEnd.length());
        String[] split = new String[]{line.substring(0, getIndex).trim(), line.substring(getIndex + 4).trim()};
        return split;
    }

    private List<String> parseComment(List<String> content, String propertyName) {
        int endPos;
        int startPos;
        String comment;
        ArrayList<String> comments = new ArrayList<String>();
        String commentEnd = content.get(this.annotationIndex - 1).trim();
        if (commentEnd.equals("*/")) {
            int startCommentIndex = -1;
            for (int index = this.annotationIndex - 1; index >= 0; --index) {
                String line = content.get(index).trim();
                if (!line.equals("/**")) continue;
                startCommentIndex = index + 1;
                break;
            }
            if (startCommentIndex == -1) {
                throw new RuntimeException("Unable to locate comment start at line " + this.annotationIndex);
            }
            if (startCommentIndex < this.annotationIndex - 1) {
                for (int i = startCommentIndex; i < this.annotationIndex - 1; ++i) {
                    String commentLine = content.get(i).trim();
                    if (commentLine.startsWith("*")) {
                        commentLine = commentLine.substring(1).trim();
                    }
                    if (commentLine.startsWith("@return") || commentLine.startsWith("@param") || commentLine.startsWith("@throws") || commentLine.startsWith("@exception")) continue;
                    comments.add(commentLine);
                }
                String firstLine = (String)comments.get(0);
                if (firstLine.length() > 0) {
                    comments.set(0, firstLine.substring(0, 1).toLowerCase() + firstLine.substring(1));
                } else {
                    comments.remove(0);
                }
            }
        } else if (commentEnd.startsWith("/**") && commentEnd.endsWith("*/") && (comment = commentEnd.substring(startPos = commentEnd.indexOf("/**") + 3, endPos = commentEnd.lastIndexOf("*/")).trim()).length() > 0) {
            comments.add(comment.substring(0, 1).toLowerCase() + comment.substring(1));
        }
        if (comments.size() == 0) {
            comments.add("the " + propertyName + ".");
        }
        return comments;
    }

    List<String> generateConstructorAssign(String fromBean) {
        return this.data.getCopyGen().generateCopyToImmutable("\t\t", fromBean, this.data);
    }

    List<String> generateMetaPropertyConstant() {
        this.data.getBean().ensureImport(MetaProperty.class);
        this.data.getBean().ensureImport(DirectMetaProperty.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t/**");
        list.add("\t\t * The meta-property for the {@code " + this.data.getPropertyName() + "} property.");
        list.add("\t\t */");
        if (this.data.isBeanGenericType()) {
            list.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
            list.add("\t\tprivate final MetaProperty<" + this.propertyType() + "> " + this.metaFieldName() + " = (DirectMetaProperty) DirectMetaProperty.of" + this.readWrite() + "(");
            list.add("\t\t\t\tthis, \"" + this.data.getPropertyName() + "\", " + this.data.getBean().getTypeRaw() + ".class, " + this.actualType() + ");");
        } else {
            String propertyType = this.propertyType();
            if (propertyType.length() == 1) {
                propertyType = "Object";
            }
            if (this.data.isGenericParamType()) {
                list.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
            }
            list.add("\t\tprivate final MetaProperty<" + propertyType + "> " + this.metaFieldName() + " = DirectMetaProperty.of" + this.readWrite() + "(");
            list.add("\t\t\t\tthis, \"" + this.data.getPropertyName() + "\", " + this.data.getBean().getTypeRaw() + ".class, " + this.actualType() + ");");
        }
        return list;
    }

    List<String> generateMetaPropertyGetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        list.add("\t\t\t\t\treturn " + this.metaFieldName() + ";");
        return list;
    }

    List<String> generateGetter() {
        return this.data.getGetterGen().generateGetter(this.data);
    }

    List<String> generateSetter() {
        return this.data.getSetterGen().generateSetter("\t", this.data);
    }

    List<String> generateProperty() {
        this.data.getBean().ensureImport(Property.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t/**");
        list.add("\t * Gets the the {@code " + this.data.getPropertyName() + "} property.");
        for (String comment : this.data.getComments()) {
            list.add("\t * " + comment);
        }
        list.add("\t * @return the property, not null");
        list.add("\t */");
        if (this.data.isDeprecated()) {
            list.add("\t@Deprecated");
        }
        list.add("\tpublic " + (this.data.getBean().isTypeFinal() ? "" : "final ") + "Property<" + this.propertyType() + "> " + this.data.getPropertyName() + "() {");
        list.add("\t\treturn metaBean()." + this.data.getPropertyName() + "().createProperty(this);");
        list.add("\t}");
        list.add("");
        return list;
    }

    List<String> generateMetaProperty() {
        ArrayList<String> list = new ArrayList<String>();
        String propertyType = this.propertyType();
        list.add("\t\t/**");
        list.add("\t\t * The meta-property for the {@code " + this.data.getPropertyName() + "} property.");
        if (this.data.isDeprecated()) {
            for (String comment : this.data.getComments()) {
                if (!comment.contains("@deprecated")) continue;
                list.add("\t\t * " + comment);
            }
        }
        list.add("\t\t * @return the meta-property, not null");
        list.add("\t\t */");
        if (this.data.isDeprecated()) {
            list.add("\t\t@Deprecated");
        }
        list.add("\t\tpublic " + (this.data.getBean().isTypeFinal() ? "" : "final ") + "MetaProperty<" + propertyType + "> " + this.data.getPropertyName() + "() {");
        list.add("\t\t\treturn " + this.metaFieldName() + ";");
        list.add("\t\t}");
        list.add("");
        return list;
    }

    List<String> generatePropertyGetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        if (this.data.getStyle().isReadable()) {
            list.add("\t\t\t\t\treturn ((" + this.data.getBean().getTypeWildcard() + ") bean)." + this.data.getGetterGen().generateGetInvoke(this.data) + ";");
        } else {
            list.add("\t\t\t\t\tif (quiet) {");
            list.add("\t\t\t\t\t\treturn null;");
            list.add("\t\t\t\t\t}");
            list.add("\t\t\t\t\tthrow new UnsupportedOperationException(\"Property cannot be read: " + this.data.getPropertyName() + "\");");
        }
        return list;
    }

    List<String> generatePropertySetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        String setter = this.data.getSetterGen().generateSetInvoke(this.data);
        if (this.data.getStyle().isWritable() && setter != null) {
            list.add("\t\t\t\t\t((" + this.data.getBean().getTypeNoExtends() + ") bean)." + setter + "(" + this.castObject() + "newValue);");
            list.add("\t\t\t\t\treturn;");
        } else {
            list.add("\t\t\t\t\tif (quiet) {");
            list.add("\t\t\t\t\t\treturn;");
            list.add("\t\t\t\t\t}");
            list.add("\t\t\t\t\tthrow new UnsupportedOperationException(\"Property cannot be written: " + this.data.getPropertyName() + "\");");
        }
        return list;
    }

    List<String> generateBuilderField() {
        return this.data.getBuilderGen().generateField("\t\t", this.data);
    }

    List<String> generateBuilderConstructorAssign(String beanToCopyFrom) {
        return this.data.getCopyGen().generateCopyToMutable("\t\t\t", this.data, beanToCopyFrom);
    }

    List<String> generateBuilderFieldGet() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        list.add("\t\t\t\t\treturn " + this.generateBuilderFieldName() + ";");
        return list;
    }

    List<String> generateBuilderFieldSet() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        list.add("\t\t\t\t\tthis." + this.generateBuilderFieldName() + " = (" + this.propertyType(this.getBuilderType()) + ") newValue;");
        list.add("\t\t\t\t\tbreak;");
        return list;
    }

    String generateBuilderFieldName() {
        return this.data.getFieldName();
    }

    List<String> generateBuilderSetMethod() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t/**");
        list.add("\t\t * Sets the {@code " + this.data.getPropertyName() + "} property in the builder.");
        list.add("\t\t * @param " + this.data.getPropertyName() + "  the new value" + this.data.getNotNullJavadoc());
        list.add("\t\t * @return this, for chaining, not null");
        if (this.data.isDeprecated()) {
            for (String comment : this.data.getComments()) {
                if (!comment.contains("@deprecated")) continue;
                list.add("\t\t * " + comment);
            }
        }
        list.add("\t\t */");
        if (this.data.isDeprecated()) {
            list.add("\t\t@Deprecated");
        }
        list.add("\t\tpublic Builder" + this.data.getBean().getTypeGenericName(true) + " " + this.data.getPropertyName() + "(" + this.getBuilderType() + " " + this.data.getPropertyName() + ") {");
        if (this.data.isValidated()) {
            list.add("\t\t\t" + this.data.getValidationMethodName() + "(" + this.data.getPropertyName() + ", \"" + this.data.getPropertyName() + "\");");
        }
        list.add("\t\t\tthis." + this.generateBuilderFieldName() + " = " + this.data.getPropertyName() + ";");
        list.add("\t\t\treturn this;");
        list.add("\t\t}");
        list.add("");
        return list;
    }

    String getBuilderType() {
        return this.data.getBuilderGen().generateType(this.data);
    }

    private String readWrite() {
        switch (this.data.getStyle()) {
            case READ_WRITE: {
                return "ReadWrite";
            }
            case READ_ONLY: {
                return "ReadOnly";
            }
            case WRITE_ONLY: {
                return "WriteOnly";
            }
            case DERIVED: {
                return "Derived";
            }
            case READ_ONLY_BUILDABLE: {
                return "ReadOnlyBuildable";
            }
            case IMMUTABLE: {
                return "Immutable";
            }
        }
        throw new RuntimeException("Invalid style");
    }

    private String actualType() {
        String pt = this.propertyType();
        if (pt.equals(this.data.getType())) {
            int genericStart = pt.indexOf(60);
            if (genericStart >= 0) {
                return "(Class) " + pt.substring(0, genericStart) + ".class";
            }
            if (this.data.getType().length() == 1) {
                return "Object.class";
            }
            if (this.data.isGenericArrayType()) {
                return "Object[].class";
            }
            return pt + ".class";
        }
        return pt + ".TYPE";
    }

    private String castObject() {
        String pt = this.propertyType();
        if (pt.equals(this.data.getType())) {
            return "(" + pt + ") ";
        }
        return "(" + pt + ") ";
    }

    private String propertyType() {
        return this.propertyType(this.data.getType());
    }

    private String propertyType(String type) {
        if (type.equals("boolean")) {
            return "Boolean";
        }
        if (type.equals("byte")) {
            return "Byte";
        }
        if (type.equals("short")) {
            return "Short";
        }
        if (type.equals("char")) {
            return "Character";
        }
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("long")) {
            return "Long";
        }
        if (type.equals("float")) {
            return "Float";
        }
        if (type.equals("double")) {
            return "Double";
        }
        return type;
    }

    private String metaFieldName() {
        return this.bean.getFieldPrefix() + this.data.getPropertyName();
    }

    GeneratableProperty getData() {
        return this.data;
    }
}

