/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.GuavaSerIteratorFactory;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIterator;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.ImmutableCell;
import org.joda.collect.grid.ImmutableGrid;

public class CollectSerIteratorFactory
extends GuavaSerIteratorFactory {
    @Override
    public SerIterator create(Object value, List<Class<?>> types) {
        if (value instanceof Grid) {
            if (types.size() == 1) {
                return CollectSerIteratorFactory.grid((Grid)value, types.get(0), EMPTY_VALUE_TYPES);
            }
            return CollectSerIteratorFactory.grid((Grid)value, Object.class, EMPTY_VALUE_TYPES);
        }
        return super.create(value, types);
    }

    @Override
    public SerIterator create(Object value, MetaProperty<?> prop, Class<?> beanClass) {
        if (value instanceof Grid) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return CollectSerIteratorFactory.grid((Grid)value, valueType, valueTypeTypes);
        }
        return super.create(value, prop, beanClass);
    }

    @Override
    public SerIterable createIterable(String metaTypeDescription, JodaBeanSer settings, Map<String, Class<?>> knownTypes) {
        if (metaTypeDescription.equals("Grid")) {
            return CollectSerIteratorFactory.grid(Object.class, EMPTY_VALUE_TYPES);
        }
        return super.createIterable(metaTypeDescription, settings, knownTypes);
    }

    @Override
    public SerIterable createIterable(MetaProperty<?> prop, Class<?> beanClass) {
        if (Grid.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return CollectSerIteratorFactory.grid(valueType, valueTypeTypes);
        }
        return super.createIterable(prop, beanClass);
    }

    public static final SerIterable grid(final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterable(){
            private final List<Grid.Cell<?>> cells = new ArrayList();
            private int[] dimensions;

            @Override
            public SerIterator iterator() {
                return CollectSerIteratorFactory.grid(this.build(), valueType, valueTypeTypes);
            }

            @Override
            public void dimensions(int[] dimensions) {
                this.dimensions = dimensions;
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (value != null) {
                    this.cells.add((Grid.Cell<?>)ImmutableCell.of((int)((Integer)key), (int)((Integer)column), (Object)value));
                }
            }

            public Grid<?> build() {
                if (this.dimensions == null || this.dimensions.length != 2) {
                    throw new IllegalArgumentException("Expected 2 dimensions, rowCount and columnCount");
                }
                return ImmutableGrid.copyOf((int)this.dimensions[0], (int)this.dimensions[1], this.cells);
            }

            @Override
            public SerCategory category() {
                return SerCategory.GRID;
            }

            @Override
            public Class<?> keyType() {
                return Integer.class;
            }

            @Override
            public Class<?> columnType() {
                return Integer.class;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterator grid(final Grid<?> grid, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Grid.Cell current;
            {
                this.it = grid.cells().iterator();
            }

            @Override
            public String metaTypeName() {
                return "Grid";
            }

            @Override
            public SerCategory category() {
                return SerCategory.GRID;
            }

            @Override
            public int dimensionSize(int dimension) {
                return dimension == 0 ? grid.rowCount() : grid.columnCount();
            }

            @Override
            public int size() {
                return grid.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Grid.Cell)this.it.next();
            }

            @Override
            public Class<?> keyType() {
                return Integer.class;
            }

            @Override
            public Object key() {
                return this.current.getRow();
            }

            @Override
            public Class<?> columnType() {
                return Integer.class;
            }

            @Override
            public Object column() {
                return this.current.getColumn();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public Object value() {
                return this.current.getValue();
            }

            @Override
            public Object value(int row, int column) {
                return grid.get(row, column);
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }
}

