/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.beans.ser.DefaultDeserializer;
import org.joda.beans.ser.SerDeserializer;

public final class SerDeserializers {
    public static final SerDeserializers INSTANCE = new SerDeserializers();
    private ConcurrentMap<Class<?>, SerDeserializer> deserializers = new ConcurrentHashMap();

    public SerDeserializers register(Class<?> type, SerDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
        return this;
    }

    public ConcurrentMap<Class<?>, SerDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public SerDeserializer findDeserializer(Class<?> type) {
        SerDeserializer deser = (SerDeserializer)this.deserializers.get(type);
        if (deser == null) {
            deser = DefaultDeserializer.INSTANCE;
        }
        return deser;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

