/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.joda.beans.ser.bin.MsgPack;

public abstract class MsgPackInput
extends MsgPack {
    private final DataInputStream input;

    public MsgPackInput(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public MsgPackInput(InputStream stream) {
        this(new DataInputStream(stream));
    }

    public MsgPackInput(DataInputStream stream) {
        this.input = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAll() {
        try {
            try {
                int b = this.input.read();
                while (b >= 0) {
                    this.readObject(b);
                    b = this.input.read();
                }
            }
            finally {
                this.input.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected void readObject(int unsigned) throws IOException {
        this.handleObjectStart();
        byte b = (byte)unsigned;
        if (b >= -32 && b <= 127) {
            this.handleInt(b);
        } else if (b >= -96 && b <= -65) {
            this.string(b - -96);
        } else if (b >= -112 && b <= -97) {
            this.array(b - -112);
        } else if (b >= -128 && b <= -113) {
            this.map(b - -128);
        } else {
            switch (b) {
                case -64: {
                    this.handleNil();
                    break;
                }
                case -62: {
                    this.handleBoolean(false);
                    break;
                }
                case -61: {
                    this.handleBoolean(true);
                    break;
                }
                case -60: {
                    this.binary(this.input.readUnsignedByte());
                    break;
                }
                case -59: {
                    this.binary(this.input.readUnsignedShort());
                    break;
                }
                case -58: {
                    this.binary(this.input.readInt());
                    break;
                }
                case -57: {
                    this.extension(this.input.readUnsignedByte());
                    break;
                }
                case -56: {
                    this.extension(this.input.readUnsignedShort());
                    break;
                }
                case -55: {
                    this.extension(this.input.readInt());
                    break;
                }
                case -54: {
                    float value = this.input.readFloat();
                    this.handleFloat(value);
                    break;
                }
                case -53: {
                    double value = this.input.readDouble();
                    this.handleDouble(value);
                    break;
                }
                case -52: {
                    int value = this.input.readUnsignedByte();
                    this.handleInt(value);
                    break;
                }
                case -51: {
                    int value = this.input.readUnsignedShort();
                    this.handleInt(value);
                    break;
                }
                case -50: {
                    int val = this.input.readInt();
                    if (val >= 0) {
                        this.handleInt(val);
                        break;
                    }
                    long value = (long)val & 0xFFFFFFFFL;
                    this.handleUnsignedLong(value);
                    break;
                }
                case -49: {
                    long value = this.input.readLong();
                    this.handleUnsignedLong(value);
                    break;
                }
                case -48: {
                    byte value = this.input.readByte();
                    this.handleInt(value);
                    break;
                }
                case -47: {
                    short value = this.input.readShort();
                    this.handleInt(value);
                    break;
                }
                case -46: {
                    int value = this.input.readInt();
                    this.handleInt(value);
                    break;
                }
                case -45: {
                    long value = this.input.readLong();
                    this.handleSignedLong(value);
                    break;
                }
                case -44: {
                    this.extension(1);
                    break;
                }
                case -43: {
                    this.extension(2);
                    break;
                }
                case -42: {
                    this.extension(4);
                    break;
                }
                case -41: {
                    this.extension(8);
                    break;
                }
                case -40: {
                    this.extension(16);
                    break;
                }
                case -39: {
                    this.string(this.input.readUnsignedByte());
                    break;
                }
                case -38: {
                    this.string(this.input.readUnsignedShort());
                    break;
                }
                case -37: {
                    this.string(this.input.readInt());
                    break;
                }
                case -36: {
                    this.array(this.input.readUnsignedShort());
                    break;
                }
                case -35: {
                    this.array(this.input.readInt());
                    break;
                }
                case -34: {
                    this.map(this.input.readUnsignedShort());
                    break;
                }
                case -33: {
                    this.map(this.input.readInt());
                    break;
                }
                default: {
                    this.handleUnknown(b);
                }
            }
        }
    }

    private void string(int size) throws IOException {
        if (size < 0) {
            throw new IllegalStateException("String too large");
        }
        byte[] bytes = new byte[size];
        this.input.readFully(bytes);
        String str = new String(bytes, UTF_8);
        this.handleString(str);
    }

    private void array(int size) throws IOException {
        this.handleArrayHeader(size);
        for (int i = 0; i < size; ++i) {
            this.readArrayItem();
        }
    }

    protected void readArrayItem() throws IOException {
        int next = this.input.readUnsignedByte();
        this.readObject(next);
    }

    private void map(int size) throws IOException {
        this.handleMapHeader(size);
        for (int i = 0; i < size; ++i) {
            this.readMapKey();
            this.readMapValue();
        }
    }

    protected void readMapKey() throws IOException {
        int next = this.input.readUnsignedByte();
        this.readObject(next);
    }

    protected void readMapValue() throws IOException {
        int next = this.input.readUnsignedByte();
        this.readObject(next);
    }

    private void binary(int size) throws IOException {
        if (size < 0) {
            throw new IllegalStateException("Binary too large");
        }
        byte[] bytes = new byte[size];
        this.input.readFully(bytes);
        this.handleBinary(bytes);
    }

    private void extension(int size) throws IOException {
        byte type = this.input.readByte();
        if (size < 0) {
            throw new IllegalStateException("Extension too large");
        }
        byte[] bytes = new byte[size];
        this.input.readFully(bytes);
        this.handleExtension(type, bytes);
    }

    protected void handleObjectStart() {
    }

    protected void handleBoolean(boolean bool) {
    }

    protected void handleNil() {
    }

    protected void handleInt(int value) {
    }

    protected void handleUnsignedLong(long value) {
    }

    protected void handleSignedLong(long value) {
    }

    protected void handleFloat(float value) {
    }

    protected void handleDouble(double value) {
    }

    protected void handleUnknown(byte b) {
    }

    protected void handleString(String str) {
    }

    protected void handleArrayHeader(int size) {
    }

    protected void handleMapHeader(int size) {
    }

    protected void handleBinary(byte[] bytes) throws IOException {
    }

    protected void handleExtension(int type, byte[] bytes) throws IOException {
    }

    public static void skipObject(DataInputStream input) throws IOException {
        new Skipper(input).skip(input.readByte());
    }

    private static class Skipper
    extends MsgPackInput {
        public Skipper(DataInputStream input) {
            super(input);
        }

        void skip(int typeByte) throws IOException {
            this.readObject(typeByte);
        }
    }
}

