/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.joda.beans.ser.bin.MsgPackInput;

public final class MsgPackVisualizer
extends MsgPackInput {
    private String indent = "";

    public MsgPackVisualizer(byte[] bytes) {
        super(bytes);
    }

    public MsgPackVisualizer(InputStream stream) {
        super(stream);
    }

    public MsgPackVisualizer(DataInputStream stream) {
        super(stream);
    }

    public void visualize() {
        this.readAll();
    }

    @Override
    protected void readArrayItem() throws IOException {
        this.indent = this.indent + "- ";
        super.readArrayItem();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void readMapKey() throws IOException {
        this.indent = this.indent + "= ";
        super.readMapKey();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void readMapValue() throws IOException {
        this.indent = this.indent + "  ";
        super.readMapValue();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void handleObjectStart() {
        System.out.print(this.indent);
        this.indent = this.indent.replace("-", " ").replace("=", " ");
    }

    @Override
    protected void handleBoolean(boolean bool) {
        System.out.println(bool);
    }

    @Override
    protected void handleNil() {
        System.out.println("nil");
    }

    @Override
    protected void handleInt(int value) {
        System.out.println("int " + value);
    }

    @Override
    protected void handleUnsignedLong(long value) {
        System.out.println("int " + value + " unsigned");
    }

    @Override
    protected void handleSignedLong(long value) {
        System.out.println("int " + value + " signed");
    }

    @Override
    protected void handleFloat(float value) {
        System.out.println("flt " + value);
    }

    @Override
    protected void handleDouble(double value) {
        System.out.println("dbl " + value);
    }

    @Override
    protected void handleUnknown(byte b) {
        System.out.println("Unknown - " + String.format("%02X ", b));
    }

    @Override
    protected void handleString(String str) {
        System.out.println("str '" + str + '\'');
    }

    @Override
    protected void handleArrayHeader(int size) {
        System.out.println("arr (" + size + ")");
    }

    @Override
    protected void handleMapHeader(int size) {
        System.out.println("map (" + size + ")");
    }

    @Override
    protected void handleBinary(byte[] bytes) {
        System.out.print("bin '");
        for (byte b : bytes) {
            System.out.print(MsgPackVisualizer.toHex(b));
        }
        System.out.println("'");
    }

    @Override
    protected void handleExtension(int type, byte[] bytes) throws IOException {
        if (type == 32 || type == 33 || type == 34) {
            String str = new String(bytes, UTF_8);
            System.out.println("ext type=" + type + " '" + str + "'");
        } else {
            System.out.print("ext type=" + type + " '");
            for (byte b : bytes) {
                System.out.print(MsgPackVisualizer.toHex(b));
            }
            System.out.println("'");
        }
    }
}

