/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import org.joda.beans.JodaBeanUtils;
import org.joda.beans.ser.SerDeserializers;
import org.joda.beans.ser.SerIteratorFactory;
import org.joda.beans.ser.bin.JodaBeanBinReader;
import org.joda.beans.ser.bin.JodaBeanBinWriter;
import org.joda.beans.ser.json.JodaBeanJsonReader;
import org.joda.beans.ser.json.JodaBeanJsonWriter;
import org.joda.beans.ser.json.JodaBeanSimpleJsonReader;
import org.joda.beans.ser.json.JodaBeanSimpleJsonWriter;
import org.joda.beans.ser.xml.JodaBeanXmlReader;
import org.joda.beans.ser.xml.JodaBeanXmlWriter;
import org.joda.convert.StringConvert;

public final class JodaBeanSer {
    public static final JodaBeanSer COMPACT = new JodaBeanSer("", "", StringConvert.create(), SerIteratorFactory.INSTANCE, true, SerDeserializers.INSTANCE);
    public static final JodaBeanSer PRETTY = new JodaBeanSer(" ", "\n", StringConvert.create(), SerIteratorFactory.INSTANCE, true, SerDeserializers.INSTANCE);
    private final String indent;
    private final String newLine;
    private final StringConvert converter;
    private final SerIteratorFactory iteratorFactory;
    private final boolean shortTypes;
    private final SerDeserializers deserializers;

    private JodaBeanSer(String indent, String newLine, StringConvert converter, SerIteratorFactory iteratorFactory, boolean shortTypes, SerDeserializers deserializers) {
        this.indent = indent;
        this.newLine = newLine;
        this.converter = converter;
        this.iteratorFactory = iteratorFactory;
        this.shortTypes = shortTypes;
        this.deserializers = deserializers;
    }

    public String getIndent() {
        return this.indent;
    }

    public JodaBeanSer withIndent(String indent) {
        JodaBeanUtils.notNull(indent, "indent");
        return new JodaBeanSer(indent, this.newLine, this.converter, this.iteratorFactory, this.shortTypes, this.deserializers);
    }

    public String getNewLine() {
        return this.newLine;
    }

    public JodaBeanSer withNewLine(String newLine) {
        JodaBeanUtils.notNull(newLine, "newLine");
        return new JodaBeanSer(this.indent, newLine, this.converter, this.iteratorFactory, this.shortTypes, this.deserializers);
    }

    public StringConvert getConverter() {
        return this.converter;
    }

    public JodaBeanSer withConverter(StringConvert converter) {
        JodaBeanUtils.notNull(converter, "converter");
        return new JodaBeanSer(this.indent, this.newLine, converter, this.iteratorFactory, this.shortTypes, this.deserializers);
    }

    public SerIteratorFactory getIteratorFactory() {
        return this.iteratorFactory;
    }

    public JodaBeanSer withIteratorFactory(SerIteratorFactory iteratorFactory) {
        JodaBeanUtils.notNull(this.converter, "converter");
        return new JodaBeanSer(this.indent, this.newLine, this.converter, iteratorFactory, this.shortTypes, this.deserializers);
    }

    public boolean isShortTypes() {
        return this.shortTypes;
    }

    public JodaBeanSer withShortTypes(boolean shortTypes) {
        return new JodaBeanSer(this.indent, this.newLine, this.converter, this.iteratorFactory, shortTypes, this.deserializers);
    }

    public SerDeserializers getDeserializers() {
        return this.deserializers;
    }

    public JodaBeanSer withDeserializers(SerDeserializers deserializers) {
        JodaBeanUtils.notNull(deserializers, "deserializers");
        return new JodaBeanSer(this.indent, this.newLine, this.converter, this.iteratorFactory, this.shortTypes, deserializers);
    }

    public JodaBeanBinWriter binWriter() {
        return new JodaBeanBinWriter(this);
    }

    public JodaBeanBinReader binReader() {
        return new JodaBeanBinReader(this);
    }

    public JodaBeanXmlWriter xmlWriter() {
        return new JodaBeanXmlWriter(this);
    }

    public JodaBeanXmlReader xmlReader() {
        return new JodaBeanXmlReader(this);
    }

    public JodaBeanJsonWriter jsonWriter() {
        return new JodaBeanJsonWriter(this);
    }

    public JodaBeanJsonReader jsonReader() {
        return new JodaBeanJsonReader(this);
    }

    public JodaBeanSimpleJsonWriter simpleJsonWriter() {
        return new JodaBeanSimpleJsonWriter(this);
    }

    public JodaBeanSimpleJsonReader simpleJsonReader() {
        return new JodaBeanSimpleJsonReader(this);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

