/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;

public abstract class BasicImmutableBeanBuilder<T extends Bean>
implements BeanBuilder<T> {
    private final MetaBean meta;

    public BasicImmutableBeanBuilder(MetaBean meta) {
        this.meta = meta;
    }

    @Override
    public Object get(String propertyName) {
        return this.get(this.meta.metaProperty(propertyName));
    }

    @Override
    public Object get(MetaProperty<?> metaProperty) {
        return this.get(metaProperty.name());
    }

    @Override
    public BeanBuilder<T> set(MetaProperty<?> metaProperty, Object value) {
        this.set(metaProperty.name(), value);
        return this;
    }

    @Override
    @Deprecated
    public BeanBuilder<T> setString(String propertyName, String value) {
        this.setString(this.meta.metaProperty(propertyName), value);
        return this;
    }

    @Override
    @Deprecated
    public BeanBuilder<T> setString(MetaProperty<?> metaProperty, String value) {
        this.set(metaProperty.name(), JodaBeanUtils.stringConverter().convertFromString(metaProperty.propertyType(), value));
        return this;
    }

    @Override
    @Deprecated
    public BeanBuilder<T> setAll(Map<String, ? extends Object> propertyValueMap) {
        for (Map.Entry<String, ? extends Object> entry : propertyValueMap.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String toString() {
        return "BeanBuilder";
    }
}

