/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.light;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.joda.beans.Bean;
import org.joda.beans.MetaBean;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.light.LightMetaProperty;
import org.joda.beans.impl.light.PropertyGetter;

final class ImmutableLightMetaProperty<P>
extends LightMetaProperty<P> {
    private final PropertyGetter getter;
    private final PropertyStyle style;

    static <P> ImmutableLightMetaProperty<P> of(MetaBean metaBean, final Field field, final String propertyName, int constructorIndex) {
        PropertyGetter getter = new PropertyGetter(){

            @Override
            public Object get(Bean bean) {
                try {
                    return field.get(bean);
                }
                catch (IllegalArgumentException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
            }
        };
        return new ImmutableLightMetaProperty(metaBean, propertyName, field.getType(), field.getGenericType(), Arrays.asList(field.getAnnotations()), getter, constructorIndex, PropertyStyle.IMMUTABLE);
    }

    static <P> ImmutableLightMetaProperty<P> of(MetaBean metaBean, Field field, final Method method, final String propertyName, int constructorIndex) {
        PropertyGetter getter = new PropertyGetter(){

            @Override
            public Object get(Bean bean) {
                try {
                    return method.invoke((Object)bean, new Object[0]);
                }
                catch (IllegalArgumentException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ex.getCause();
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        return new ImmutableLightMetaProperty(metaBean, propertyName, field.getType(), field.getGenericType(), Arrays.asList(field.getAnnotations()), getter, constructorIndex, PropertyStyle.IMMUTABLE);
    }

    static <P> ImmutableLightMetaProperty<P> of(MetaBean metaBean, final Method method, final String propertyName, int constructorIndex) {
        PropertyGetter getter = new PropertyGetter(){

            @Override
            public Object get(Bean bean) {
                try {
                    return method.invoke((Object)bean, new Object[0]);
                }
                catch (IllegalArgumentException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ex.getCause();
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        return new ImmutableLightMetaProperty(metaBean, propertyName, method.getReturnType(), method.getGenericReturnType(), Arrays.asList(method.getAnnotations()), getter, constructorIndex, PropertyStyle.DERIVED);
    }

    ImmutableLightMetaProperty(MetaBean metaBean, String propertyName, Class<P> propertyType, Type propertyGenericType, List<Annotation> annotations, PropertyGetter getter, int constructorIndex, PropertyStyle style) {
        super(metaBean, propertyName, propertyType, propertyGenericType, annotations, constructorIndex);
        this.getter = getter;
        this.style = style;
    }

    @Override
    public PropertyStyle style() {
        return this.style;
    }

    @Override
    public P get(Bean bean) {
        return (P)this.getter.get(bean);
    }

    @Override
    public void set(Bean bean, Object value) {
        throw new UnsupportedOperationException("Property cannot be written: " + this.name());
    }
}

