/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.joda.beans.ser.bin.MsgPackInput;

@Deprecated
public final class MsgPackVisualizer
extends MsgPackInput {
    private String indent = "";
    private StringWriter buf = new StringWriter(512);
    private PrintWriter writer = new PrintWriter(new StringWriter(512));

    public MsgPackVisualizer(byte[] bytes) {
        super(bytes);
    }

    public MsgPackVisualizer(InputStream stream) {
        super(stream);
    }

    public MsgPackVisualizer(DataInputStream stream) {
        super(stream);
    }

    public void visualize() {
        this.readAll();
        this.writer.flush();
        System.out.println(this.buf.toString());
    }

    String visualizeData() {
        this.readAll();
        this.writer.flush();
        return this.buf.toString();
    }

    @Override
    protected void readArrayItem() throws IOException {
        this.indent = this.indent + "- ";
        super.readArrayItem();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void readMapKey() throws IOException {
        this.indent = this.indent + "= ";
        super.readMapKey();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void readMapValue() throws IOException {
        this.indent = this.indent + "  ";
        super.readMapValue();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void handleObjectStart() {
        this.writer.print(this.indent);
        this.indent = this.indent.replace("-", " ").replace("=", " ");
    }

    @Override
    protected void handleBoolean(boolean bool) {
        this.writer.println(bool);
    }

    @Override
    protected void handleNil() {
        this.writer.println("nil");
    }

    @Override
    protected void handleInt(int value) {
        this.writer.println("int " + value);
    }

    @Override
    protected void handleUnsignedLong(long value) {
        this.writer.println("int " + value + " unsigned");
    }

    @Override
    protected void handleSignedLong(long value) {
        this.writer.println("int " + value + " signed");
    }

    @Override
    protected void handleFloat(float value) {
        this.writer.println("flt " + value);
    }

    @Override
    protected void handleDouble(double value) {
        this.writer.println("dbl " + value);
    }

    @Override
    protected void handleUnknown(byte b) {
        this.writer.println("Unknown - " + String.format("%02X ", b));
    }

    @Override
    protected void handleString(String str) {
        this.writer.println("str '" + str + '\'');
    }

    @Override
    protected void handleArrayHeader(int size) {
        this.writer.println("arr (" + size + ")");
    }

    @Override
    protected void handleMapHeader(int size) {
        this.writer.println("map (" + size + ")");
    }

    @Override
    protected void handleBinary(byte[] bytes) {
        this.writer.print("bin '");
        for (byte b : bytes) {
            this.writer.print(MsgPackVisualizer.toHex(b));
        }
        this.writer.println("'");
    }

    @Override
    protected void handleExtension(int type, byte[] bytes) throws IOException {
        if (type == 32 || type == 33 || type == 34) {
            String str = new String(bytes, UTF_8);
            this.writer.println("ext type=" + type + " '" + str + "'");
        } else {
            this.writer.print("ext type=" + type + " '");
            for (byte b : bytes) {
                this.writer.print(MsgPackVisualizer.toHex(b));
            }
            this.writer.println("'");
        }
    }
}

