/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.beans.gen.GeneratableProperty;

class GeneratableBean {
    private final SortedSet<String> currentImports = new TreeSet<String>();
    private final SortedSet<String> newImports = new TreeSet<String>();
    private int lastImportLine;
    private String beanStyle;
    private String beanBuilderScope;
    private boolean cacheHashCode;
    private boolean immutable;
    private boolean constructable;
    private int immutableConstructor;
    private String immutableValidator;
    private String immutableDefaults;
    private int constructorStyle;
    private String typeFull;
    private String typeRaw;
    private String[] typeGenericName;
    private String[] typeGenericExtends;
    private boolean typeFinal;
    private boolean root;
    private String superTypeFull;
    private String superTypeRaw;
    private String superTypeGeneric;
    private List<GeneratableProperty> properties = new ArrayList<GeneratableProperty>();
    private boolean manualClone;
    private boolean manualEqualsHashCode;
    private boolean manualToStringCode;

    GeneratableBean() {
    }

    public SortedSet<String> getCurrentImports() {
        return this.currentImports;
    }

    public SortedSet<String> getNewImports() {
        return this.newImports;
    }

    public void ensureImport(Class<?> cls) {
        if (!this.currentImports.contains(cls.getName())) {
            this.newImports.add(cls.getName());
        }
    }

    public int getImportInsertLocation() {
        return this.lastImportLine;
    }

    public void setImportInsertLocation(int location) {
        this.lastImportLine = location;
    }

    public String getBeanStyle() {
        return this.beanStyle;
    }

    public void setBeanStyle(String beanStyle) {
        this.beanStyle = beanStyle;
    }

    public boolean isBeanStyleValid() {
        return "full".equals(this.beanStyle) || "smart".equals(this.beanStyle) || "minimal".equals(this.beanStyle);
    }

    public boolean isBeanStyleGenerateProperties() {
        return "full".equals(this.beanStyle) || "smart".equals(this.beanStyle) && !this.isImmutable();
    }

    public boolean isBeanStyleGenerateMetaProperties() {
        return "full".equals(this.beanStyle) || "smart".equals(this.beanStyle);
    }

    public String getBeanBuilderScope() {
        return this.beanBuilderScope;
    }

    public void setBeanBuilderScope(String builderScope) {
        this.beanBuilderScope = builderScope;
    }

    public boolean isBeanBuilderScopeValid() {
        return "smart".equals(this.beanBuilderScope) || "private".equals(this.beanBuilderScope) || "public".equals(this.beanBuilderScope);
    }

    public String getEffectiveBuilderScope() {
        return "smart".equals(this.beanBuilderScope) ? "public" : this.beanBuilderScope;
    }

    public boolean isEffectiveBuilderScopePublic() {
        return "smart".equals(this.beanBuilderScope) || "public".equals(this.beanBuilderScope);
    }

    public boolean isBuilderScopePublic() {
        return "public".equals(this.beanBuilderScope);
    }

    public boolean isCacheHashCode() {
        return this.cacheHashCode;
    }

    public void setCacheHashCode(boolean cacheHashCode) {
        this.cacheHashCode = cacheHashCode;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isMutable() {
        return !this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public boolean isConstructable() {
        return this.constructable;
    }

    public void setConstructable(boolean constructable) {
        this.constructable = constructable;
    }

    public int getImmutableConstructor() {
        return this.immutableConstructor;
    }

    public void setImmutableConstructor(int manualConstructor) {
        this.immutableConstructor = manualConstructor;
    }

    public String getImmutableValidator() {
        return this.immutableValidator;
    }

    public void setImmutableValidator(String immutableValidator) {
        this.immutableValidator = immutableValidator;
    }

    public String getImmutableDefaults() {
        return this.immutableDefaults;
    }

    public void setImmutableDefaults(String immutableDefaults) {
        this.immutableDefaults = immutableDefaults;
    }

    public int getConstructorStyle() {
        return this.constructorStyle;
    }

    public void setConstructorStyle(int constructorStyle) {
        this.constructorStyle = constructorStyle;
    }

    public boolean isManualClone() {
        return this.manualClone;
    }

    public void setManualClone(boolean manualClone) {
        this.manualClone = manualClone;
    }

    public boolean isManualEqualsHashCode() {
        return this.manualEqualsHashCode;
    }

    public void setManualEqualsHashCode(boolean manualEqualsHashCode) {
        this.manualEqualsHashCode = manualEqualsHashCode;
    }

    public boolean isManualToStringCode() {
        return this.manualToStringCode;
    }

    public void setManualToStringCode(boolean manualToStringCode) {
        this.manualToStringCode = manualToStringCode;
    }

    public void setTypeParts(String[] parts) {
        this.typeFinal = parts[0] != null;
        this.typeFull = parts[1];
        this.typeRaw = parts[2];
        if (parts[7] != null) {
            this.typeGenericName = new String[]{parts[3], parts[5], parts[7]};
            this.typeGenericExtends = new String[3];
            this.typeGenericExtends[0] = parts[4] != null ? parts[4] : "";
            this.typeGenericExtends[1] = parts[6] != null ? parts[6] : "";
            this.typeGenericExtends[2] = parts[8] != null ? parts[8] : "";
        } else if (parts[5] != null) {
            this.typeGenericName = new String[]{parts[3], parts[5]};
            this.typeGenericExtends = new String[2];
            this.typeGenericExtends[0] = parts[4] != null ? parts[4] : "";
            this.typeGenericExtends[1] = parts[6] != null ? parts[6] : "";
        } else if (parts[3] != null) {
            this.typeGenericName = new String[]{parts[3]};
            this.typeGenericExtends = new String[1];
            this.typeGenericExtends[0] = parts[4] != null ? parts[4] : "";
        } else {
            this.typeGenericName = new String[0];
            this.typeGenericExtends = new String[0];
        }
    }

    public void setSuperTypeParts(String[] parts) {
        if (parts.length == 1) {
            this.root = true;
            this.immutable = "ImmutableBean".equals(parts[0]);
            this.superTypeFull = "";
            this.superTypeRaw = "";
            this.superTypeGeneric = "";
        } else {
            this.root = "DirectBean".equals(parts[0]);
            this.immutable = false;
            this.superTypeFull = parts[0];
            this.superTypeRaw = parts[1];
            this.superTypeGeneric = parts[4] != null ? parts[2] + ", " + parts[3] + ", " + parts[4] : (parts[3] != null ? parts[2] + ", " + parts[3] : (parts[2] != null ? parts[2] : ""));
        }
    }

    public List<GeneratableProperty> getProperties() {
        return this.properties;
    }

    public boolean isTypeFinal() {
        return this.typeFinal;
    }

    public void setTypeFinal(boolean typeFinal) {
        this.typeFinal = typeFinal;
    }

    public boolean isSubClass() {
        return !this.root;
    }

    public boolean isRootClass() {
        return this.root;
    }

    public boolean isExtendsDirectBean() {
        return "DirectBean".equals(this.superTypeFull);
    }

    public boolean isTypeGeneric() {
        return this.typeGenericName.length > 0;
    }

    public int getTypeGenericCount() {
        return this.typeGenericName.length;
    }

    public String getType() {
        return this.typeFull;
    }

    public String getTypeGeneric(boolean includeBrackets) {
        if (!this.isTypeGeneric()) {
            return "";
        }
        String result = this.typeGenericName[0] + this.typeGenericExtends[0];
        if (this.typeGenericExtends.length > 1) {
            result = result + ", " + this.typeGenericName[1] + this.typeGenericExtends[1];
            if (this.typeGenericExtends.length > 2) {
                result = result + ", " + this.typeGenericName[2] + this.typeGenericExtends[2];
            }
        }
        return includeBrackets && result.length() > 0 ? '<' + result + '>' : result;
    }

    public String getTypeGenericName(boolean includeBrackets) {
        if (!this.isTypeGeneric()) {
            return "";
        }
        String result = this.typeGenericName[0];
        if (this.typeGenericExtends.length > 1) {
            result = result + ", " + this.typeGenericName[1];
            if (this.typeGenericExtends.length > 2) {
                result = result + ", " + this.typeGenericName[2];
            }
        }
        return includeBrackets && result.length() > 0 ? '<' + result + '>' : result;
    }

    public String getTypeGenericName(int typeParamIndex, boolean includeBrackets) {
        String result = this.typeGenericName[typeParamIndex];
        return includeBrackets && result.length() > 0 ? '<' + result + '>' : result;
    }

    public String getTypeGenericExtends(int typeParamIndex) {
        return this.typeGenericExtends[typeParamIndex];
    }

    public String getTypeGenericExtends(int typeParamIndex, String typeParamName) {
        String genericClause = this.typeGenericExtends[typeParamIndex];
        return genericClause.replace("<" + this.typeGenericName[typeParamIndex] + ">", "<" + typeParamName + ">");
    }

    public String getTypeNoExtends() {
        return this.typeRaw + this.getTypeGenericName(true);
    }

    public String getTypeRaw() {
        return this.typeRaw;
    }

    public String getTypeWildcard() {
        if (!this.isTypeGeneric()) {
            return this.typeRaw;
        }
        String result = "?";
        if (this.typeGenericExtends.length > 1) {
            result = result + ", ?";
            if (this.typeGenericExtends.length > 2) {
                result = result + ", ?";
            }
        }
        return this.typeRaw + '<' + result + '>';
    }

    public boolean isTypeGenerifiedBy(String type) {
        if (this.typeGenericName.length > 2 && this.typeGenericName[2].equals(type)) {
            return true;
        }
        if (this.typeGenericName.length > 1 && this.typeGenericName[1].equals(type)) {
            return true;
        }
        return this.typeGenericName.length > 0 && this.typeGenericName[0].equals(type);
    }

    public boolean isSuperTypeGeneric() {
        return this.superTypeGeneric.length() > 0;
    }

    public String getSuperType() {
        return this.superTypeFull;
    }

    public String getSuperTypeGeneric(boolean includeBrackets) {
        return includeBrackets && this.superTypeGeneric.length() > 0 ? '<' + this.superTypeGeneric + '>' : this.superTypeGeneric;
    }

    public String getSuperTypeRaw() {
        return this.superTypeRaw;
    }

    public boolean isValidated() {
        for (GeneratableProperty property : this.properties) {
            if (!property.isValidated()) continue;
            return true;
        }
        return false;
    }

    public String getNestedClassConstructorScope() {
        return this.isTypeFinal() ? "private" : "protected";
    }
}

