/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.xml;

import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.convert.StringConverter;

public class JodaBeanXmlWriter {
    private final JodaBeanSer settings;
    private final StringBuilder builder;
    private Bean rootBean;
    private String basePackage;
    private Map<Class<?>, String> knownTypes = new HashMap();

    public JodaBeanXmlWriter(JodaBeanSer settings) {
        this(settings, new StringBuilder(1024));
    }

    public JodaBeanXmlWriter(JodaBeanSer settings, StringBuilder builder) {
        this.settings = settings;
        this.builder = builder;
    }

    public String write(Bean bean) {
        return this.write(bean, true);
    }

    public String write(Bean bean, boolean rootType) {
        return this.writeToBuilder(bean, rootType).toString();
    }

    public StringBuilder writeToBuilder(Bean bean) {
        return this.writeToBuilder(bean, true);
    }

    public StringBuilder writeToBuilder(Bean bean, boolean rootType) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.rootBean = bean;
        this.basePackage = rootType ? bean.getClass().getPackage().getName() + "." : null;
        String type = this.rootBean.getClass().getName();
        this.writeHeader();
        this.builder.append('<').append("bean");
        if (rootType) {
            this.appendAttribute(this.builder, "type", type);
        }
        this.builder.append('>').append(this.settings.getNewLine());
        this.writeBean(this.rootBean, this.settings.getIndent());
        this.builder.append('<').append('/').append("bean").append('>').append(this.settings.getNewLine());
        return this.builder;
    }

    private void writeHeader() {
        this.builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(this.settings.getNewLine());
    }

    private boolean writeBean(Bean bean, String currentIndent) {
        boolean output = false;
        for (MetaProperty<?> prop : bean.metaBean().metaPropertyIterable()) {
            if (!prop.style().isSerializable()) continue;
            output = true;
            Object value = prop.get(bean);
            if (value == null) continue;
            String propName = prop.name();
            Class<?> propType = prop.propertyType();
            if (value instanceof Bean) {
                if (this.settings.getConverter().isConvertible(value.getClass())) {
                    this.writeSimple(currentIndent, propName, new StringBuilder(), propType, value);
                    continue;
                }
                this.writeBean(currentIndent, propName, new StringBuilder(), propType, (Bean)value);
                continue;
            }
            SerIterator itemIterator = this.settings.getIteratorFactory().create(value, prop, bean.getClass());
            if (itemIterator != null) {
                this.writeElements(currentIndent, propName, new StringBuilder(), itemIterator);
                continue;
            }
            this.writeSimple(currentIndent, propName, new StringBuilder(), propType, value);
        }
        return output;
    }

    private void writeBean(String currentIndent, String tagName, StringBuilder attrs, Class<?> propType, Bean value) {
        if (value == null) {
            throw new IllegalArgumentException("Bean cannot be null");
        }
        this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs);
        if (value.getClass() != propType) {
            String typeStr = SerTypeMapper.encodeType(value.getClass(), this.settings, this.basePackage, this.knownTypes);
            this.appendAttribute(this.builder, "type", typeStr);
        }
        int insertPoint = this.builder.length();
        this.builder.append('>').append(this.settings.getNewLine());
        if (this.writeBean(value, currentIndent + this.settings.getIndent())) {
            this.builder.append(currentIndent).append('<').append('/').append(tagName).append('>').append(this.settings.getNewLine());
        } else {
            this.builder.insert(insertPoint, '/');
        }
    }

    private void writeElements(String currentIndent, String tagName, StringBuilder attrs, SerIterator itemIterator) {
        if (itemIterator.metaTypeRequired()) {
            this.appendAttribute(attrs, "metatype", itemIterator.metaTypeName());
        }
        if (itemIterator.category() == SerCategory.GRID) {
            this.appendAttribute(attrs, "rows", Integer.toString(itemIterator.dimensionSize(0)));
            this.appendAttribute(attrs, "cols", Integer.toString(itemIterator.dimensionSize(1)));
        }
        if (itemIterator.size() == 0) {
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append('/').append('>').append(this.settings.getNewLine());
        } else {
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append('>').append(this.settings.getNewLine());
            this.writeElements(currentIndent + this.settings.getIndent(), itemIterator);
            this.builder.append(currentIndent).append('<').append('/').append(tagName).append('>').append(this.settings.getNewLine());
        }
    }

    private void writeElements(String currentIndent, SerIterator itemIterator) {
        StringConverter keyConverter = null;
        StringConverter rowConverter = null;
        StringConverter columnConverter = null;
        boolean keyBean = false;
        if (itemIterator.category() == SerCategory.TABLE || itemIterator.category() == SerCategory.GRID) {
            try {
                rowConverter = this.settings.getConverter().findConverterNoGenerics(itemIterator.keyType());
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Unable to write map as declared key type is neither a bean nor a simple type: " + itemIterator.keyType().getName(), ex);
            }
            try {
                columnConverter = this.settings.getConverter().findConverterNoGenerics(itemIterator.columnType());
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Unable to write map as declared column type is neither a bean nor a simple type: " + itemIterator.columnType().getName(), ex);
            }
        }
        if (itemIterator.category() == SerCategory.MAP) {
            if (this.settings.getConverter().isConvertible(itemIterator.keyType())) {
                keyConverter = this.settings.getConverter().findConverterNoGenerics(itemIterator.keyType());
            } else {
                keyBean = true;
            }
        }
        while (itemIterator.hasNext()) {
            itemIterator.next();
            StringBuilder attr = new StringBuilder(32);
            if (keyConverter != null) {
                String keyStr = this.convertToString((StringConverter<Object>)keyConverter, itemIterator.key(), "map key");
                this.appendAttribute(attr, "key", keyStr);
            }
            if (rowConverter != null) {
                String rowStr = this.convertToString((StringConverter<Object>)rowConverter, itemIterator.key(), "table row");
                this.appendAttribute(attr, "row", rowStr);
                String colStr = this.convertToString((StringConverter<Object>)columnConverter, itemIterator.column(), "table column");
                this.appendAttribute(attr, "col", colStr);
            }
            if (itemIterator.count() != 1) {
                this.appendAttribute(attr, "count", Integer.toString(itemIterator.count()));
            }
            if (keyBean) {
                Object key = itemIterator.key();
                this.builder.append(currentIndent).append('<').append("entry").append((CharSequence)attr).append('>').append(this.settings.getNewLine());
                this.writeKeyElement(currentIndent + this.settings.getIndent(), key, itemIterator);
                this.writeValueElement(currentIndent + this.settings.getIndent(), "item", new StringBuilder(), itemIterator);
                this.builder.append(currentIndent).append('<').append('/').append("entry").append('>').append(this.settings.getNewLine());
                continue;
            }
            String tagName = itemIterator.category() == SerCategory.MAP ? "entry" : "item";
            this.writeValueElement(currentIndent, tagName, attr, itemIterator);
        }
    }

    private String convertToString(StringConverter<Object> converter, Object obj, String description) {
        if (obj == null) {
            throw new IllegalArgumentException("Unable to write " + description + " as it cannot be null: " + obj);
        }
        String str = this.encodeAttribute(converter.convertToString(obj));
        if (str == null) {
            throw new IllegalArgumentException("Unable to write " + description + " as it cannot be a null string: " + obj);
        }
        return str;
    }

    private void writeKeyElement(String currentIndent, Object key, SerIterator itemIterator) {
        if (key == null) {
            throw new IllegalArgumentException("Unable to write map key as it cannot be null: " + key);
        }
        if (Bean.class.isAssignableFrom(itemIterator.keyType())) {
            this.writeBean(currentIndent, "item", new StringBuilder(), itemIterator.keyType(), (Bean)key);
        } else {
            try {
                this.writeSimple(currentIndent, "item", new StringBuilder(), Object.class, key);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Unable to write map as declared key type is neither a bean nor a simple type: " + itemIterator.keyType().getName(), ex);
            }
        }
    }

    private void writeValueElement(String currentIndent, String tagName, StringBuilder attrs, SerIterator itemIterator) {
        Object value = itemIterator.value();
        Class<?> valueType = itemIterator.valueType();
        if (value == null) {
            this.appendAttribute(attrs, "null", "true");
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append("/>").append(this.settings.getNewLine());
        } else if (value instanceof Bean) {
            if (this.settings.getConverter().isConvertible(value.getClass())) {
                this.writeSimple(currentIndent, tagName, attrs, valueType, value);
            } else {
                this.writeBean(currentIndent, tagName, attrs, valueType, (Bean)value);
            }
        } else {
            SerIterator childIterator = this.settings.getIteratorFactory().createChild(value, itemIterator);
            if (childIterator != null) {
                this.writeElements(currentIndent, tagName, attrs, childIterator);
            } else {
                this.writeSimple(currentIndent, tagName, attrs, valueType, value);
            }
        }
    }

    private void writeSimple(String currentIndent, String tagName, StringBuilder attrs, Class<?> declaredType, Object value) {
        Class effectiveType;
        if (declaredType == Object.class) {
            Class realType = value.getClass();
            if (realType != String.class) {
                effectiveType = this.settings.getConverter().findTypedConverter(realType).getEffectiveType();
                String typeStr = SerTypeMapper.encodeType(effectiveType, this.settings, this.basePackage, this.knownTypes);
                this.appendAttribute(attrs, "type", typeStr);
            } else {
                effectiveType = realType;
            }
        } else if (!this.settings.getConverter().isConvertible(declaredType)) {
            effectiveType = this.settings.getConverter().findTypedConverter(value.getClass()).getEffectiveType();
            String typeStr = SerTypeMapper.encodeType(effectiveType, this.settings, this.basePackage, this.knownTypes);
            this.appendAttribute(attrs, "type", typeStr);
        } else {
            effectiveType = declaredType;
        }
        try {
            String converted = this.settings.getConverter().convertToString(effectiveType, value);
            if (converted == null) {
                throw new IllegalArgumentException("Unable to write because converter returned a null string: " + value);
            }
            this.builder.append(currentIndent).append('<').append(tagName).append((CharSequence)attrs).append('>');
            this.appendEncoded(converted);
            this.builder.append('<').append('/').append(tagName).append('>').append(this.settings.getNewLine());
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to convert type " + effectiveType.getName() + " declared as " + declaredType.getName(), ex);
        }
    }

    private StringBuilder appendEncoded(String text) {
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    this.builder.append("&amp;");
                    continue block6;
                }
                case '<': {
                    this.builder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    this.builder.append("&gt;");
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    this.builder.append(ch);
                    continue block6;
                }
                default: {
                    if (ch < ' ') {
                        throw new IllegalArgumentException("Invalid character for XML: " + ch);
                    }
                    this.builder.append(ch);
                }
            }
        }
        return this.builder;
    }

    private StringBuilder appendAttribute(StringBuilder buf, String attrName, String encodedValue) {
        return buf.append(' ').append(attrName).append('=').append('\"').append(encodedValue).append('\"');
    }

    private String encodeAttribute(String text) {
        if (text == null) {
            return null;
        }
        return this.appendEncodedAttribute(new StringBuilder(text.length() + 16), text).toString();
    }

    private StringBuilder appendEncodedAttribute(StringBuilder builder, String text) {
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    builder.append("&amp;");
                    continue block10;
                }
                case '<': {
                    builder.append("&lt;");
                    continue block10;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    builder.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    builder.append("&apos;");
                    continue block10;
                }
                case '\t': {
                    builder.append("&#09;");
                    continue block10;
                }
                case '\n': {
                    builder.append("&#0A;");
                    continue block10;
                }
                case '\r': {
                    builder.append("&#0D;");
                    continue block10;
                }
                default: {
                    if (ch < ' ') {
                        throw new IllegalArgumentException("Invalid character for XML: " + ch);
                    }
                    builder.append(ch);
                }
            }
        }
        return builder;
    }
}

