/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;

class BeanComparisonError
extends AssertionError {
    private static final long serialVersionUID = 1L;
    private final Bean expected;
    private final Bean actual;

    public BeanComparisonError(String message, int maxErrors, Bean expected, Bean actual) {
        super((Object)BeanComparisonError.buildMessage(message, maxErrors, expected, actual));
        this.expected = expected;
        this.actual = actual;
    }

    private static String buildMessage(String message, int maxErrors, Bean expected, Bean actual) {
        List<String> diffs = new ArrayList<String>();
        BeanComparisonError.buildMessage(diffs, "", (Object)expected, (Object)actual);
        StringBuilder buf = new StringBuilder();
        buf.append(message != null ? message + ": " : "");
        buf.append("Bean did not equal expected. Differences:");
        int size = diffs.size();
        if (size > maxErrors) {
            diffs = diffs.subList(0, maxErrors);
        }
        for (String diff : diffs) {
            buf.append('\n').append(diff);
        }
        if (size > maxErrors) {
            buf.append("\n...and " + (size - 10) + " more differences");
        }
        return buf.toString();
    }

    private static void buildMessage(List<String> diffs, String prefix, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            diffs.add(prefix + ": Expected null, but was " + BeanComparisonError.buildSummary(actual, true));
            return;
        }
        if (expected != null && actual == null) {
            diffs.add(prefix + ": Was null, but expected " + BeanComparisonError.buildSummary(expected, true));
            return;
        }
        if (expected instanceof List && actual instanceof List) {
            List expectedList = (List)expected;
            List actualList = (List)actual;
            if (expectedList.size() != actualList.size()) {
                diffs.add(prefix + ": List size differs, expected " + expectedList.size() + " but was " + actualList.size());
                return;
            }
            for (int i = 0; i < expectedList.size(); ++i) {
                BeanComparisonError.buildMessage(diffs, prefix + '[' + i + "]", expectedList.get(i), actualList.get(i));
            }
            return;
        }
        if (expected instanceof Map && actual instanceof Map) {
            Map expectedMap = (Map)expected;
            Map actualMap = (Map)actual;
            if (expectedMap.size() != actualMap.size()) {
                diffs.add(prefix + ": Map size differs, expected " + expectedMap.size() + " but was " + actualMap.size());
                return;
            }
            if (!((Object)expectedMap.keySet()).equals(actualMap.keySet())) {
                diffs.add(prefix + ": Map keyset differs, expected " + BeanComparisonError.buildSummary(expectedMap.keySet(), false) + " but was " + BeanComparisonError.buildSummary(actualMap.keySet(), false));
                return;
            }
            for (Object key : expectedMap.keySet()) {
                BeanComparisonError.buildMessage(diffs, prefix + '[' + key + "]", expectedMap.get(key), actualMap.get(key));
            }
            return;
        }
        if (expected.getClass() != actual.getClass()) {
            diffs.add(prefix + ": Class differs, expected " + BeanComparisonError.buildSummary(expected, true) + " but was " + BeanComparisonError.buildSummary(actual, true));
            return;
        }
        if (expected instanceof Bean) {
            for (MetaProperty<?> prop : ((Bean)expected).metaBean().metaPropertyIterable()) {
                BeanComparisonError.buildMessage(diffs, prefix + '.' + prop.name(), prop.get((Bean)expected), prop.get((Bean)actual));
            }
            return;
        }
        if (!JodaBeanUtils.equal(expected, actual)) {
            diffs.add(prefix + ": Content differs, expected " + BeanComparisonError.buildSummary(expected, true) + " but was " + BeanComparisonError.buildSummary(actual, false));
            return;
        }
    }

    private static String buildSummary(Object obj, boolean includeType) {
        String type = obj.getClass().getSimpleName();
        String toStr = obj.toString();
        if (toStr.length() > 60) {
            toStr = toStr.substring(0, 57) + "...";
        }
        return (includeType ? type + " " : "") + "<" + toStr + ">";
    }

    public Bean getExpected() {
        return this.expected;
    }

    public Bean getActual() {
        return this.actual;
    }
}

