/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.GeneratableProperty;
import org.joda.beans.gen.PropertyGen;

abstract class BuilderGen {
    BuilderGen() {
    }

    abstract List<String> generateField(String var1, GeneratableProperty var2);

    String generateType(GeneratableProperty prop) {
        return prop.getType();
    }

    static class NoBuilderGen
    extends BuilderGen {
        static final BuilderGen INSTANCE = new NoBuilderGen();

        NoBuilderGen() {
        }

        @Override
        List<String> generateField(String indent, GeneratableProperty prop) {
            return Collections.emptyList();
        }
    }

    static class SimpleBuilderGen
    extends BuilderGen {
        private final String type;

        SimpleBuilderGen(String type) {
            this.type = type;
        }

        @Override
        List<String> generateField(String indent, GeneratableProperty prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + ";");
            return list;
        }

        @Override
        String generateType(GeneratableProperty prop) {
            return this.type.replace("<>", prop.getTypeGenerics());
        }
    }

    static class PatternBuilderGen
    extends BuilderGen {
        private final String type;
        private final String init;

        PatternBuilderGen(String type, String init) {
            this.type = type;
            this.init = init;
        }

        @Override
        List<String> generateField(String indent, GeneratableProperty prop) {
            ArrayList<String> list = new ArrayList<String>();
            if (prop.isNotNull()) {
                String init = this.init;
                init = init.replace("<>", PropertyGen.resolveWildcard(prop.getTypeGenerics()));
                list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + " = " + init + ";");
            } else {
                list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + ";");
            }
            return list;
        }

        @Override
        String generateType(GeneratableProperty prop) {
            return this.type.replace("<>", prop.getTypeGenerics());
        }
    }
}

