/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import org.joda.beans.Bean;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;

public final class BasicProperty<P>
implements Property<P> {
    private final Bean bean;
    private final MetaProperty<P> metaProperty;

    public static <P> BasicProperty<P> of(Bean bean, MetaProperty<P> metaProperty) {
        return new BasicProperty<P>(bean, metaProperty);
    }

    private BasicProperty(Bean bean, MetaProperty<P> metaProperty) {
        if (bean == null) {
            throw new NullPointerException("Bean must not be null");
        }
        if (metaProperty == null) {
            throw new NullPointerException("MetaProperty must not be null");
        }
        this.bean = bean;
        this.metaProperty = metaProperty;
    }

    @Override
    public <B extends Bean> B bean() {
        return (B)this.bean;
    }

    @Override
    public MetaProperty<P> metaProperty() {
        return this.metaProperty;
    }

    @Override
    public String name() {
        return this.metaProperty.name();
    }

    @Override
    public P get() {
        return this.metaProperty.get(this.bean);
    }

    @Override
    public void set(Object value) {
        this.metaProperty.set(this.bean, value);
    }

    @Override
    public P put(Object value) {
        return this.metaProperty.put(this.bean, value);
    }

    @Override
    public boolean equals(Object obj) {
        Property other;
        if (obj == this) {
            return true;
        }
        if (obj instanceof Property && ((Object)this.metaProperty).equals((other = (Property)obj).metaProperty())) {
            P a = this.get();
            Object b = other.get();
            return a == null ? b == null : a.equals(b);
        }
        return false;
    }

    @Override
    public int hashCode() {
        P value = this.get();
        return ((Object)this.metaProperty).hashCode() ^ (value == null ? 0 : value.hashCode());
    }

    public String toString() {
        return this.metaProperty + "=" + this.get();
    }
}

