/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.light;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyDefinition;
import org.joda.beans.PropertyMap;
import org.joda.beans.impl.BasicPropertyMap;
import org.joda.beans.impl.light.LightBeanBuilder;
import org.joda.beans.impl.light.LightMetaProperty;

public final class LightMetaBean<T extends Bean>
implements MetaBean {
    private final Class<? extends Bean> beanType;
    private final Map<String, MetaProperty<?>> metaPropertyMap;
    private final Constructor<T> constructor;
    private final Object[] constructionData;

    public static <B extends Bean> LightMetaBean<B> of(Class<B> beanClass) {
        return new LightMetaBean<B>(beanClass);
    }

    private LightMetaBean(Class<T> beanType) {
        if (beanType == null) {
            throw new NullPointerException("Bean class must not be null");
        }
        this.beanType = beanType;
        HashMap map = new HashMap();
        Field[] fields = beanType.getDeclaredFields();
        ArrayList propertyTypes = new ArrayList();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(PropertyDefinition.class) == null) continue;
            PropertyDefinition pdef = field.getAnnotation(PropertyDefinition.class);
            String name = field.getName();
            if (pdef.get().equals("field")) {
                map.put(name, LightMetaProperty.of(this, field, name, propertyTypes.size()));
                propertyTypes.add(field.getType());
                continue;
            }
            if (pdef.get().equals("")) continue;
            String getterName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Method method = null;
            if (field.getType() == Boolean.TYPE) {
                method = LightMetaBean.findMethod(beanType, "is" + name.substring(0, 1).toUpperCase() + name.substring(1));
            }
            if (method == null && (method = LightMetaBean.findMethod(beanType, getterName)) == null) {
                throw new IllegalArgumentException("Unable to find property getter: " + beanType.getSimpleName() + "." + getterName + "()");
            }
            method.setAccessible(true);
            map.put(name, LightMetaProperty.of(this, field, method, name, propertyTypes.size()));
            propertyTypes.add(field.getType());
        }
        this.metaPropertyMap = Collections.unmodifiableMap(map);
        this.constructor = LightMetaBean.findConstructor(beanType, propertyTypes);
        this.constructionData = LightMetaBean.buildConstructionData(this.constructor);
    }

    private static Method findMethod(Class<? extends Bean> beanType, String getterName) {
        try {
            return beanType.getDeclaredMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                return beanType.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
    }

    private static <T extends Bean> Constructor<T> findConstructor(Class<T> beanType, List<Class<?>> propertyTypes) {
        Class[] types = propertyTypes.toArray(new Class[propertyTypes.size()]);
        try {
            Constructor<T> con = beanType.getDeclaredConstructor(types);
            con.setAccessible(true);
            return con;
        }
        catch (NoSuchMethodException ex) {
            Constructor<?>[] cons = beanType.getDeclaredConstructors();
            Constructor<?> match = null;
            for (int i = 0; i < cons.length; ++i) {
                Constructor<?> con = cons[i];
                Class<?>[] conTypes = con.getParameterTypes();
                if (conTypes.length != types.length) continue;
                for (int j = 0; j < types.length && conTypes[j].isAssignableFrom(types[j]); ++j) {
                }
                if (match != null) {
                    throw new UnsupportedOperationException("Unable to find constructor: More than one matches");
                }
                match = con;
            }
            if (match == null) {
                throw new UnsupportedOperationException("Unable to find constructor: " + beanType.getSimpleName(), ex);
            }
            match.setAccessible(true);
            return match;
        }
    }

    private static Object[] buildConstructionData(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == Boolean.TYPE) {
                args[i] = false;
                continue;
            }
            if (parameterTypes[i] == Integer.TYPE) {
                args[i] = 0;
                continue;
            }
            if (parameterTypes[i] == Long.TYPE) {
                args[i] = 0L;
                continue;
            }
            if (parameterTypes[i] == Short.TYPE) {
                args[i] = (short)0;
                continue;
            }
            if (parameterTypes[i] == Byte.TYPE) {
                args[i] = (byte)0;
                continue;
            }
            if (parameterTypes[i] == Float.TYPE) {
                args[i] = Float.valueOf(0.0f);
                continue;
            }
            if (parameterTypes[i] == Double.TYPE) {
                args[i] = 0.0;
                continue;
            }
            if (parameterTypes[i] != Character.TYPE) continue;
            args[i] = Character.valueOf('\u0000');
        }
        return args;
    }

    T build(Object[] args) {
        try {
            return (T)((Bean)this.constructor.newInstance(args));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Bean cannot be created: " + this.beanName() + " from " + args, ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName() + " from " + args, ex);
        }
        catch (InstantiationException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName() + " from " + args, ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }

    public BeanBuilder<T> builder() {
        return new LightBeanBuilder(this, (Object[])this.constructionData.clone());
    }

    @Override
    public PropertyMap createPropertyMap(Bean bean) {
        return BasicPropertyMap.of(bean);
    }

    @Override
    public String beanName() {
        return this.beanType.getName();
    }

    @Override
    public Class<? extends Bean> beanType() {
        return this.beanType;
    }

    @Override
    public int metaPropertyCount() {
        return this.metaPropertyMap.size();
    }

    @Override
    public boolean metaPropertyExists(String propertyName) {
        return this.metaPropertyMap.containsKey(propertyName);
    }

    @Override
    public <R> MetaProperty<R> metaProperty(String propertyName) {
        MetaProperty<?> metaProperty = this.metaPropertyMap.get(propertyName);
        if (metaProperty == null) {
            throw new NoSuchElementException("Property not found: " + propertyName);
        }
        return metaProperty;
    }

    @Override
    public Iterable<MetaProperty<?>> metaPropertyIterable() {
        return this.metaPropertyMap.values();
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        return this.metaPropertyMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LightMetaBean) {
            LightMetaBean other = (LightMetaBean)obj;
            return this.beanType.equals(other.beanType);
        }
        return false;
    }

    public int hashCode() {
        return this.beanType.hashCode() + 3;
    }

    public String toString() {
        return "MetaBean:" + this.beanName();
    }
}

