/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.beans.ConstructorProperties;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.BeanDefinition;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.PropertyDefinition;
import org.joda.beans.gen.BeanData;
import org.joda.beans.gen.BeanGenConfig;
import org.joda.beans.gen.PropertyData;
import org.joda.beans.gen.PropertyGen;
import org.joda.beans.impl.direct.DirectBean;
import org.joda.beans.impl.direct.DirectBeanBuilder;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.light.LightMetaBean;

class BeanGen {
    static final int CONSTRUCTOR_NONE = 0;
    static final int CONSTRUCTOR_BY_BUILDER = 1;
    static final int CONSTRUCTOR_BY_ARGS = 2;
    private static final String LINE_SEPARATOR = "\t//-----------------------------------------------------------------------";
    private static final String LINE_SEPARATOR_INDENTED = "\t\t//-----------------------------------------------------------------------";
    private static final Set<String> PRIMITIVE_EQUALS = new HashSet<String>();
    private final File file;
    private final List<String> content;
    private final BeanGenConfig config;
    private final BeanData data;
    private final List<PropertyGen> properties;
    private final List<String> insertRegion;

    BeanGen(File file, List<String> content, BeanGenConfig config) {
        this.file = file;
        this.content = content;
        this.config = config;
        this.data = null;
        this.properties = null;
        this.insertRegion = null;
    }

    public BeanGen(File file, List<String> content, BeanGenConfig config, BeanData data, List<PropertyGen> properties, int autoStartIndex, int autoEndIndex) {
        this.file = file;
        this.content = content;
        this.config = config;
        this.data = data;
        this.properties = properties;
        this.insertRegion = content.subList(autoStartIndex + 1, autoEndIndex);
    }

    void process() {
        if (this.insertRegion != null) {
            this.data.ensureImport(BeanDefinition.class);
            if (this.properties.size() > 0) {
                this.data.ensureImport(PropertyDefinition.class);
            }
            this.removeOld();
            if (this.data.isRootClass() && this.data.isExtendsDirectBean()) {
                this.data.ensureImport(DirectBean.class);
            }
            this.insertRegion.add("\t///CLOVER:OFF");
            this.generateMeta();
            this.generateSerializationVersionId();
            this.generatePropertyChangeSupportField();
            this.generateHashCodeField();
            this.generateFactory();
            this.generateImmutableBuilderMethod();
            this.generateArgBasedConstructor();
            this.generateBuilderBasedConstructor();
            this.generateMetaBean();
            this.generatePropertyByName();
            this.generatePropertyNames();
            this.generateGettersSetters();
            this.generateSeparator();
            this.generateImmutableToBuilder();
            this.generateClone();
            this.generateEquals();
            this.generateHashCode();
            this.generateToString();
            this.generateMetaClass();
            this.generateBuilderClass();
            this.insertRegion.add("\t///CLOVER:ON");
            this.resolveImports();
            this.resolveIndents();
        }
    }

    private void resolveImports() {
        if (this.data.getNewImports().size() > 0) {
            int pos = this.data.getImportInsertLocation() + 1;
            for (String imp : this.data.getNewImports()) {
                this.content.add(pos++, "import " + imp + ";");
            }
        }
    }

    private void resolveIndents() {
        ListIterator<String> it = this.content.listIterator();
        while (it.hasNext()) {
            it.set(it.next().replace("\t", this.config.getIndent()));
        }
    }

    private void removeOld() {
        this.insertRegion.clear();
    }

    private void generateSeparator() {
        if (this.insertRegion.size() > 0 && this.insertRegion.get(this.insertRegion.size() - 1).equals(LINE_SEPARATOR)) {
            return;
        }
        this.insertRegion.add(LINE_SEPARATOR);
    }

    private void generateIndentedSeparator() {
        if (this.insertRegion.size() > 0 && this.insertRegion.get(this.insertRegion.size() - 1).equals(LINE_SEPARATOR_INDENTED)) {
            return;
        }
        this.insertRegion.add(LINE_SEPARATOR_INDENTED);
    }

    private void generateFactory() {
        if (this.data.isFactoryRequired()) {
            Object prop;
            int i;
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * Obtains an instance.");
            if (nonDerived.size() > 0) {
                if (this.data.isTypeGeneric()) {
                    for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                        this.insertRegion.add("\t * @param " + this.data.getTypeGenericName(j, true) + "  the type");
                    }
                }
                for (i = 0; i < nonDerived.size(); ++i) {
                    prop = nonDerived.get(i).getData();
                    this.insertRegion.add("\t * @param " + ((PropertyData)prop).getPropertyName() + "  the value of the property" + ((PropertyData)prop).getNotNullJavadoc());
                }
            }
            this.insertRegion.add("\t */");
            if (nonDerived.isEmpty()) {
                this.insertRegion.add("\tpublic static " + this.data.getTypeNoExtends() + " " + this.data.getFactoryName() + "() {");
                this.insertRegion.add("\t\treturn new " + this.data.getTypeNoExtends() + "();");
            } else {
                if (this.data.isTypeGeneric()) {
                    this.insertRegion.add("\tpublic static " + this.data.getTypeGeneric(true) + " " + this.data.getTypeNoExtends() + " " + this.data.getFactoryName() + "(");
                } else {
                    this.insertRegion.add("\tpublic static " + this.data.getTypeNoExtends() + " " + this.data.getFactoryName() + "(");
                }
                for (i = 0; i < nonDerived.size(); ++i) {
                    prop = nonDerived.get(i);
                    this.insertRegion.add("\t\t\t" + ((PropertyGen)prop).getBuilderType() + " " + ((PropertyGen)prop).getData().getPropertyName() + (i < nonDerived.size() - 1 ? "," : ") {"));
                }
                this.insertRegion.add("\t\treturn new " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + "(");
                for (i = 0; i < nonDerived.size(); ++i) {
                    this.insertRegion.add("\t\t\t" + nonDerived.get(i).generateBuilderFieldName() + (i < nonDerived.size() - 1 ? "," : ");"));
                }
            }
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateImmutableBuilderMethod() {
        if (this.data.isConstructable() && (this.data.isImmutable() && this.data.isEffectiveBuilderScopeVisible() || this.data.isMutable() && this.data.isBuilderScopeVisible())) {
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * Returns a builder used to create an instance of the bean.");
            if (this.data.isTypeGeneric()) {
                for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                    this.insertRegion.add("\t * @param " + this.data.getTypeGenericName(j, true) + "  the type");
                }
            }
            this.insertRegion.add("\t * @return the builder, not null");
            this.insertRegion.add("\t */");
            if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\t" + this.data.getEffectiveBuilderScope() + "static " + this.data.getTypeGeneric(true) + " " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder() {");
            } else {
                this.insertRegion.add("\t" + this.data.getEffectiveBuilderScope() + "static " + this.data.getTypeRaw() + ".Builder builder() {");
            }
            this.insertRegion.add("\t\treturn new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + "();");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateBuilderBasedConstructor() {
        if (this.data.getConstructorStyle() == 1 && this.data.getImmutableConstructor() == 0 && (this.data.isMutable() && this.data.isBuilderScopeVisible() || this.data.isImmutable())) {
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            String scope = this.data.isTypeFinal() ? "private" : "protected";
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * Restricted constructor.");
            this.insertRegion.add("\t * @param builder  the builder to copy from, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\t" + scope + " " + this.data.getTypeRaw() + "(" + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder) {");
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\tsuper(builder);");
            }
            for (PropertyGen prop : this.properties) {
                if (!prop.getData().isValidated()) continue;
                this.insertRegion.add("\t\t" + prop.getData().getValidationMethodName() + "(builder." + prop.generateBuilderFieldName() + ", \"" + prop.getData().getPropertyName() + "\");");
            }
            if (this.data.isImmutable()) {
                for (int i = 0; i < nonDerived.size(); ++i) {
                    this.insertRegion.addAll(nonDerived.get(i).generateConstructorAssign("builder."));
                }
            } else {
                for (int i = 0; i < nonDerived.size(); ++i) {
                    PropertyGen propGen = nonDerived.get(i);
                    PropertyData prop = propGen.getData();
                    if (prop.isCollectionType()) {
                        if (prop.isNotNull()) {
                            this.insertRegion.add("\t\tthis." + prop.getPropertyName() + ".addAll(builder." + propGen.generateBuilderFieldName() + ");");
                            continue;
                        }
                        this.insertRegion.add("\t\tthis." + prop.getPropertyName() + " = builder." + propGen.generateBuilderFieldName() + ";");
                        continue;
                    }
                    if (prop.isMapType()) {
                        if (prop.isNotNull()) {
                            this.insertRegion.add("\t\tthis." + prop.getPropertyName() + ".putAll(builder." + propGen.generateBuilderFieldName() + ");");
                            continue;
                        }
                        this.insertRegion.add("\t\tthis." + prop.getPropertyName() + " = builder." + propGen.generateBuilderFieldName() + ";");
                        continue;
                    }
                    this.insertRegion.add("\t\tthis." + prop.getPropertyName() + " = builder." + propGen.generateBuilderFieldName() + ";");
                }
            }
            if (this.data.getImmutableValidator() != null) {
                this.insertRegion.add("\t\t" + this.data.getImmutableValidator() + "();");
            }
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateArgBasedConstructor() {
        if (this.data.getConstructorStyle() == 2 && this.data.getImmutableConstructor() == 0 && (this.data.isMutable() && (this.data.isBuilderScopeVisible() || this.data.isBeanStyleLight()) || this.data.isImmutable())) {
            String scope = this.data.getEffectiveConstructorScope();
            boolean generateAnnotation = this.data.isConstructorPropertiesAnnotation();
            boolean generateJavadoc = !"private ".equals(scope);
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            if (nonDerived.size() == 0) {
                if (generateJavadoc) {
                    this.insertRegion.add("\t/**");
                    this.insertRegion.add("\t * Creates an instance.");
                    this.insertRegion.add("\t */");
                }
                if (generateAnnotation) {
                    this.data.ensureImport(ConstructorProperties.class);
                    this.insertRegion.add("\t@ConstructorProperties({})");
                }
                this.insertRegion.add("\t" + scope + this.data.getTypeRaw() + "() {");
            } else {
                int i;
                if (generateJavadoc) {
                    this.insertRegion.add("\t/**");
                    this.insertRegion.add("\t * Creates an instance.");
                    for (i = 0; i < nonDerived.size(); ++i) {
                        PropertyData prop = nonDerived.get(i).getData();
                        this.insertRegion.add("\t * @param " + prop.getPropertyName() + "  the value of the property" + prop.getNotNullJavadoc());
                    }
                    this.insertRegion.add("\t */");
                }
                if (generateAnnotation) {
                    this.data.ensureImport(ConstructorProperties.class);
                    StringBuilder buf = new StringBuilder();
                    for (int i2 = 0; i2 < nonDerived.size(); ++i2) {
                        if (i2 > 0) {
                            buf.append(", ");
                        }
                        buf.append('\"').append(nonDerived.get(i2).getData().getPropertyName()).append('\"');
                    }
                    this.insertRegion.add("\t@ConstructorProperties({" + buf.toString() + "})");
                }
                this.insertRegion.add("\t" + scope + this.data.getTypeRaw() + "(");
                for (i = 0; i < nonDerived.size(); ++i) {
                    PropertyGen prop = nonDerived.get(i);
                    this.insertRegion.add("\t\t\t" + prop.getBuilderType() + " " + prop.getData().getPropertyName() + (i < nonDerived.size() - 1 ? "," : ") {"));
                }
                if (!this.data.isMutable() || !this.data.isBeanStyleLight()) {
                    for (PropertyGen prop : this.properties) {
                        if (!prop.getData().isValidated()) continue;
                        this.insertRegion.add("\t\t" + prop.getData().getValidationMethodName() + "(" + prop.getData().getPropertyName() + ", \"" + prop.getData().getPropertyName() + "\");");
                    }
                }
                for (int i3 = 0; i3 < nonDerived.size(); ++i3) {
                    PropertyGen prop = nonDerived.get(i3);
                    if (this.data.isMutable() && this.data.isBeanStyleLight()) {
                        String generateSetInvoke = prop.getData().getSetterGen().generateSetInvoke(prop.getData(), prop.getData().getPropertyName());
                        this.insertRegion.add("\t\t" + generateSetInvoke + ";");
                        continue;
                    }
                    this.insertRegion.addAll(prop.generateConstructorAssign(""));
                }
            }
            if (this.data.getImmutableValidator() != null) {
                this.insertRegion.add("\t\t" + this.data.getImmutableValidator() + "();");
            }
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateMeta() {
        if (this.data.isBeanStyleLight()) {
            this.data.ensureImport(MetaBean.class);
            this.data.ensureImport(LightMetaBean.class);
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tprivate static MetaBean META_BEAN = LightMetaBean.of(" + this.data.getTypeRaw() + ".class);");
            this.insertRegion.add("");
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.insertRegion.add("\t * @return the meta-bean, not null");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tpublic static MetaBean meta() {");
            this.insertRegion.add("\t\treturn META_BEAN;");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
            this.insertRegion.add("\tstatic {");
            this.insertRegion.add("\t\tJodaBeanUtils.registerMetaBean(META_BEAN);");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        } else {
            this.data.ensureImport(JodaBeanUtils.class);
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.insertRegion.add("\t * @return the meta-bean, not null");
            if (this.data.isMetaScopePrivate()) {
                this.data.ensureImport(MetaBean.class);
                this.insertRegion.add("\t */");
                this.insertRegion.add("\tpublic static MetaBean meta() {");
            } else if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\t */");
                this.insertRegion.add("\t@SuppressWarnings(\"rawtypes\")");
                this.insertRegion.add("\tpublic static " + this.data.getTypeRaw() + ".Meta meta() {");
            } else {
                this.insertRegion.add("\t */");
                this.insertRegion.add("\tpublic static " + this.data.getTypeRaw() + ".Meta meta() {");
            }
            this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            this.insertRegion.add("\t}");
            if (this.data.isTypeGeneric()) {
                this.generateMetaForGenericType();
            }
            this.insertRegion.add("");
            this.insertRegion.add("\tstatic {");
            this.insertRegion.add("\t\tJodaBeanUtils.registerMetaBean(" + this.data.getTypeRaw() + ".Meta.INSTANCE);");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateMetaForGenericType() {
        this.insertRegion.add("");
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.getTypeGenericCount() == 1) {
            this.insertRegion.add("\t * @param <R>  the bean's generic type");
            this.insertRegion.add("\t * @param cls  the bean's generic type");
        } else if (this.data.getTypeGenericCount() == 2) {
            this.insertRegion.add("\t * @param <R>  the first generic type");
            this.insertRegion.add("\t * @param <S>  the second generic type");
            this.insertRegion.add("\t * @param cls1  the first generic type");
            this.insertRegion.add("\t * @param cls2  the second generic type");
        } else if (this.data.getTypeGenericCount() == 3) {
            this.insertRegion.add("\t * @param <R>  the first generic type");
            this.insertRegion.add("\t * @param <S>  the second generic type");
            this.insertRegion.add("\t * @param <T>  the second generic type");
            this.insertRegion.add("\t * @param cls1  the first generic type");
            this.insertRegion.add("\t * @param cls2  the second generic type");
            this.insertRegion.add("\t * @param cls3  the third generic type");
        }
        this.insertRegion.add("\t * @return the meta-bean, not null");
        this.insertRegion.add("\t */");
        this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
        String[] typeNames = new String[]{"R", "S", "T"};
        if (this.data.getTypeGenericCount() == 1) {
            this.insertRegion.add("\tpublic static <R" + this.data.getTypeGenericExtends(0, typeNames) + "> " + this.data.getTypeRaw() + ".Meta<R> meta" + this.data.getTypeRaw() + "(Class<R> cls) {");
        } else if (this.data.getTypeGenericCount() == 2) {
            this.insertRegion.add("\tpublic static <R" + this.data.getTypeGenericExtends(0, typeNames) + ", S" + this.data.getTypeGenericExtends(1, typeNames) + "> " + this.data.getTypeRaw() + ".Meta<R, S> meta" + this.data.getTypeRaw() + "(Class<R> cls1, Class<S> cls2) {");
        } else if (this.data.getTypeGenericCount() == 3) {
            this.insertRegion.add("\tpublic static <R" + this.data.getTypeGenericExtends(0, typeNames) + ", S" + this.data.getTypeGenericExtends(1, typeNames) + ", T" + this.data.getTypeGenericExtends(2, typeNames) + "> " + this.data.getTypeRaw() + ".Meta<R, S, T> meta" + this.data.getTypeRaw() + "(Class<R> cls1, Class<S> cls2, Class<T> cls3) {");
        }
        this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
        this.insertRegion.add("\t}");
    }

    private void generateSerializationVersionId() {
        if (this.data.isSerializable() && !this.data.isManualSerializationId()) {
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The serialization version id.");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tprivate static final long serialVersionUID = 1L;");
            this.insertRegion.add("");
        }
    }

    private void generatePropertyChangeSupportField() {
        if (this.data.isPropertyChangeSupport()) {
            this.data.ensureImport(PropertyChangeSupport.class);
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The property change support field.");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tprivate PropertyChangeSupport " + this.config.getPrefix() + "propertyChangeSupport = new PropertyChangeSupport(this);");
            this.insertRegion.add("");
        }
    }

    private void generateHashCodeField() {
        if (this.data.isCacheHashCode()) {
            this.insertRegion.add("\t/**");
            this.insertRegion.add("\t * The cached hash code, using the racy single-check idiom.");
            this.insertRegion.add("\t */");
            this.insertRegion.add("\tprivate int " + this.config.getPrefix() + "cachedHashCode;");
            this.insertRegion.add("");
        }
    }

    private void generateMetaBean() {
        if (this.data.isMetaScopePrivate()) {
            this.data.ensureImport(MetaBean.class);
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic MetaBean metaBean() {");
            if (this.data.isBeanStyleLight()) {
                this.insertRegion.add("\t\treturn META_BEAN;");
            } else {
                this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            }
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        } else {
            if (this.data.isTypeGeneric()) {
                this.insertRegion.add("\t@SuppressWarnings(\"unchecked\")");
            }
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic " + this.data.getTypeRaw() + ".Meta" + this.data.getTypeGenericName(true) + " metaBean() {");
            this.insertRegion.add("\t\treturn " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateGettersSetters() {
        for (PropertyGen prop : this.properties) {
            this.generateSeparator();
            this.insertRegion.addAll(prop.generateGetter());
            if (this.data.isMutable()) {
                this.insertRegion.addAll(prop.generateSetter());
            }
            if (!this.data.isBeanStyleGenerateProperties()) continue;
            this.insertRegion.addAll(prop.generateProperty());
        }
    }

    private void generatePropertyByName() {
        if (this.data.isRootClass() && !this.data.isExtendsDirectBean()) {
            this.data.ensureImport(Property.class);
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic <R> Property<R> property(String propertyName) {");
            this.insertRegion.add("\t\treturn metaBean().<R>metaProperty(propertyName).createProperty(this);");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generatePropertyNames() {
        if (this.data.isRootClass() && !this.data.isExtendsDirectBean()) {
            this.data.ensureImport(Set.class);
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic Set<String> propertyNames() {");
            this.insertRegion.add("\t\treturn metaBean().metaPropertyMap().keySet();");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
        }
    }

    private void generateImmutableToBuilder() {
        if (this.data.isImmutable() && this.data.isEffectiveBuilderScopeVisible()) {
            if (this.data.isConstructable()) {
                List<PropertyGen> nonDerived = this.nonDerivedProperties();
                if (nonDerived.size() > 0) {
                    this.insertRegion.add("\t/**");
                    this.insertRegion.add("\t * Returns a builder that allows this bean to be mutated.");
                    this.insertRegion.add("\t * @return the mutable builder, not null");
                    this.insertRegion.add("\t */");
                    if (!this.data.isRootClass()) {
                        this.insertRegion.add("\t@Override");
                    }
                    this.insertRegion.add("\t" + this.data.getEffectiveBuilderScope() + "Builder" + this.data.getTypeGenericName(true) + " toBuilder() {");
                    this.insertRegion.add("\t\treturn new Builder" + this.data.getTypeGenericName(true) + "(this);");
                    this.insertRegion.add("\t}");
                    this.insertRegion.add("");
                }
            } else {
                this.insertRegion.add("\t/**");
                this.insertRegion.add("\t * Returns a builder that allows this bean to be mutated.");
                this.insertRegion.add("\t * @return the mutable builder, not null");
                this.insertRegion.add("\t */");
                if (!this.data.isRootClass()) {
                    this.insertRegion.add("\t@Override");
                }
                this.insertRegion.add("\tpublic abstract Builder" + this.data.getTypeGenericName(true) + " toBuilder();");
                this.insertRegion.add("");
            }
        }
    }

    private void generateClone() {
        if (this.data.isSkipCloneGeneration() || this.data.isManualClone() || !this.data.isRootClass() && !this.data.isConstructable()) {
            return;
        }
        this.insertRegion.add("\t@Override");
        if (this.data.isImmutable()) {
            this.insertRegion.add("\tpublic " + this.data.getTypeNoExtends() + " clone() {");
            this.insertRegion.add("\t\treturn this;");
        } else {
            this.data.ensureImport(JodaBeanUtils.class);
            this.insertRegion.add("\tpublic " + this.data.getTypeNoExtends() + " clone() {");
            this.insertRegion.add("\t\treturn JodaBeanUtils.cloneAlways(this);");
        }
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateEquals() {
        if (this.data.isManualEqualsHashCode()) {
            return;
        }
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic boolean equals(Object obj) {");
        this.insertRegion.add("\t\tif (obj == this) {");
        this.insertRegion.add("\t\t\treturn true;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\tif (obj != null && obj.getClass() == this.getClass()) {");
        List<PropertyGen> nonDerived = this.nonDerivedEqualsHashCodeProperties();
        if (nonDerived.size() == 0) {
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\t\treturn super.equals(obj);");
            } else {
                this.insertRegion.add("\t\t\treturn true;");
            }
        } else {
            this.insertRegion.add("\t\t\t" + this.data.getTypeWildcard() + " other = (" + this.data.getTypeWildcard() + ") obj;");
            for (int i = 0; i < nonDerived.size(); ++i) {
                PropertyGen prop = nonDerived.get(i);
                String getter = this.equalsHashCodeFieldAccessor(prop);
                String equals = "JodaBeanUtils.equal(" + getter + ", other." + getter + ")";
                if (PRIMITIVE_EQUALS.contains(prop.getData().getType())) {
                    equals = "(" + getter + " == other." + getter + ")";
                }
                this.insertRegion.add((i == 0 ? "\t\t\treturn " : "\t\t\t\t\t") + equals + (this.data.isSubClass() || i < nonDerived.size() - 1 ? " &&" : ";"));
            }
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\t\t\t\tsuper.equals(obj);");
            }
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\treturn false;");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateHashCode() {
        if (this.data.isManualEqualsHashCode()) {
            return;
        }
        this.data.ensureImport(JodaBeanUtils.class);
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic int hashCode() {");
        if (this.data.isCacheHashCode()) {
            this.insertRegion.add("\t\tint hash = " + this.config.getPrefix() + "cachedHashCode;");
            this.insertRegion.add("\t\tif (hash == 0) {");
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\t\thash = 7;");
            } else {
                this.insertRegion.add("\t\t\thash = getClass().hashCode();");
            }
            this.generateHashCodeContent("\t\t\t");
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\t\thash = hash ^ super.hashCode();");
            }
            this.insertRegion.add("\t\t\t" + this.config.getPrefix() + "cachedHashCode = hash;");
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("\t\treturn hash;");
        } else {
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\tint hash = 7;");
            } else {
                this.insertRegion.add("\t\tint hash = getClass().hashCode();");
            }
            this.generateHashCodeContent("\t\t");
            if (this.data.isSubClass()) {
                this.insertRegion.add("\t\treturn hash ^ super.hashCode();");
            } else {
                this.insertRegion.add("\t\treturn hash;");
            }
        }
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateHashCodeContent(String indent) {
        List<PropertyGen> nonDerived = this.nonDerivedEqualsHashCodeProperties();
        for (int i = 0; i < nonDerived.size(); ++i) {
            PropertyGen prop = nonDerived.get(i);
            String getter = this.equalsHashCodeFieldAccessor(prop);
            this.insertRegion.add(indent + "hash = hash * 31 + JodaBeanUtils.hashCode(" + getter + ");");
        }
    }

    private String equalsHashCodeFieldAccessor(PropertyGen prop) {
        if (prop.getData().getEqualsHashCodeStyle().equals("field")) {
            return prop.getData().getFieldName();
        }
        return prop.getData().getGetterGen().generateGetInvoke(prop.getData());
    }

    private void generateToString() {
        if (this.data.isManualToStringCode()) {
            return;
        }
        List<PropertyGen> props = this.toStringProperties();
        if (this.data.isRootClass() && this.data.isTypeFinal()) {
            this.insertRegion.add("\t@Override");
            this.insertRegion.add("\tpublic String toString() {");
            this.insertRegion.add("\t\tStringBuilder buf = new StringBuilder(" + (props.size() * 32 + 32) + ");");
            this.insertRegion.add("\t\tbuf.append(\"" + this.data.getTypeRaw() + "{\");");
            for (int i = 0; i < props.size(); ++i) {
                PropertyGen prop = props.get(i);
                String getter = this.toStringFieldAccessor(prop);
                if (i < props.size() - 1) {
                    this.insertRegion.add("\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(" + getter + ").append(',').append(' ');");
                    continue;
                }
                this.insertRegion.add("\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + "));");
            }
            this.insertRegion.add("\t\tbuf.append('}');");
            this.insertRegion.add("\t\treturn buf.toString();");
            this.insertRegion.add("\t}");
            this.insertRegion.add("");
            return;
        }
        this.insertRegion.add("\t@Override");
        this.insertRegion.add("\tpublic String toString() {");
        this.insertRegion.add("\t\tStringBuilder buf = new StringBuilder(" + (props.size() * 32 + 32) + ");");
        this.insertRegion.add("\t\tbuf.append(\"" + this.data.getTypeRaw() + "{\");");
        this.insertRegion.add("\t\tint len = buf.length();");
        this.insertRegion.add("\t\ttoString(buf);");
        this.insertRegion.add("\t\tif (buf.length() > len) {");
        this.insertRegion.add("\t\t\tbuf.setLength(buf.length() - 2);");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("\t\tbuf.append('}');");
        this.insertRegion.add("\t\treturn buf.toString();");
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t@Override");
        }
        this.insertRegion.add("\tprotected void toString(StringBuilder buf) {");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\tsuper.toString(buf);");
        }
        for (int i = 0; i < props.size(); ++i) {
            PropertyGen prop = props.get(i);
            String getter = this.toStringFieldAccessor(prop);
            this.insertRegion.add("\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + ")).append(',').append(' ');");
        }
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private String toStringFieldAccessor(PropertyGen prop) {
        if (prop.getData().isDerived()) {
            return prop.getData().getGetterGen().generateGetInvoke(prop.getData());
        }
        if (prop.getData().getToStringStyle().equals("field")) {
            return prop.getData().getFieldName();
        }
        return prop.getData().getGetterGen().generateGetInvoke(prop.getData());
    }

    private void generateMetaClass() {
        String finalType;
        String superMeta;
        if (this.data.isBeanStyleLight()) {
            return;
        }
        this.generateSeparator();
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.isTypeGeneric()) {
            for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                this.insertRegion.add("\t * @param " + this.data.getTypeGenericName(j, true) + "  the type");
            }
        }
        this.insertRegion.add("\t */");
        if (this.data.isSubClass()) {
            superMeta = this.data.getSuperTypeRaw() + ".Meta" + this.data.getSuperTypeGeneric(true);
        } else {
            this.data.ensureImport(DirectMetaBean.class);
            superMeta = "DirectMetaBean";
        }
        String string = finalType = this.data.isTypeFinal() ? "final " : "";
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t" + this.data.getEffectiveMetaScope() + "static " + finalType + "class Meta" + this.data.getTypeGeneric(true) + " extends " + superMeta + " {");
        } else {
            this.insertRegion.add("\t" + this.data.getEffectiveMetaScope() + "static " + finalType + "class Meta extends " + superMeta + " {");
        }
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * The singleton instance of the meta-bean.");
        this.insertRegion.add("\t\t */");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t@SuppressWarnings(\"rawtypes\")");
        }
        this.insertRegion.add("\t\tstatic final Meta INSTANCE = new Meta();");
        this.insertRegion.add("");
        this.generateMetaPropertyConstants();
        this.generateMetaPropertyMapSetup();
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * Restricted constructor.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\t" + this.data.getNestedClassConstructorScope() + " Meta() {");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        this.generateMetaPropertyGet();
        this.generateMetaBuilder();
        this.generateMetaBeanType();
        this.generateMetaPropertyMap();
        this.generateIndentedSeparator();
        this.generateMetaPropertyMethods();
        this.generateIndentedSeparator();
        this.generateMetaGetPropertyValue();
        this.generateMetaSetPropertyValue();
        this.generateMetaValidate();
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyConstants() {
        for (PropertyGen prop : this.properties) {
            this.insertRegion.addAll(prop.generateMetaPropertyConstant());
        }
    }

    private void generateMetaPropertyMapSetup() {
        this.data.ensureImport(MetaProperty.class);
        this.data.ensureImport(DirectMetaPropertyMap.class);
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * The meta-properties.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\tprivate final Map<String, MetaProperty<?>> " + this.config.getPrefix() + "metaPropertyMap$ = new DirectMetaPropertyMap(");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\t\t\tthis, (DirectMetaPropertyMap) super.metaPropertyMap()" + (this.properties.size() == 0 ? ");" : ","));
        } else {
            this.insertRegion.add("\t\t\t\tthis, null" + (this.properties.size() == 0 ? ");" : ","));
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            String line = "\t\t\t\t\"" + this.properties.get(i).getData().getPropertyName() + "\"";
            line = line + (i + 1 == this.properties.size() ? ");" : ",");
            this.insertRegion.add(line);
        }
        this.insertRegion.add("");
    }

    private void generateMetaBuilder() {
        this.insertRegion.add("\t\t@Override");
        if (this.data.isImmutable() && !this.data.isEffectiveBuilderScopeVisible()) {
            this.data.ensureImport(BeanBuilder.class);
            this.insertRegion.add("\t\tpublic BeanBuilder<? extends " + this.data.getTypeNoExtends() + "> builder() {");
            if (this.data.isConstructable()) {
                this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + "();");
            } else {
                this.insertRegion.add("\t\t\tthrow new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
            }
        } else if (this.data.isImmutable() || this.data.isMutable() && this.data.isBuilderScopeVisible()) {
            this.insertRegion.add("\t\tpublic " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder() {");
            if (this.data.isConstructable()) {
                this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + "();");
            } else {
                this.insertRegion.add("\t\t\tthrow new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
            }
        } else {
            this.data.ensureImport(BeanBuilder.class);
            this.insertRegion.add("\t\tpublic BeanBuilder<? extends " + this.data.getTypeNoExtends() + "> builder() {");
            if (this.data.isConstructable()) {
                this.data.ensureImport(DirectBeanBuilder.class);
                this.insertRegion.add("\t\t\treturn new DirectBeanBuilder<" + this.data.getTypeNoExtends() + ">(new " + this.data.getTypeNoExtends() + "());");
            } else {
                this.insertRegion.add("\t\t\tthrow new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
            }
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaBeanType() {
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Class<? extends " + this.data.getTypeNoExtends() + "> beanType() {");
        if (this.data.isTypeGeneric()) {
            this.insertRegion.add("\t\t\treturn (Class) " + this.data.getTypeRaw() + ".class;");
        } else {
            this.insertRegion.add("\t\t\treturn " + this.data.getTypeNoExtends() + ".class;");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyGet() {
        if (this.properties.size() > 0) {
            this.data.ensureImport(MetaProperty.class);
            this.insertRegion.add("\t\t@Override");
            this.insertRegion.add("\t\tprotected MetaProperty<?> metaPropertyGet(String propertyName) {");
            this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen prop : this.properties) {
                this.insertRegion.addAll(prop.generateMetaPropertyGetCase());
            }
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t\treturn super.metaPropertyGet(propertyName);");
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
        }
    }

    private void generateMetaPropertyMap() {
        this.data.ensureImport(Map.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Map<String, MetaProperty<?>> metaPropertyMap() {");
        this.insertRegion.add("\t\t\treturn " + this.config.getPrefix() + "metaPropertyMap$;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaPropertyMethods() {
        if (this.data.isBeanStyleGenerateMetaProperties()) {
            for (PropertyGen prop : this.properties) {
                this.insertRegion.addAll(prop.generateMetaProperty());
            }
        }
    }

    private void generateMetaGetPropertyValue() {
        if (this.properties.size() == 0) {
            return;
        }
        this.data.ensureImport(Bean.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tprotected Object propertyGet(Bean bean, String propertyName, boolean quiet) {");
        this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
        for (PropertyGen prop : this.properties) {
            this.insertRegion.addAll(prop.generatePropertyGetCase());
        }
        this.insertRegion.add("\t\t\t}");
        this.insertRegion.add("\t\t\treturn super.propertyGet(bean, propertyName, quiet);");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaSetPropertyValue() {
        if (this.properties.size() == 0) {
            return;
        }
        this.data.ensureImport(Bean.class);
        if (this.data.isImmutable()) {
            this.insertRegion.add("\t\t@Override");
            this.insertRegion.add("\t\tprotected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {");
            this.insertRegion.add("\t\t\tmetaProperty(propertyName);");
            this.insertRegion.add("\t\t\tif (quiet) {");
            this.insertRegion.add("\t\t\t\treturn;");
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t\tthrow new UnsupportedOperationException(\"Property cannot be written: \" + propertyName);");
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
            return;
        }
        boolean generics = false;
        for (PropertyData propertyData : this.data.getProperties()) {
            generics |= propertyData.getStyle().isWritable() && (propertyData.isGeneric() && !propertyData.isGenericWildcardParamType() || this.data.isTypeGeneric());
        }
        if (generics) {
            this.insertRegion.add("\t\t@SuppressWarnings(\"unchecked\")");
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tprotected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {");
        this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
        for (PropertyGen propertyGen : this.properties) {
            this.insertRegion.addAll(propertyGen.generatePropertySetCase());
        }
        this.insertRegion.add("\t\t\t}");
        this.insertRegion.add("\t\t\tsuper.propertySet(bean, propertyName, newValue, quiet);");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateMetaValidate() {
        if (!this.data.isValidated() || this.data.isImmutable()) {
            return;
        }
        this.data.ensureImport(Bean.class);
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tprotected void validate(Bean bean) {");
        if (this.data.isValidated()) {
            for (PropertyGen prop : this.properties) {
                if (!prop.getData().isValidated()) continue;
                this.insertRegion.add("\t\t\t" + prop.getData().getValidationMethodName() + "(((" + this.data.getTypeWildcard() + ") bean)." + prop.getData().getFieldName() + ", \"" + prop.getData().getPropertyName() + "\");");
            }
        }
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\t\tsuper.validate(bean);");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderClass() {
        String superBuilder;
        if (this.data.isMutable() && !this.data.isBuilderScopeVisible() || this.data.isBeanStyleLight()) {
            return;
        }
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.generateSeparator();
        String finalType = this.data.isTypeFinal() ? "final " : "";
        this.insertRegion.add("\t/**");
        this.insertRegion.add("\t * The bean-builder for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.isTypeGeneric()) {
            for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                this.insertRegion.add("\t * @param " + this.data.getTypeGenericName(j, true) + "  the type");
            }
        }
        this.insertRegion.add("\t */");
        if (this.data.isSubClass()) {
            superBuilder = this.data.getSuperTypeRaw() + ".Builder" + this.data.getSuperTypeGeneric(true);
        } else {
            this.data.ensureImport(DirectFieldsBeanBuilder.class);
            superBuilder = "DirectFieldsBeanBuilder<" + this.data.getTypeNoExtends() + ">";
        }
        if (this.data.isConstructable()) {
            this.insertRegion.add("\t" + this.data.getEffectiveBuilderScope() + "static " + finalType + "class Builder" + this.data.getTypeGeneric(true) + " extends " + superBuilder + " {");
        } else {
            this.insertRegion.add("\t" + this.data.getEffectiveBuilderScope() + "abstract static " + finalType + "class Builder" + this.data.getTypeGeneric(true) + " extends " + superBuilder + " {");
        }
        if (nonDerived.size() > 0) {
            this.insertRegion.add("");
            this.generateBuilderProperties();
        }
        this.insertRegion.add("");
        this.generateBuilderConstructorNoArgs();
        this.generateBuilderConstructorCopy();
        this.generateIndentedSeparator();
        this.generateBuilderGet();
        this.generateBuilderSet();
        this.generateBuilderOtherSets();
        if (this.data.isConstructable()) {
            this.generateBuilderBuilder();
        }
        this.generateIndentedSeparator();
        this.generateBuilderPropertySetMethods();
        this.generateIndentedSeparator();
        this.generateBuilderToString();
        this.insertRegion.add("\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderConstructorNoArgs() {
        this.insertRegion.add("\t\t/**");
        this.insertRegion.add("\t\t * Restricted constructor.");
        this.insertRegion.add("\t\t */");
        this.insertRegion.add("\t\t" + this.data.getNestedClassConstructorScope() + " Builder() {");
        if (this.data.getImmutableDefaults() != null) {
            this.insertRegion.add("\t\t\t" + this.data.getImmutableDefaults() + "(this);");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderConstructorCopy() {
        List<PropertyGen> nonDerived;
        if (this.data.isEffectiveBuilderScopeVisible() && (nonDerived = this.nonDerivedProperties()).size() > 0) {
            this.insertRegion.add("\t\t/**");
            this.insertRegion.add("\t\t * Restricted copy constructor.");
            this.insertRegion.add("\t\t * @param beanToCopy  the bean to copy from, not null");
            this.insertRegion.add("\t\t */");
            this.insertRegion.add("\t\t" + this.data.getNestedClassConstructorScope() + " Builder(" + this.data.getTypeNoExtends() + " beanToCopy) {");
            for (int i = 0; i < nonDerived.size(); ++i) {
                this.insertRegion.addAll(nonDerived.get(i).generateBuilderConstructorAssign("beanToCopy"));
            }
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
        }
    }

    private void generateBuilderProperties() {
        for (PropertyGen prop : this.nonDerivedProperties()) {
            this.insertRegion.addAll(prop.generateBuilderField());
        }
    }

    private void generateBuilderGet() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Object get(String propertyName) {");
        if (nonDerived.size() > 0) {
            this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen prop : nonDerived) {
                this.insertRegion.addAll(prop.generateBuilderFieldGet());
            }
            this.insertRegion.add("\t\t\t\tdefault:");
            if (this.data.isRootClass()) {
                this.data.ensureImport(NoSuchElementException.class);
                this.insertRegion.add("\t\t\t\t\tthrow new NoSuchElementException(\"Unknown property: \" + propertyName);");
            } else {
                this.insertRegion.add("\t\t\t\t\treturn super.get(propertyName);");
            }
            this.insertRegion.add("\t\t\t}");
        } else {
            this.data.ensureImport(NoSuchElementException.class);
            this.insertRegion.add("\t\t\tthrow new NoSuchElementException(\"Unknown property: \" + propertyName);");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderSet() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        boolean generics = false;
        for (PropertyData propertyData : this.data.getProperties()) {
            generics |= propertyData.isGeneric() && !propertyData.isGenericWildcardParamType();
        }
        if (generics) {
            this.insertRegion.add("\t\t@SuppressWarnings(\"unchecked\")");
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Builder" + this.data.getTypeGenericName(true) + " set(String propertyName, Object newValue) {");
        if (nonDerived.size() > 0) {
            this.insertRegion.add("\t\t\tswitch (propertyName.hashCode()) {");
            for (PropertyGen propertyGen : nonDerived) {
                this.insertRegion.addAll(propertyGen.generateBuilderFieldSet());
            }
            this.insertRegion.add("\t\t\t\tdefault:");
            if (this.data.isRootClass()) {
                this.data.ensureImport(NoSuchElementException.class);
                this.insertRegion.add("\t\t\t\t\tthrow new NoSuchElementException(\"Unknown property: \" + propertyName);");
            } else {
                this.insertRegion.add("\t\t\t\t\tsuper.set(propertyName, newValue);");
                this.insertRegion.add("\t\t\t\t\tbreak;");
            }
            this.insertRegion.add("\t\t\t}");
            this.insertRegion.add("\t\t\treturn this;");
        } else {
            this.data.ensureImport(NoSuchElementException.class);
            this.insertRegion.add("\t\t\tthrow new NoSuchElementException(\"Unknown property: \" + propertyName);");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderOtherSets() {
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Builder" + this.data.getTypeGenericName(true) + " set(MetaProperty<?> property, Object value) {");
        this.insertRegion.add("\t\t\tsuper.set(property, value);");
        this.insertRegion.add("\t\t\treturn this;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Builder" + this.data.getTypeGenericName(true) + " setString(String propertyName, String value) {");
        if (this.data.isMetaScopePrivate()) {
            this.insertRegion.add("\t\t\tsetString(" + this.data.getTypeRaw() + ".Meta.INSTANCE.metaProperty(propertyName), value);");
        } else {
            this.insertRegion.add("\t\t\tsetString(meta().metaProperty(propertyName), value);");
        }
        this.insertRegion.add("\t\t\treturn this;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Builder" + this.data.getTypeGenericName(true) + " setString(MetaProperty<?> property, String value) {");
        this.insertRegion.add("\t\t\tsuper.setString(property, value);");
        this.insertRegion.add("\t\t\treturn this;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic Builder" + this.data.getTypeGenericName(true) + " setAll(Map<String, ? extends Object> propertyValueMap) {");
        this.insertRegion.add("\t\t\tsuper.setAll(propertyValueMap);");
        this.insertRegion.add("\t\t\treturn this;");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderBuilder() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + " build() {");
        if (this.data.getImmutablePreBuild() != null) {
            this.insertRegion.add("\t\t\t" + this.data.getImmutablePreBuild() + "(this);");
        }
        if (this.data.getConstructorStyle() == 2) {
            if (nonDerived.size() == 0) {
                this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + "();");
            } else {
                this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + "(");
                for (int i = 0; i < nonDerived.size(); ++i) {
                    this.insertRegion.add("\t\t\t\t\t" + nonDerived.get(i).generateBuilderFieldName() + (i < nonDerived.size() - 1 ? "," : ");"));
                }
            }
        } else if (this.data.getConstructorStyle() == 1) {
            this.insertRegion.add("\t\t\treturn new " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + "(this);");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    private void generateBuilderPropertySetMethods() {
        if (this.data.isEffectiveBuilderScopeVisible()) {
            for (PropertyGen prop : this.nonDerivedProperties()) {
                this.insertRegion.addAll(prop.generateBuilderSetMethod());
            }
        }
    }

    private void generateBuilderToString() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        if (this.data.isImmutable() && this.data.isTypeFinal()) {
            this.insertRegion.add("\t\t@Override");
            this.insertRegion.add("\t\tpublic String toString() {");
            if (nonDerived.size() == 0) {
                this.insertRegion.add("\t\t\treturn \"" + this.data.getTypeRaw() + ".Builder{}\";");
            } else {
                this.insertRegion.add("\t\t\tStringBuilder buf = new StringBuilder(" + (nonDerived.size() * 32 + 32) + ");");
                this.insertRegion.add("\t\t\tbuf.append(\"" + this.data.getTypeRaw() + ".Builder{\");");
                for (int i = 0; i < nonDerived.size(); ++i) {
                    PropertyGen prop = nonDerived.get(i);
                    String getter = nonDerived.get(i).generateBuilderFieldName();
                    String base = "\t\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + "))";
                    if (i < nonDerived.size() - 1) {
                        this.insertRegion.add(base + ".append(',').append(' ');");
                        continue;
                    }
                    this.insertRegion.add(base + ";");
                }
                this.insertRegion.add("\t\t\tbuf.append('}');");
                this.insertRegion.add("\t\t\treturn buf.toString();");
            }
            this.insertRegion.add("\t\t}");
            this.insertRegion.add("");
            return;
        }
        this.insertRegion.add("\t\t@Override");
        this.insertRegion.add("\t\tpublic String toString() {");
        this.insertRegion.add("\t\t\tStringBuilder buf = new StringBuilder(" + (nonDerived.size() * 32 + 32) + ");");
        this.insertRegion.add("\t\t\tbuf.append(\"" + this.data.getTypeRaw() + ".Builder{\");");
        this.insertRegion.add("\t\t\tint len = buf.length();");
        this.insertRegion.add("\t\t\ttoString(buf);");
        this.insertRegion.add("\t\t\tif (buf.length() > len) {");
        this.insertRegion.add("\t\t\t\tbuf.setLength(buf.length() - 2);");
        this.insertRegion.add("\t\t\t}");
        this.insertRegion.add("\t\t\tbuf.append('}');");
        this.insertRegion.add("\t\t\treturn buf.toString();");
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\t@Override");
        }
        this.insertRegion.add("\t\tprotected void toString(StringBuilder buf) {");
        if (this.data.isSubClass()) {
            this.insertRegion.add("\t\t\tsuper.toString(buf);");
        }
        for (int i = 0; i < nonDerived.size(); ++i) {
            PropertyGen prop = nonDerived.get(i);
            String getter = nonDerived.get(i).generateBuilderFieldName();
            this.insertRegion.add("\t\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + ")).append(',').append(' ');");
        }
        this.insertRegion.add("\t\t}");
        this.insertRegion.add("");
    }

    boolean isBean() {
        return this.data != null;
    }

    BeanData getData() {
        return this.data;
    }

    BeanGenConfig getConfig() {
        return this.config;
    }

    File getFile() {
        return this.file;
    }

    String getFieldPrefix() {
        return this.config.getPrefix();
    }

    private List<PropertyGen> nonDerivedProperties() {
        ArrayList<PropertyGen> nonDerived = new ArrayList<PropertyGen>();
        for (PropertyGen prop : this.properties) {
            if (prop.getData().isDerived()) continue;
            nonDerived.add(prop);
        }
        return nonDerived;
    }

    private List<PropertyGen> nonDerivedEqualsHashCodeProperties() {
        ArrayList<PropertyGen> nonDerived = new ArrayList<PropertyGen>();
        for (PropertyGen prop : this.properties) {
            if (prop.getData().isDerived() || prop.getData().getEqualsHashCodeStyle().equals("omit")) continue;
            nonDerived.add(prop);
        }
        return nonDerived;
    }

    private List<PropertyGen> toStringProperties() {
        ArrayList<PropertyGen> props = new ArrayList<PropertyGen>();
        for (PropertyGen prop : this.properties) {
            if ("omit".equals(prop.getData().getToStringStyle())) continue;
            props.add(prop);
        }
        return props;
    }

    static {
        PRIMITIVE_EQUALS.add("boolean");
        PRIMITIVE_EQUALS.add("char");
        PRIMITIVE_EQUALS.add("byte");
        PRIMITIVE_EQUALS.add("short");
        PRIMITIVE_EQUALS.add("int");
        PRIMITIVE_EQUALS.add("long");
    }
}

