/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.light;

import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.impl.light.LightMetaBean;
import org.joda.beans.impl.light.LightMetaProperty;

class LightBeanBuilder<B extends Bean>
implements BeanBuilder<B> {
    private final LightMetaBean<B> metaBean;
    private final Object[] data;

    LightBeanBuilder(LightMetaBean<B> metaBean, Object[] data) {
        this.metaBean = metaBean;
        this.data = data;
    }

    @Override
    public Object get(String propertyName) {
        return this.get(this.metaBean.metaProperty(propertyName));
    }

    @Override
    public Object get(MetaProperty<?> metaProperty) {
        return this.data[this.index(metaProperty)];
    }

    @Override
    public BeanBuilder<B> set(String propertyName, Object value) {
        return this.set(this.metaBean.metaProperty(propertyName), value);
    }

    @Override
    public BeanBuilder<B> set(MetaProperty<?> metaProperty, Object value) {
        this.data[this.index(metaProperty)] = value;
        return this;
    }

    @Override
    public BeanBuilder<B> setString(String propertyName, String value) {
        return this.setString(this.metaBean.metaProperty(propertyName), value);
    }

    @Override
    public BeanBuilder<B> setString(MetaProperty<?> metaProperty, String value) {
        Object object = JodaBeanUtils.stringConverter().convertFromString(metaProperty.propertyType(), value);
        return this.set(metaProperty, object);
    }

    @Override
    public BeanBuilder<B> setAll(Map<String, ? extends Object> propertyValueMap) {
        for (Map.Entry<String, ? extends Object> entry : propertyValueMap.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private int index(MetaProperty<?> metaProperty) {
        return ((LightMetaProperty)metaProperty).getConstructorIndex();
    }

    @Override
    public B build() {
        return this.metaBean.build(this.data);
    }

    public String toString() {
        return "BeanBuilder for " + this.metaBean.beanName();
    }
}

