/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyMap;
import org.joda.beans.impl.BasicBeanBuilder;
import org.joda.beans.impl.BasicPropertyMap;
import org.joda.beans.impl.reflection.ReflectiveMetaProperty;

public final class ReflectiveMetaBean
implements MetaBean {
    private final Class<? extends Bean> beanType;
    private final Map<String, MetaProperty<?>> metaPropertyMap;

    public static <B extends Bean> ReflectiveMetaBean of(Class<B> beanClass) {
        return new ReflectiveMetaBean(beanClass);
    }

    private ReflectiveMetaBean(Class<? extends Bean> beanType) {
        Field[] fields;
        if (beanType == null) {
            throw new NullPointerException("Bean class must not be null");
        }
        this.beanType = beanType;
        HashMap<String, MetaProperty> map = new HashMap<String, MetaProperty>();
        for (Field field : fields = beanType.getDeclaredFields()) {
            MetaProperty mp;
            if (!MetaProperty.class.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                mp = (MetaProperty)field.get(null);
                if (mp instanceof ReflectiveMetaProperty) {
                    ((ReflectiveMetaProperty)mp).setMetaBean(this);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("MetaProperty cannot be created: " + field.getName(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException("MetaProperty cannot be created: " + field.getName(), ex);
            }
            if (mp == null) {
                throw new UnsupportedOperationException("MetaProperty cannot be created: " + field.getName() + ": Value must not be null");
            }
            map.put(mp.name(), mp);
        }
        this.metaPropertyMap = Collections.unmodifiableMap(map);
    }

    public BeanBuilder<Bean> builder() {
        try {
            Bean bean = this.beanType.newInstance();
            return new BasicBeanBuilder<Bean>(bean);
        }
        catch (InstantiationException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Bean cannot be created: " + this.beanName(), ex);
        }
    }

    @Override
    public PropertyMap createPropertyMap(Bean bean) {
        return BasicPropertyMap.of(bean);
    }

    @Override
    public String beanName() {
        return this.beanType.getName();
    }

    @Override
    public Class<? extends Bean> beanType() {
        return this.beanType;
    }

    @Override
    public int metaPropertyCount() {
        return this.metaPropertyMap.size();
    }

    @Override
    public boolean metaPropertyExists(String propertyName) {
        return this.metaPropertyMap.containsKey(propertyName);
    }

    @Override
    public <R> MetaProperty<R> metaProperty(String propertyName) {
        MetaProperty<?> metaProperty = this.metaPropertyMap.get(propertyName);
        if (metaProperty == null) {
            throw new NoSuchElementException("Property not found: " + propertyName);
        }
        return metaProperty;
    }

    @Override
    public Iterable<MetaProperty<?>> metaPropertyIterable() {
        return this.metaPropertyMap.values();
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        return this.metaPropertyMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReflectiveMetaBean) {
            ReflectiveMetaBean other = (ReflectiveMetaBean)obj;
            return this.beanType.equals(other.beanType);
        }
        return false;
    }

    public int hashCode() {
        return this.beanType.hashCode() + 3;
    }

    public String toString() {
        return "MetaBean:" + this.beanName();
    }
}

