/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultiset;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.BeanIterator;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.collect.grid.DenseGrid;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.ImmutableGrid;
import org.joda.collect.grid.SparseGrid;
import org.joda.convert.StringConvert;

public final class JodaBeanUtils {
    private static final StringConvert converter = new StringConvert();

    private JodaBeanUtils() {
    }

    @Deprecated
    public static MetaBean metaBean(Class<?> cls) {
        return MetaBean.of(cls);
    }

    @Deprecated
    public static void registerMetaBean(MetaBean metaBean) {
        MetaBean.register(metaBean);
    }

    public static StringConvert stringConverter() {
        return converter;
    }

    public static boolean equal(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.getClass().isArray()) {
            return JodaBeanUtils.equalsArray(obj1, obj2);
        }
        return obj1.equals(obj2);
    }

    private static boolean equalsArray(Object obj1, Object obj2) {
        if (obj1 instanceof Object[] && obj2 instanceof Object[] && obj1.getClass() == obj2.getClass()) {
            return Arrays.deepEquals((Object[])obj1, (Object[])obj2);
        }
        if (obj1 instanceof int[] && obj2 instanceof int[]) {
            return Arrays.equals((int[])obj1, (int[])obj2);
        }
        if (obj1 instanceof long[] && obj2 instanceof long[]) {
            return Arrays.equals((long[])obj1, (long[])obj2);
        }
        if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
            return Arrays.equals((byte[])obj1, (byte[])obj2);
        }
        if (obj1 instanceof double[] && obj2 instanceof double[]) {
            return Arrays.equals((double[])obj1, (double[])obj2);
        }
        if (obj1 instanceof float[] && obj2 instanceof float[]) {
            return Arrays.equals((float[])obj1, (float[])obj2);
        }
        if (obj1 instanceof char[] && obj2 instanceof char[]) {
            return Arrays.equals((char[])obj1, (char[])obj2);
        }
        if (obj1 instanceof short[] && obj2 instanceof short[]) {
            return Arrays.equals((short[])obj1, (short[])obj2);
        }
        if (obj1 instanceof boolean[] && obj2 instanceof boolean[]) {
            return Arrays.equals((boolean[])obj1, (boolean[])obj2);
        }
        return false;
    }

    public static boolean equal(float val1, float val2) {
        return Float.floatToIntBits(val1) == Float.floatToIntBits(val2);
    }

    public static boolean equalWithTolerance(float val1, float val2, double tolerance) {
        return Float.floatToIntBits(val1) == Float.floatToIntBits(val2) || (double)Math.abs(val1 - val2) <= tolerance;
    }

    public static boolean equal(double val1, double val2) {
        return Double.doubleToLongBits(val1) == Double.doubleToLongBits(val2);
    }

    public static boolean equalWithTolerance(double val1, double val2, double tolerance) {
        return Double.doubleToLongBits(val1) == Double.doubleToLongBits(val2) || Math.abs(val1 - val2) <= tolerance;
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            return JodaBeanUtils.hashCodeArray(obj);
        }
        return obj.hashCode();
    }

    private static int hashCodeArray(Object obj) {
        if (obj instanceof Object[]) {
            return Arrays.deepHashCode((Object[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.hashCode((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.hashCode((long[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.hashCode((byte[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.hashCode((double[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.hashCode((float[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.hashCode((char[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.hashCode((short[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.hashCode((boolean[])obj);
        }
        return obj.hashCode();
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public static int hashCode(double value) {
        return JodaBeanUtils.hashCode(Double.doubleToLongBits(value));
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass().isArray()) {
            return JodaBeanUtils.toStringArray(obj);
        }
        return obj.toString();
    }

    private static String toStringArray(Object obj) {
        if (obj instanceof Object[]) {
            return Arrays.deepToString((Object[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        return obj.toString();
    }

    public static boolean propertiesEqual(Bean bean1, Bean bean2) {
        Set<String> names = bean1.propertyNames();
        if (!names.equals(bean2.propertyNames())) {
            return false;
        }
        for (String name : names) {
            Object value2;
            Object value1 = bean1.property(name).get();
            if (JodaBeanUtils.equal(value1, value2 = bean2.property(name).get())) continue;
            return false;
        }
        return true;
    }

    public static int propertiesHashCode(Bean bean) {
        int hash = 7;
        Set<String> names = bean.propertyNames();
        for (String name : names) {
            Object value = bean.property(name).get();
            hash += JodaBeanUtils.hashCode(value);
        }
        return hash;
    }

    public static String propertiesToString(Bean bean, String prefix) {
        Set<String> names = bean.propertyNames();
        StringBuilder buf = prefix != null ? new StringBuilder(names.size() * 32 + prefix.length()).append(prefix) : new StringBuilder(names.size() * 32);
        buf.append('{');
        if (names.size() > 0) {
            for (String name : names) {
                Object value = bean.property(name).get();
                buf.append(name).append('=').append(value).append(',').append(' ');
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append('}');
        return buf.toString();
    }

    public static Map<String, Object> flatten(Bean bean) {
        Map<String, MetaProperty<?>> propertyMap = bean.metaBean().metaPropertyMap();
        LinkedHashMap map = new LinkedHashMap(propertyMap.size());
        for (Map.Entry<String, MetaProperty<?>> entry : propertyMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get(bean));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T extends Bean> T clone(T original) {
        if (original == null || original instanceof ImmutableBean) {
            return original;
        }
        return JodaBeanUtils.cloneAlways(original);
    }

    public static <T extends Bean> T cloneAlways(T original) {
        BeanBuilder<? extends Bean> builder = original.metaBean().builder();
        for (MetaProperty<?> mp : original.metaBean().metaPropertyIterable()) {
            if (!mp.style().isBuildable()) continue;
            Object value = mp.get(original);
            builder.set(mp.name(), Cloner.INSTANCE.clone(value));
        }
        return (T)builder.build();
    }

    public static void notNull(Object value, String propertyName) {
        if (value == null) {
            throw new IllegalArgumentException(JodaBeanUtils.notNullMsg(propertyName));
        }
    }

    private static String notNullMsg(String propertyName) {
        return "Argument '" + propertyName + "' must not be null";
    }

    public static void notBlank(String value, String propertyName) {
        if (JodaBeanUtils.isBlank(value)) {
            throw new IllegalArgumentException(JodaBeanUtils.notBlank(propertyName));
        }
    }

    private static boolean isBlank(String str) {
        int strLen;
        int n = strLen = str != null ? str.length() : 0;
        if (strLen != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static String notBlank(String propertyName) {
        return "Argument '" + propertyName + "' must not be empty";
    }

    public static void notEmpty(String value, String propertyName) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException(JodaBeanUtils.notEmpty(propertyName));
        }
    }

    private static String notEmpty(String propertyName) {
        return "Argument '" + propertyName + "' must not be empty";
    }

    public static void notEmpty(Collection<?> value, String propertyName) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(JodaBeanUtils.notEmpty(propertyName));
        }
    }

    public static void notEmpty(Map<?, ?> value, String propertyName) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(JodaBeanUtils.notEmpty(propertyName));
        }
    }

    public static Class<?> collectionType(Property<?> prop) {
        return JodaBeanUtils.collectionType(prop.metaProperty(), prop.bean().getClass());
    }

    public static Class<?> collectionType(MetaProperty<?> prop, Class<?> targetClass) {
        return JodaBeanUtils.extractTypeClass(prop, targetClass, 1, 0);
    }

    public static List<Class<?>> collectionTypeTypes(MetaProperty<?> prop, Class<?> targetClass) {
        Type type = JodaBeanUtils.extractType(targetClass, prop, 1, 0);
        return JodaBeanUtils.extractTypeClasses(targetClass, type);
    }

    public static Class<?> mapKeyType(Property<?> prop) {
        return JodaBeanUtils.mapKeyType(prop.metaProperty(), prop.bean().getClass());
    }

    public static Class<?> mapKeyType(MetaProperty<?> prop, Class<?> targetClass) {
        return JodaBeanUtils.extractTypeClass(prop, targetClass, 2, 0);
    }

    public static Class<?> mapValueType(Property<?> prop) {
        return JodaBeanUtils.mapValueType(prop.metaProperty(), prop.bean().getClass());
    }

    public static Class<?> mapValueType(MetaProperty<?> prop, Class<?> targetClass) {
        return JodaBeanUtils.extractTypeClass(prop, targetClass, 2, 1);
    }

    public static List<Class<?>> mapValueTypeTypes(MetaProperty<?> prop, Class<?> targetClass) {
        Type type = JodaBeanUtils.extractType(targetClass, prop, 2, 1);
        return JodaBeanUtils.extractTypeClasses(targetClass, type);
    }

    public static Class<?> extractTypeClass(MetaProperty<?> prop, Class<?> targetClass, int size, int index) {
        return JodaBeanUtils.eraseToClass(JodaBeanUtils.extractType(targetClass, prop, size, index));
    }

    private static Type extractType(Class<?> targetClass, MetaProperty<?> prop, int size, int index) {
        ParameterizedType pt;
        Type[] types;
        Type genType = prop.propertyGenericType();
        if (genType instanceof ParameterizedType && (types = (pt = (ParameterizedType)genType).getActualTypeArguments()).length == size) {
            Type type = types[index];
            if (type instanceof TypeVariable) {
                type = JodaBeanUtils.resolveGenerics(targetClass, (TypeVariable)type);
            }
            return type;
        }
        return null;
    }

    private static List<Class<?>> extractTypeClasses(Class<?> targetClass, Type type) {
        ArrayList result = new ArrayList();
        if (type != null && type instanceof ParameterizedType) {
            Type[] actualTypes;
            ParameterizedType pt = (ParameterizedType)type;
            for (Type actualType : actualTypes = pt.getActualTypeArguments()) {
                Class<?> cls;
                if (actualType instanceof TypeVariable) {
                    actualType = JodaBeanUtils.resolveGenerics(targetClass, (TypeVariable)actualType);
                }
                result.add((cls = JodaBeanUtils.eraseToClass(actualType)) != null ? cls : Object.class);
            }
        }
        return result;
    }

    private static Type resolveGenerics(Class<?> targetClass, TypeVariable<?> typevar) {
        HashMap resolved = new HashMap();
        Type type = targetClass;
        while (type != null) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)type;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            Class<?> rawType = JodaBeanUtils.eraseToClass(pt.getRawType());
            if (rawType == null) {
                return null;
            }
            TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolved.put(typeParameters[i], actualTypeArguments[i]);
            }
            type = rawType.getGenericSuperclass();
        }
        Type result = typevar;
        while (resolved.containsKey(result)) {
            result = (Type)resolved.get(result);
        }
        return result;
    }

    private static Class<?> eraseToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return JodaBeanUtils.eraseToClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = JodaBeanUtils.eraseToClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
        } else if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            if (bounds.length == 0) {
                return Object.class;
            }
            return JodaBeanUtils.eraseToClass(bounds[0]);
        }
        return null;
    }

    public static boolean equalIgnoring(Bean bean1, Bean bean2, MetaProperty<?> ... properties) {
        JodaBeanUtils.notNull(bean1, "bean1");
        JodaBeanUtils.notNull(bean2, "bean2");
        JodaBeanUtils.notNull(properties, "properties");
        if (bean1 == bean2) {
            return true;
        }
        if (bean1.getClass() != bean2.getClass()) {
            return false;
        }
        switch (properties.length) {
            case 0: {
                return bean1.equals(bean2);
            }
            case 1: {
                MetaProperty<?> ignored = properties[0];
                for (MetaProperty<?> mp : bean1.metaBean().metaPropertyIterable()) {
                    if (ignored.equals(mp) || JodaBeanUtils.equal(mp.get(bean1), mp.get(bean2))) continue;
                    return false;
                }
                return true;
            }
        }
        HashSet ignored = new HashSet(Arrays.asList(properties));
        for (MetaProperty<?> mp : bean1.metaBean().metaPropertyIterable()) {
            if (ignored.contains(mp) || JodaBeanUtils.equal(mp.get(bean1), mp.get(bean2))) continue;
            return false;
        }
        return true;
    }

    public static Iterator<Bean> beanIterator(Bean bean) {
        return new BeanIterator(bean);
    }

    public static <P> Function<Bean, P> chain(MetaProperty<? extends Bean> mp1, MetaProperty<P> mp2) {
        JodaBeanUtils.notNull(mp1, "MetaProperty 1");
        JodaBeanUtils.notNull(mp1, "MetaProperty 2");
        return b -> {
            Bean first = (Bean)mp1.get((Bean)b);
            return first != null ? mp2.get(first) : null;
        };
    }

    public static <P> Function<Bean, P> chain(Function<Bean, ? extends Bean> fn1, MetaProperty<P> mp2) {
        JodaBeanUtils.notNull(fn1, "Function 1");
        JodaBeanUtils.notNull(fn1, "MetaProperty 2");
        return b -> {
            Bean first = (Bean)fn1.apply((Bean)b);
            return first != null ? mp2.get(first) : null;
        };
    }

    public static Comparator<Bean> comparator(Function<Bean, ?> query, boolean ascending) {
        return ascending ? JodaBeanUtils.comparatorAscending(query) : JodaBeanUtils.comparatorDescending(query);
    }

    public static Comparator<Bean> comparatorAscending(Function<Bean, ?> query) {
        if (query == null) {
            throw new NullPointerException("Function must not be null");
        }
        return new Comp(query);
    }

    public static Comparator<Bean> comparatorDescending(Function<Bean, ?> query) {
        if (query == null) {
            throw new NullPointerException("Function must not be null");
        }
        return Collections.reverseOrder(new Comp(query));
    }

    private static class CollectCloner
    extends GuavaCloner {
        CollectCloner() {
        }

        @Override
        Object clone(Object value) {
            if (value == null) {
                return value;
            }
            if (value instanceof ImmutableGrid) {
                return value;
            }
            if (value instanceof DenseGrid) {
                Grid grid = (Grid)value;
                return this.cloneGrid(grid, (Grid)DenseGrid.create((int)grid.rowCount(), (int)grid.columnCount()));
            }
            if (value instanceof Grid) {
                Grid grid = (Grid)value;
                return this.cloneGrid(grid, (Grid)SparseGrid.create((int)grid.rowCount(), (int)grid.columnCount()));
            }
            return super.clone(value);
        }

        Object cloneGrid(Grid original, Grid cloned) {
            for (Object item : original.cells()) {
                Grid.Cell cell = (Grid.Cell)item;
                cloned.put(cell.getRow(), cell.getColumn(), this.clone(cell.getValue()));
            }
            return cloned;
        }
    }

    private static class GuavaCloner
    extends Cloner {
        GuavaCloner() {
        }

        @Override
        Object clone(Object value) {
            if (value == null) {
                return value;
            }
            if (value instanceof ImmutableMap || value instanceof ImmutableCollection || value instanceof ImmutableMap || value instanceof ImmutableMultimap || value instanceof ImmutableTable) {
                return value;
            }
            if (value instanceof Multiset) {
                return JodaBeanUtils.cloneAlways((Bean)value);
            }
            if (value instanceof SortedMultiset) {
                SortedMultiset set = (SortedMultiset)value;
                return this.cloneIterable((Iterable)set, (Collection)TreeMultiset.create((Comparator)set.comparator()));
            }
            if (value instanceof Multiset) {
                return this.cloneIterable((Iterable)((Multiset)value), (Collection)LinkedHashMultiset.create());
            }
            if (value instanceof SetMultimap) {
                return this.cloneMultimap((Multimap)value, (Multimap)LinkedHashMultimap.create());
            }
            if (value instanceof ListMultimap) {
                return this.cloneMultimap((Multimap)value, (Multimap)ArrayListMultimap.create());
            }
            if (value instanceof Multimap) {
                return this.cloneMultimap((Multimap)value, (Multimap)ArrayListMultimap.create());
            }
            if (value instanceof BiMap) {
                return this.cloneMap((Map)((BiMap)value), (Map)HashBiMap.create());
            }
            if (value instanceof Table) {
                return this.cloneTable((Table)value, (Table)HashBasedTable.create());
            }
            return super.clone(value);
        }

        Object cloneMultimap(Multimap original, Multimap cloned) {
            for (Object key : original.keySet()) {
                Collection values = original.get(key);
                for (Object value : values) {
                    cloned.put(this.clone(key), this.clone(value));
                }
            }
            return cloned;
        }

        Object cloneTable(Table original, Table cloned) {
            for (Object item : original.cellSet()) {
                Table.Cell cell = (Table.Cell)item;
                cloned.put(this.clone(cell.getRowKey()), this.clone(cell.getColumnKey()), this.clone(cell.getValue()));
            }
            return cloned;
        }
    }

    private static class Cloner {
        public static final Cloner INSTANCE = Cloner.getInstance();

        private static Cloner getInstance() {
            try {
                Class.forName("org.joda.collect.grid.Grid");
                return new CollectCloner();
            }
            catch (Exception | LinkageError ex) {
                try {
                    Class.forName("com.google.common.collect.Multimap");
                    return new GuavaCloner();
                }
                catch (Exception | LinkageError ex2) {
                    return new Cloner();
                }
            }
        }

        Cloner() {
        }

        Object clone(Object value) {
            if (value == null) {
                return value;
            }
            if (value instanceof Bean) {
                return JodaBeanUtils.cloneAlways((Bean)value);
            }
            if (value instanceof SortedSet) {
                SortedSet set = (SortedSet)value;
                return this.cloneIterable(set, new TreeSet(set.comparator()));
            }
            if (value instanceof Set) {
                return this.cloneIterable((Set)value, new LinkedHashSet());
            }
            if (value instanceof Iterable) {
                return this.cloneIterable((Iterable)value, new ArrayList());
            }
            if (value instanceof SortedMap) {
                SortedMap map = (SortedMap)value;
                return this.cloneMap(map, new TreeMap(map.comparator()));
            }
            if (value instanceof Map) {
                return this.cloneMap((Map)value, new LinkedHashMap());
            }
            if (value.getClass().isArray()) {
                return this.cloneArray(value);
            }
            if (value instanceof Date) {
                return ((Date)value).clone();
            }
            return value;
        }

        Object cloneIterable(Iterable original, Collection cloned) {
            for (Object item : original) {
                cloned.add(this.clone(item));
            }
            return cloned;
        }

        Object cloneMap(Map original, Map cloned) {
            Iterator iterator = original.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item;
                Map.Entry entry = item = iterator.next();
                cloned.put(this.clone(entry.getKey()), this.clone(entry.getValue()));
            }
            return cloned;
        }

        Object cloneArray(Object original) {
            int len = Array.getLength(original);
            Class<?> arrayType = original.getClass().getComponentType();
            Object copy = Array.newInstance(arrayType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(copy, i, this.clone(Array.get(original, i)));
            }
            return copy;
        }
    }

    private static final class Comp
    implements Comparator<Bean> {
        private final Function<Bean, ?> query;

        private Comp(Function<Bean, ?> query) {
            this.query = query;
        }

        @Override
        public int compare(Bean bean1, Bean bean2) {
            Comparable value1 = (Comparable)this.query.apply(bean1);
            Object value2 = this.query.apply(bean2);
            return value1.compareTo(value2);
        }
    }
}

