/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.light;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicMetaProperty;

final class LightMetaProperty<P>
extends BasicMetaProperty<P> {
    private final MetaBean metaBean;
    private final Class<P> propertyType;
    private final Type propertyGenericType;
    private final List<Annotation> annotations;
    private final MethodHandle getter;
    private final MethodHandle setter;
    private final int constructorIndex;
    private final PropertyStyle style;

    static <P> LightMetaProperty<P> of(MetaBean metaBean, Field field, MethodHandles.Lookup lookup, String propertyName, int constructorIndex) {
        MethodHandle getter;
        try {
            getter = lookup.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        catch (NoSuchFieldException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        MethodHandle setter = null;
        if (!Modifier.isFinal(field.getModifiers())) {
            try {
                setter = lookup.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
            }
            catch (NoSuchFieldException ex) {
                throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
            }
        }
        return new LightMetaProperty(metaBean, propertyName, field.getType(), field.getGenericType(), Arrays.asList(field.getAnnotations()), getter, setter, constructorIndex, LightMetaProperty.calculateStyle(metaBean, setter));
    }

    static <P> LightMetaProperty<P> of(MetaBean metaBean, Field field, Method getMethod, Method setMethod, MethodHandles.Lookup lookup, String propertyName, int constructorIndex) {
        MethodHandle getter;
        try {
            MethodType type = MethodType.methodType(getMethod.getReturnType(), getMethod.getParameterTypes());
            getter = lookup.findVirtual(field.getDeclaringClass(), getMethod.getName(), type);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        MethodHandle setter = null;
        if (setMethod != null) {
            try {
                MethodType type = MethodType.methodType(Void.TYPE, setMethod.getParameterTypes());
                setter = lookup.findVirtual(field.getDeclaringClass(), setMethod.getName(), type);
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("Property cannot be written: " + propertyName, ex);
            }
            catch (NoSuchMethodException ex) {
                throw new UnsupportedOperationException("Property cannot be written: " + propertyName, ex);
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException("Property cannot be written: " + propertyName, ex);
            }
        }
        return new LightMetaProperty(metaBean, propertyName, field.getType(), field.getGenericType(), Arrays.asList(field.getAnnotations()), getter, setter, constructorIndex, LightMetaProperty.calculateStyle(metaBean, setter));
    }

    private static PropertyStyle calculateStyle(MetaBean metaBean, MethodHandle setter) {
        if (ImmutableBean.class.isAssignableFrom(metaBean.beanType())) {
            return PropertyStyle.IMMUTABLE;
        }
        return setter != null ? PropertyStyle.READ_WRITE : PropertyStyle.READ_ONLY;
    }

    static <P> LightMetaProperty<P> of(MetaBean metaBean, Method getMethod, MethodHandles.Lookup lookup, String propertyName, int constructorIndex) {
        MethodHandle getter;
        try {
            getter = lookup.unreflect(getMethod);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + propertyName, ex);
        }
        return new LightMetaProperty(metaBean, propertyName, getMethod.getReturnType(), getMethod.getGenericReturnType(), Arrays.asList(getMethod.getAnnotations()), getter, null, constructorIndex, PropertyStyle.DERIVED);
    }

    LightMetaProperty(MetaBean metaBean, String propertyName, Class<P> propertyType, Type propertyGenericType, List<Annotation> annotations, MethodHandle getter, MethodHandle setter, int constructorIndex, PropertyStyle style) {
        super(propertyName);
        this.metaBean = metaBean;
        this.propertyType = propertyType;
        this.propertyGenericType = propertyGenericType;
        this.annotations = annotations;
        this.getter = getter.asType(MethodType.methodType(Object.class, Bean.class));
        this.setter = setter != null ? setter.asType(MethodType.methodType(Void.TYPE, Bean.class, Object.class)) : null;
        this.constructorIndex = constructorIndex;
        this.style = style;
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.metaBean.beanType();
    }

    @Override
    public Class<P> propertyType() {
        return this.propertyType;
    }

    @Override
    public Type propertyGenericType() {
        return this.propertyGenericType;
    }

    @Override
    public PropertyStyle style() {
        return this.style;
    }

    @Override
    public List<Annotation> annotations() {
        return this.annotations;
    }

    @Override
    public P get(Bean bean) {
        try {
            return (P)this.getter.invokeExact(bean);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void set(Bean bean, Object value) {
        if (this.setter == null) {
            throw new UnsupportedOperationException("Property cannot be written: " + this.name());
        }
        try {
            this.setter.invokeExact(bean, value);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    int getConstructorIndex() {
        return this.constructorIndex;
    }
}

