/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.json;

import java.io.IOException;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerOptional;
import org.joda.beans.ser.json.JsonOutput;
import org.joda.convert.StringConverter;

public class JodaBeanSimpleJsonWriter {
    private final JodaBeanSer settings;
    private JsonOutput output;

    public JodaBeanSimpleJsonWriter(JodaBeanSer settings) {
        JodaBeanUtils.notNull(settings, "settings");
        this.settings = settings;
    }

    public String write(Bean bean) {
        StringBuilder buf = new StringBuilder(1024);
        try {
            this.write(bean, buf);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return buf.toString();
    }

    public void write(Bean bean, Appendable output) throws IOException {
        JodaBeanUtils.notNull(bean, "bean");
        JodaBeanUtils.notNull(output, "output");
        this.output = new JsonOutput(output, this.settings.getIndent(), this.settings.getNewLine());
        this.writeBean(bean, bean.getClass());
        output.append(this.settings.getNewLine());
    }

    private void writeBean(Bean bean, Class<?> declaredType) throws IOException {
        this.output.writeObjectStart();
        for (MetaProperty<?> prop : bean.metaBean().metaPropertyIterable()) {
            Object value;
            if (!prop.style().isSerializable() || (value = SerOptional.extractValue(prop, bean)) == null) continue;
            this.output.writeObjectKey(prop.name());
            Class<?> propType = SerOptional.extractType(prop, bean.getClass());
            if (value instanceof Bean) {
                if (this.settings.getConverter().isConvertible(value.getClass())) {
                    this.writeSimple(propType, value);
                    continue;
                }
                this.writeBean((Bean)value, propType);
                continue;
            }
            SerIterator itemIterator = this.settings.getIteratorFactory().create(value, prop, bean.getClass());
            if (itemIterator != null) {
                this.writeElements(itemIterator);
                continue;
            }
            this.writeSimple(propType, value);
        }
        this.output.writeObjectEnd();
    }

    private void writeElements(SerIterator itemIterator) throws IOException {
        if (itemIterator.category() == SerCategory.MAP) {
            this.writeMap(itemIterator);
        } else if (itemIterator.category() == SerCategory.COUNTED) {
            this.writeCounted(itemIterator);
        } else if (itemIterator.category() == SerCategory.TABLE) {
            this.writeTable(itemIterator);
        } else if (itemIterator.category() == SerCategory.GRID) {
            this.writeGrid(itemIterator);
        } else {
            this.writeArray(itemIterator);
        }
    }

    private void writeArray(SerIterator itemIterator) throws IOException {
        this.output.writeArrayStart();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            this.output.writeArrayItemStart();
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
        }
        this.output.writeArrayEnd();
    }

    private void writeMap(SerIterator itemIterator) throws IOException {
        if (this.settings.getConverter().isConvertible(itemIterator.keyType())) {
            this.writeMapSimple(itemIterator);
        } else {
            this.writeMapComplex(itemIterator);
        }
    }

    private void writeMapSimple(SerIterator itemIterator) throws IOException {
        StringConverter keyConverter = this.settings.getConverter().findConverterNoGenerics(itemIterator.keyType());
        this.output.writeObjectStart();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Object key = itemIterator.key();
            if (key == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be null");
            }
            String str = keyConverter.convertToString(itemIterator.key());
            if (str == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be a null string");
            }
            this.output.writeObjectKey(str);
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
        }
        this.output.writeObjectEnd();
    }

    private void writeMapComplex(SerIterator itemIterator) throws IOException {
        this.output.writeObjectStart();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Object key = itemIterator.key();
            if (key == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be null");
            }
            String str = this.settings.getConverter().convertToString(itemIterator.key());
            if (str == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be a null string");
            }
            this.output.writeObjectKey(str);
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
        }
        this.output.writeObjectEnd();
    }

    private void writeTable(SerIterator itemIterator) throws IOException {
        this.output.writeArrayStart();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            this.output.writeArrayItemStart();
            this.output.writeArrayStart();
            this.output.writeArrayItemStart();
            this.writeObject(itemIterator.keyType(), itemIterator.key(), null);
            this.output.writeArrayItemStart();
            this.writeObject(itemIterator.columnType(), itemIterator.column(), null);
            this.output.writeArrayItemStart();
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            this.output.writeArrayEnd();
        }
        this.output.writeArrayEnd();
    }

    private void writeGrid(SerIterator itemIterator) throws IOException {
        this.output.writeArrayStart();
        this.output.writeArrayItemStart();
        this.output.writeInt(itemIterator.dimensionSize(0));
        this.output.writeArrayItemStart();
        this.output.writeInt(itemIterator.dimensionSize(1));
        while (itemIterator.hasNext()) {
            itemIterator.next();
            this.output.writeArrayItemStart();
            this.output.writeArrayStart();
            this.output.writeArrayItemStart();
            this.output.writeInt((Integer)itemIterator.key());
            this.output.writeArrayItemStart();
            this.output.writeInt((Integer)itemIterator.column());
            this.output.writeArrayItemStart();
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            this.output.writeArrayEnd();
        }
        this.output.writeArrayEnd();
    }

    private void writeCounted(SerIterator itemIterator) throws IOException {
        this.output.writeArrayStart();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            this.output.writeArrayItemStart();
            this.output.writeArrayStart();
            this.output.writeArrayItemStart();
            this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            this.output.writeArrayItemStart();
            this.output.writeInt(itemIterator.count());
            this.output.writeArrayEnd();
        }
        this.output.writeArrayEnd();
    }

    private void writeObject(Class<?> declaredType, Object obj, SerIterator parentIterator) throws IOException {
        if (obj == null) {
            this.output.writeNull();
        } else if (this.settings.getConverter().isConvertible(obj.getClass())) {
            this.writeSimple(declaredType, obj);
        } else if (obj instanceof Bean) {
            this.writeBean((Bean)obj, declaredType);
        } else if (parentIterator != null) {
            SerIterator childIterator = this.settings.getIteratorFactory().createChild(obj, parentIterator);
            if (childIterator != null) {
                this.writeElements(childIterator);
            } else {
                this.writeSimple(declaredType, obj);
            }
        } else {
            this.writeSimple(declaredType, obj);
        }
    }

    private void writeSimple(Class<?> declaredType, Object value) throws IOException {
        Class<?> realType = value.getClass();
        if (realType == Integer.class) {
            this.output.writeInt((Integer)value);
        } else if (realType == Long.class) {
            this.output.writeLong((Long)value);
        } else if (realType == Short.class) {
            this.output.writeInt(((Short)value).shortValue());
        } else if (realType == Byte.class) {
            this.output.writeInt(((Byte)value).byteValue());
        } else if (realType == Float.class) {
            float flt = ((Float)value).floatValue();
            if (Float.isNaN(flt)) {
                this.output.writeNull();
            } else if (Float.isInfinite(flt)) {
                this.output.writeString(Float.toString(flt));
            } else {
                this.output.writeFloat(flt);
            }
        } else if (realType == Double.class) {
            double dbl = (Double)value;
            if (Double.isNaN(dbl)) {
                this.output.writeNull();
            } else if (Double.isInfinite(dbl)) {
                this.output.writeString(Double.toString(dbl));
            } else {
                this.output.writeDouble(dbl);
            }
        } else if (realType == Boolean.class) {
            this.output.writeBoolean((Boolean)value);
        } else {
            try {
                String converted = this.settings.getConverter().convertToString(realType, value);
                if (converted == null) {
                    throw new IllegalArgumentException("Unable to write because converter returned a null string: " + value);
                }
                this.output.writeString(converted);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Unable to convert type " + declaredType.getName() + " for real type: " + realType.getName(), ex);
            }
        }
    }
}

