/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.xml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerOptional;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.beans.ser.xml.JodaBeanXml;

public class JodaBeanXmlReader {
    private final JodaBeanSer settings;
    private XMLEventReader reader;
    private String basePackage;
    private Map<String, Class<?>> knownTypes = new HashMap();

    public JodaBeanXmlReader(JodaBeanSer settings) {
        this.settings = settings;
    }

    public Bean read(String input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(String input, Class<T> rootType) {
        return this.read(new StringReader(input), rootType);
    }

    public Bean read(InputStream input) {
        return this.read(input, Bean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T read(InputStream input, Class<T> rootType) {
        try {
            try {
                this.reader = this.factory().createXMLEventReader(input);
                T t = this.read(rootType);
                return t;
            }
            finally {
                this.reader.close();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Bean read(Reader input) {
        return this.read(input, Bean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T read(Reader input, Class<T> rootType) {
        try {
            try {
                this.reader = this.factory().createXMLEventReader(input);
                T t = this.read(rootType);
                return t;
            }
            finally {
                this.reader.close();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private XMLInputFactory factory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        return factory;
    }

    private <T> T read(Class<T> rootType) throws Exception {
        String typeStr;
        StartElement start = this.advanceToStartElement();
        if (!start.getName().equals(JodaBeanXml.BEAN_QNAME)) {
            throw new IllegalArgumentException("Expected root element 'bean' but found '" + start.getName() + "'");
        }
        Attribute attr = start.getAttributeByName(JodaBeanXml.TYPE_QNAME);
        if (attr == null && rootType == Bean.class) {
            throw new IllegalArgumentException("Root element attribute must specify 'type'");
        }
        Class<Object> effectiveType = rootType;
        if (attr != null && !rootType.isAssignableFrom(effectiveType = SerTypeMapper.decodeType(typeStr = attr.getValue(), this.settings, null, this.knownTypes))) {
            throw new IllegalArgumentException("Specified root type is incompatible with XML root type: " + rootType.getName() + " and " + effectiveType.getName());
        }
        if (!Bean.class.isAssignableFrom(effectiveType)) {
            throw new IllegalArgumentException("Root type is not a Joda-Bean: " + effectiveType.getName());
        }
        this.basePackage = effectiveType.getPackage().getName() + ".";
        Object parsed = this.parseBean(effectiveType);
        return rootType.cast(parsed);
    }

    private Object parseBean(Class<?> beanType) throws Exception {
        String propName = "";
        try {
            XMLEvent event = null;
            if (this.settings.getConverter().isConvertible(beanType)) {
                StringBuilder buf = new StringBuilder();
                while (this.reader.hasNext()) {
                    event = this.nextEvent(">btxt ");
                    if (event.isCharacters()) {
                        buf.append(event.asCharacters().getData());
                        continue;
                    }
                    if (event.isEndElement()) {
                        return this.settings.getConverter().convertFromString(beanType, buf.toString());
                    }
                    if (!event.isStartElement()) {
                        if (!event.isEndDocument()) continue;
                        throw new IllegalArgumentException("Unexpected end of document");
                    }
                    break;
                }
            } else {
                event = this.nextEvent(">bean ");
            }
            SerDeserializer deser = this.settings.getDeserializers().findDeserializer(beanType);
            MetaBean metaBean = deser.findMetaBean(beanType);
            BeanBuilder<?> builder = deser.createBuilder(beanType, metaBean);
            while (!event.isEndElement()) {
                if (event.isStartElement()) {
                    StartElement start = event.asStartElement();
                    propName = start.getName().getLocalPart();
                    MetaProperty<?> metaProp = deser.findMetaProperty(beanType, metaBean, propName);
                    if (metaProp == null) {
                        int depth = 0;
                        event = this.nextEvent(" skip ");
                        while (!event.isEndElement() || depth > 0) {
                            if (event.isStartElement()) {
                                ++depth;
                            } else if (event.isEndElement()) {
                                --depth;
                            }
                            event = this.nextEvent(" skip ");
                        }
                    } else {
                        Object value;
                        Class<?> childType = this.parseTypeAttribute(start, SerOptional.extractType(metaProp, beanType));
                        if (Bean.class.isAssignableFrom(childType)) {
                            value = this.parseBean(childType);
                        } else {
                            SerIterable iterable = this.settings.getIteratorFactory().createIterable(metaProp, beanType);
                            if (iterable != null) {
                                value = this.parseIterable(start, iterable);
                            } else {
                                Attribute metaTypeAttr = start.getAttributeByName(JodaBeanXml.METATYPE_QNAME);
                                if (metaTypeAttr != null) {
                                    iterable = this.settings.getIteratorFactory().createIterable(metaTypeAttr.getValue(), this.settings, this.knownTypes);
                                    if (iterable == null) {
                                        throw new IllegalArgumentException("Invalid metaType");
                                    }
                                    value = this.parseIterable(start, iterable);
                                } else {
                                    String text = this.advanceAndParseText();
                                    value = this.settings.getConverter().convertFromString(childType, text);
                                }
                            }
                        }
                        deser.setValue(builder, metaProp, SerOptional.wrapValue(metaProp, beanType, value));
                    }
                    propName = "";
                }
                event = this.nextEvent(".bean ");
            }
            return deser.build(beanType, builder);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing bean: " + beanType.getName() + "::" + propName + ", " + ex.getMessage(), ex);
        }
    }

    private Object parseIterable(StartElement iterableEvent, SerIterable iterable) throws Exception {
        Attribute rowsAttr = iterableEvent.getAttributeByName(JodaBeanXml.ROWS_QNAME);
        Attribute columnsAttr = iterableEvent.getAttributeByName(JodaBeanXml.COLS_QNAME);
        if (rowsAttr != null && columnsAttr != null) {
            iterable.dimensions(new int[]{Integer.parseInt(rowsAttr.getValue()), Integer.parseInt(columnsAttr.getValue())});
        }
        XMLEvent event = this.nextEvent(">iter ");
        while (!event.isEndElement()) {
            if (event.isStartElement()) {
                QName expectedType;
                StartElement start = event.asStartElement();
                QName qName = expectedType = iterable.category() == SerCategory.MAP ? JodaBeanXml.ENTRY_QNAME : JodaBeanXml.ITEM_QNAME;
                if (!start.getName().equals(expectedType)) {
                    throw new IllegalArgumentException("Expected '" + expectedType.getLocalPart() + "' but found '" + start.getName() + "'");
                }
                int count = 1;
                Object key = null;
                Object column = null;
                Object value = null;
                if (iterable.category() == SerCategory.COUNTED) {
                    Attribute countAttr = start.getAttributeByName(JodaBeanXml.COUNT_QNAME);
                    if (countAttr != null) {
                        count = Integer.parseInt(countAttr.getValue());
                    }
                    value = this.parseValue(iterable, start);
                } else if (iterable.category() == SerCategory.TABLE || iterable.category() == SerCategory.GRID) {
                    Attribute rowAttr = start.getAttributeByName(JodaBeanXml.ROW_QNAME);
                    Attribute colAttr = start.getAttributeByName(JodaBeanXml.COL_QNAME);
                    if (rowAttr == null || colAttr == null) {
                        throw new IllegalArgumentException("Unable to read table as row/col attribute missing");
                    }
                    String rowStr = rowAttr.getValue();
                    key = iterable.keyType() != null ? this.settings.getConverter().convertFromString(iterable.keyType(), rowStr) : rowStr;
                    String colStr = colAttr.getValue();
                    column = iterable.columnType() != null ? this.settings.getConverter().convertFromString(iterable.columnType(), colStr) : colStr;
                    value = this.parseValue(iterable, start);
                } else if (iterable.category() == SerCategory.MAP) {
                    Attribute keyAttr = start.getAttributeByName(JodaBeanXml.KEY_QNAME);
                    if (keyAttr != null) {
                        String keyStr = keyAttr.getValue();
                        key = iterable.keyType() != null ? this.settings.getConverter().convertFromString(iterable.keyType(), keyStr) : keyStr;
                        value = this.parseValue(iterable, start);
                    } else {
                        event = this.nextEvent(">>map ");
                        int loop = 0;
                        while (!event.isEndElement()) {
                            if (event.isStartElement()) {
                                start = event.asStartElement();
                                if (!start.getName().equals(JodaBeanXml.ITEM_QNAME)) {
                                    throw new IllegalArgumentException("Expected 'item' but found '" + start.getName() + "'");
                                }
                                if (key == null) {
                                    key = this.parseKey(iterable, start);
                                } else {
                                    value = this.parseValue(iterable, start);
                                }
                                ++loop;
                            }
                            event = this.nextEvent("..map ");
                        }
                        if (loop != 2) {
                            throw new IllegalArgumentException("Expected 2 'item's but found " + loop);
                        }
                    }
                } else {
                    value = this.parseValue(iterable, start);
                }
                iterable.add(key, column, value, count);
            }
            event = this.nextEvent(".iter ");
        }
        return iterable.build();
    }

    private Object parseKey(SerIterable iterable, StartElement start) throws Exception {
        Class<?> childType = this.parseTypeAttribute(start, iterable.keyType());
        if (Bean.class.isAssignableFrom(childType) || this.settings.getConverter().isConvertible(childType)) {
            return this.parseBean(childType);
        }
        throw new IllegalArgumentException("Unable to read map as parsed key type is neither a bean nor a simple type: " + childType.getName());
    }

    private Object parseValue(SerIterable iterable, StartElement start) throws Exception {
        Object value;
        Attribute nullAttr = start.getAttributeByName(JodaBeanXml.NULL_QNAME);
        if (nullAttr != null) {
            if (!nullAttr.getValue().equals("true")) {
                throw new IllegalArgumentException("Unexpected value for null attribute");
            }
            this.advanceAndParseText();
            value = null;
        } else {
            Class<?> childType = this.parseTypeAttribute(start, iterable.valueType());
            if (Bean.class.isAssignableFrom(childType)) {
                value = this.parseBean(childType);
            } else {
                SerIterable childIterable = this.settings.getIteratorFactory().createIterable(iterable);
                if (childIterable != null) {
                    value = this.parseIterable(start, childIterable);
                } else {
                    Attribute metaTypeAttr = start.getAttributeByName(JodaBeanXml.METATYPE_QNAME);
                    if (metaTypeAttr != null) {
                        childIterable = this.settings.getIteratorFactory().createIterable(metaTypeAttr.getValue(), this.settings, this.knownTypes);
                        if (childIterable == null) {
                            throw new IllegalArgumentException("Invalid metaType");
                        }
                        value = this.parseIterable(start, childIterable);
                    } else {
                        String text = this.advanceAndParseText();
                        value = this.settings.getConverter().convertFromString(childType, text);
                    }
                }
            }
        }
        return value;
    }

    private Class<?> parseTypeAttribute(StartElement start, Class<?> defaultType) throws ClassNotFoundException {
        Attribute typeAttr = start.getAttributeByName(JodaBeanXml.TYPE_QNAME);
        if (typeAttr == null) {
            return defaultType == Object.class ? String.class : defaultType;
        }
        String typeStr = typeAttr.getValue();
        return this.settings.getDeserializers().decodeType(typeStr, this.settings, this.basePackage, this.knownTypes, defaultType);
    }

    private StartElement advanceToStartElement() throws Exception {
        while (this.reader.hasNext()) {
            XMLEvent event = this.nextEvent("advnc ");
            if (!event.isStartElement()) continue;
            return event.asStartElement();
        }
        throw new IllegalArgumentException("Unexpected end of document");
    }

    private String advanceAndParseText() throws Exception {
        StringBuilder buf = new StringBuilder();
        while (this.reader.hasNext()) {
            XMLEvent event = this.nextEvent("text  ");
            if (event.isCharacters()) {
                buf.append(event.asCharacters().getData());
                continue;
            }
            if (event.isEndElement()) {
                return buf.toString();
            }
            if (!event.isStartElement()) continue;
            throw new IllegalArgumentException("Unexpected start tag");
        }
        throw new IllegalArgumentException("Unexpected end of document");
    }

    private XMLEvent nextEvent(String location) throws Exception {
        XMLEvent event = this.reader.nextEvent();
        return event;
    }
}

