/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.convert.RenameHandler;

public final class SerTypeMapper {
    private static final Map<Class<?>, String> BASIC_TYPES;
    private static final Map<String, Class<?>> BASIC_TYPES_REVERSED;

    private SerTypeMapper() {
    }

    public static String encodeType(Class<?> cls, JodaBeanSer settings, String basePackage, Map<Class<?>, String> knownTypes) {
        Class<?> supr2;
        String result = BASIC_TYPES.get(cls);
        if (result != null) {
            return result;
        }
        Class<?> supr1 = cls.getSuperclass();
        if (supr1 != null && (supr2 = supr1.getSuperclass()) == Enum.class) {
            cls = supr1;
        }
        if (settings.isShortTypes()) {
            if (knownTypes != null && (result = knownTypes.get(cls)) != null) {
                return result;
            }
            result = cls.getName();
            if (basePackage != null && result.startsWith(basePackage) && Character.isUpperCase(result.charAt(basePackage.length())) && !BASIC_TYPES_REVERSED.containsKey(result.substring(basePackage.length()))) {
                result = result.substring(basePackage.length());
                if (knownTypes != null) {
                    knownTypes.put(cls, result);
                }
            } else if (knownTypes != null) {
                String simpleName = cls.getSimpleName();
                if (Character.isUpperCase(simpleName.charAt(0)) && !BASIC_TYPES_REVERSED.containsKey(simpleName) && !knownTypes.containsValue(simpleName)) {
                    knownTypes.put(cls, simpleName);
                } else {
                    knownTypes.put(cls, result);
                }
            }
        } else {
            result = cls.getName();
        }
        return result;
    }

    public static Class<?> decodeType(String className, JodaBeanSer settings, String basePackage, Map<String, Class<?>> knownTypes) throws ClassNotFoundException {
        return SerTypeMapper.decodeType0(className, settings, basePackage, knownTypes, null);
    }

    public static Class<?> decodeType(String className, JodaBeanSer settings, String basePackage, Map<String, Class<?>> knownTypes, Class<?> defaultType) throws ClassNotFoundException {
        return SerTypeMapper.decodeType0(className, settings, basePackage, knownTypes, defaultType);
    }

    private static Class<?> decodeType0(String className, JodaBeanSer settings, String basePackage, Map<String, Class<?>> knownTypes, Class<?> defaultType) throws ClassNotFoundException {
        Class result = BASIC_TYPES_REVERSED.get(className);
        if (result != null) {
            return result;
        }
        if (knownTypes != null && (result = knownTypes.get(className)) != null) {
            return result;
        }
        String fullName = className;
        boolean expanded = false;
        if (basePackage != null && className.length() > 0 && Character.isUpperCase(className.charAt(0))) {
            fullName = basePackage + className;
            expanded = true;
        }
        try {
            result = RenameHandler.INSTANCE.lookupType(fullName);
            if (knownTypes != null) {
                knownTypes.put(fullName, result);
                if (expanded) {
                    knownTypes.put(className, result);
                } else {
                    String simpleName = result.getSimpleName();
                    if (!fullName.equals(result.getName()) && RenameHandler.INSTANCE.getTypeRenames().containsKey(fullName) && result.getEnclosingClass() == null) {
                        simpleName = fullName.substring(fullName.lastIndexOf(".") + 1);
                    }
                    if (Character.isUpperCase(simpleName.charAt(0)) && !BASIC_TYPES_REVERSED.containsKey(simpleName) && !knownTypes.containsKey(simpleName)) {
                        knownTypes.put(simpleName, result);
                    }
                }
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            if (!fullName.equals(className)) {
                try {
                    result = RenameHandler.INSTANCE.lookupType(className);
                    if (knownTypes != null) {
                        knownTypes.put(className, result);
                    }
                    return result;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (defaultType == null) {
                throw ex;
            }
            return defaultType;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(String.class, "String");
        map.put(Long.class, "Long");
        map.put(Integer.class, "Integer");
        map.put(Short.class, "Short");
        map.put(Byte.class, "Byte");
        map.put(Character.class, "Character");
        map.put(Boolean.class, "Boolean");
        map.put(Double.class, "Double");
        map.put(Float.class, "Float");
        map.put(BigInteger.class, "BigInteger");
        map.put(BigDecimal.class, "BigDecimal");
        map.put(Locale.class, "Locale");
        map.put(Class.class, "Class");
        map.put(UUID.class, "UUID");
        map.put(URI.class, "URI");
        map.put(File.class, "File");
        HashMap reversed = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            reversed.put(entry.getValue(), entry.getKey());
        }
        BASIC_TYPES = Collections.unmodifiableMap(map);
        BASIC_TYPES_REVERSED = Collections.unmodifiableMap(reversed);
    }
}

