/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.direct;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.MinimalMetaProperty;

public final class MinimalMetaBean<T extends Bean>
implements TypedMetaBean<T> {
    private final Class<T> beanType;
    private final Supplier<BeanBuilder<T>> builderSupplier;
    private final Map<String, MetaProperty<?>> metaPropertyMap;

    @SafeVarargs
    public static <B extends Bean> MinimalMetaBean<B> of(Class<B> beanType, Supplier<BeanBuilder<B>> builderSupplier, Function<B, Object> ... getters) {
        if (getters == null) {
            throw new NullPointerException("Getter functions must not be null");
        }
        return new MinimalMetaBean<B>(beanType, builderSupplier, Arrays.asList(getters), Collections.nCopies(getters.length, null));
    }

    public static <B extends Bean> MinimalMetaBean<B> of(Class<B> beanType, Supplier<BeanBuilder<B>> builderSupplier, List<Function<B, Object>> getters, List<BiConsumer<B, Object>> setters) {
        if (getters == null) {
            throw new NullPointerException("Getter functions must not be null");
        }
        if (setters == null) {
            throw new NullPointerException("Setter functions must not be null");
        }
        return new MinimalMetaBean<B>(beanType, builderSupplier, getters, setters);
    }

    private MinimalMetaBean(Class<T> beanType, Supplier<BeanBuilder<T>> builderSupplier, List<Function<T, Object>> getters, List<BiConsumer<T, Object>> setters) {
        Method[] methods;
        if (beanType == null) {
            throw new NullPointerException("Bean class must not be null");
        }
        if (builderSupplier == null) {
            throw new NullPointerException("Supplier of BeanBuilder must not be null");
        }
        this.beanType = beanType;
        this.builderSupplier = builderSupplier;
        HashMap map = new HashMap();
        Field[] fields = (Field[])Stream.of(beanType.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getAnnotation(PropertyDefinition.class) != null).toArray(Field[]::new);
        if (fields.length != getters.size()) {
            throw new NullPointerException("Getter functions must match fields");
        }
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            map.put(name, new MinimalMetaProperty(this, name, fields[i], getters.get(i), setters.get(i)));
        }
        for (Method method : methods = beanType.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getAnnotation(DerivedProperty.class) == null || !method.getName().startsWith("get") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getParameterTypes().length != 0) continue;
            String methodName = method.getName();
            String propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            MinimalMetaProperty mp = new MinimalMetaProperty(this, method, propertyName);
            map.put(propertyName, mp);
        }
        this.metaPropertyMap = Collections.unmodifiableMap(map);
    }

    @Override
    public boolean isBuildable() {
        return true;
    }

    @Override
    public BeanBuilder<T> builder() {
        return this.builderSupplier.get();
    }

    @Override
    public Class<T> beanType() {
        return this.beanType;
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        return this.metaPropertyMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MinimalMetaBean) {
            MinimalMetaBean other = (MinimalMetaBean)obj;
            return this.beanType.equals(other.beanType);
        }
        return false;
    }

    public int hashCode() {
        return this.beanType.hashCode() + 3;
    }

    public String toString() {
        return "MetaBean:" + this.beanName();
    }
}

